/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space.spacestaion;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtocore.api.machine.part.GTOPartAbility;
import com.gtocore.common.data.machines.SpaceMultiblock;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.AbstractSpaceStation;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.Extension;
import com.gtolib.api.machine.feature.multiblock.ICrossRecipeMachine;
import com.gtolib.api.machine.trait.CrossRecipeTrait;
import com.gtolib.api.machine.trait.IEnhancedRecipeLogic;
import com.gtolib.api.recipe.IdleReason;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import earth.terrarium.adastra.api.planets.PlanetApi;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeExtension
extends Extension
implements ICrossRecipeMachine {
    private boolean hasLaserInput = false;
    @Persisted
    private final CrossRecipeTrait crossRecipeTrait;
    @NotNull
    private ToLongFunction<RecipeExtension> parallel = MachineUtils::getHatchParallel;

    public RecipeExtension(MetaMachineBlockEntity metaMachineBlockEntity) {
        super(metaMachineBlockEntity);
        this.crossRecipeTrait = new CrossRecipeTrait((ICrossRecipeMachine)this, false, true, machine -> this.parallel.applyAsLong((RecipeExtension)machine));
    }

    public RecipeExtension(MetaMachineBlockEntity metaMachineBlockEntity, @Nullable Function<AbstractSpaceStation, Set<BlockPos>> positionFunction) {
        super(metaMachineBlockEntity, positionFunction);
        this.crossRecipeTrait = new CrossRecipeTrait((ICrossRecipeMachine)this, false, true, machine -> this.parallel.applyAsLong((RecipeExtension)machine));
    }

    public void onPartScan(@NotNull IMultiPart iMultiPart) {
        super.onPartScan(iMultiPart);
        if (this.hasLaserInput) {
            return;
        }
        for (PartAbility partAbility : new PartAbility[]{PartAbility.INPUT_LASER, GTOPartAbility.OVERCLOCK_HATCH, GTOPartAbility.THREAD_HATCH}) {
            if (!partAbility.isApplicable(iMultiPart.self().getBlockState().m_60734_())) continue;
            this.hasLaserInput = true;
        }
    }

    @Override
    public void onStructureFormed() {
        this.hasLaserInput = false;
        super.onStructureFormed();
    }

    @Nullable
    public ICleanroomProvider getCleanroom() {
        return this;
    }

    public void setParallel(@NotNull ToLongFunction<RecipeExtension> parallel) {
        this.parallel = parallel;
    }

    @Override
    public void attachConfigurators(@NotNull ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        this.crossRecipeTrait.attachConfigurators(configuratorPanel);
    }

    @Override
    public Recipe getRecipe() {
        if (!PlanetApi.API.isSpace(this.getLevel()) || this.getRoot() == null || !this.getRoot().isWorkspaceReady()) {
            this.setIdleReason(IdleReason.CANNOT_WORK_IN_SPACE);
            return null;
        }
        return this.crossRecipeTrait.getRecipe();
    }

    public Recipe getRealRecipe(@NotNull Recipe recipe) {
        if (!this.isWorkspaceReady()) {
            this.setIdleReason(IdleReason.CANNOT_WORK_IN_SPACE);
            return null;
        }
        if (this.hasLaserInput && !this.core.canUseLaser()) {
            ((IEnhancedRecipeLogic)this.getRecipeLogic()).gtolib$setIdleReason((Component)Component.m_237110_((String)"gtocore.machine.spacestation.require_module", (Object[])new Object[]{Component.m_237115_((String)SpaceMultiblock.SPACE_STATION_ENERGY_CONVERSION_MODULE.getDescriptionId())}));
            return null;
        }
        return super.getRealRecipe(Objects.requireNonNull(RecipeModifierFunction.recipeReduction((double)1.0, (double)this.core.getDurationMultiplierFromSpaceElevator()).apply((MetaMachine)this, recipe)));
    }

    @Override
    @NotNull
    public RecipeLogic createRecipeLogic(Object ... args) {
        return new ICrossRecipeMachine.Logic((ICrossRecipeMachine)this, this::getRecipe);
    }

    public CrossRecipeTrait getCrossRecipeTrait() {
        return this.crossRecipeTrait;
    }
}

