/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space.spacestaion;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.ISpacePredicateMachine;
import com.gtolib.api.machine.feature.IWorkInSpaceMachine;
import com.gtolib.api.machine.feature.multiblock.ICustomHighlightMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpaceStation
extends ElectricMultiblockMachine
implements ISpacePredicateMachine,
ICustomHighlightMachine {
    @Nullable
    private Collection<IWorkInSpaceMachine> spaceMachines;
    @DescSynced
    private final Set<BlockPos> lastDistributedBlocks = new ObjectOpenHashSet();
    @Nullable
    private final Function<AbstractSpaceStation, Set<BlockPos>> positionFunction;
    @Persisted
    protected int ready;
    @Nullable
    private TickableSubscription tickSubscription = null;
    boolean shouldShowReadyText = true;
    private boolean firstLoad;

    AbstractSpaceStation(MetaMachineBlockEntity metaMachineBlockEntity) {
        super(metaMachineBlockEntity);
        this.positionFunction = null;
    }

    AbstractSpaceStation(MetaMachineBlockEntity metaMachineBlockEntity, @Nullable Function<AbstractSpaceStation, Set<BlockPos>> positionFunction) {
        super(metaMachineBlockEntity);
        this.positionFunction = positionFunction;
    }

    @Override
    public boolean firstLoad() {
        if (this.firstLoad) {
            this.firstLoad = false;
            return true;
        }
        return false;
    }

    public void onLoad() {
        super.onLoad();
        this.firstLoad = true;
        this.tickSubscription = this.subscribeServerTick(this.tickSubscription, this::tickReady);
    }

    protected void tickReady() {
        int time = this.getOffsetTimer();
        if (time % 20 == 0) {
            if (this.getRecipeLogic().isWorking()) {
                int oldReady = this.ready;
                this.ready = Math.min(20, this.ready + 1);
                if (this.ready == 10 && oldReady < 10) {
                    this.updateSpaceMachines();
                }
            } else {
                this.ready = Math.max(0, this.ready - 1);
            }
            if (this.ready == 0) {
                this.clearOxygenBlocks();
            }
        }
        if (time % 200 == 0) {
            this.updateSpaceMachines();
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubscription != null) {
            this.tickSubscription.unsubscribe();
            this.tickSubscription = null;
        }
    }

    @Override
    @Nullable
    public Collection<IWorkInSpaceMachine> getSpaceMachines() {
        return this.spaceMachines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSpaceMachines(@Nullable Collection<IWorkInSpaceMachine> spaceMachines) {
        AbstractSpaceStation abstractSpaceStation = this;
        synchronized (abstractSpaceStation) {
            this.spaceMachines = spaceMachines;
        }
    }

    @Override
    public void resetLastDistributedBlocks(Set<BlockPos> positions) {
        this.lastDistributedBlocks.removeAll(positions);
        this.clearOxygenBlocks();
        this.lastDistributedBlocks.addAll(positions);
    }

    public void onMachineRemoved() {
        super.onMachineRemoved();
        this.clearOxygenBlocks();
    }

    public void clearOxygenBlocks() {
        OxygenApi.API.removeOxygen(this.getLevel(), this.lastDistributedBlocks);
        TemperatureApi.API.removeTemperature(this.getLevel(), this.lastDistributedBlocks);
        this.lastDistributedBlocks.clear();
    }

    public void attachConfigurators(@NotNull ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        this.attachHighlightConfigurators(configuratorPanel);
    }

    public void updateSpaceMachines() {
        if (this.spaceMachines != null) {
            this.spaceMachines.forEach(m -> m.getRecipeLogic().updateTickSubscription());
        }
    }

    public int checkPriority() {
        return 5;
    }

    public boolean requiresServerCheck() {
        return true;
    }

    public boolean isWorkspaceReady() {
        return this.ready >= 10;
    }

    public void regressRecipe(RecipeLogic recipeLogic) {
        super.regressRecipe(recipeLogic);
        this.ready = 0;
    }

    public void customText(@NotNull List<Component> list) {
        super.customText(list);
        if (this.shouldShowReadyText) {
            list.add((Component)Component.m_237110_((String)"gtocore.machine.spacestation.ready", (Object[])new Object[]{Math.min(this.ready * 10, 100)}).m_130940_(ChatFormatting.YELLOW));
        }
    }

    public boolean isClean() {
        return this.isWorkspaceReady();
    }

    public int getReadyCount() {
        return this.ready;
    }

    @Nullable
    public Function<AbstractSpaceStation, Set<BlockPos>> getPositionFunction() {
        return this.positionFunction;
    }
}

