/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.machine.multiblock.electric.space.SpaceElevatorMachine;
import com.gtocore.common.machine.multiblock.electric.space.SuperSpaceElevatorMachine;
import com.gtolib.api.machine.multiblock.CustomParallelMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import java.util.List;
import java.util.function.ToLongFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpaceElevatorModuleMachine
extends CustomParallelMultiblockMachine {
    SpaceElevatorMachine spaceElevatorMachine;
    private final boolean powerModuleTier;

    public SpaceElevatorModuleMachine(MetaMachineBlockEntity holder, boolean powerModuleTier) {
        this(holder, powerModuleTier, m -> ((SpaceElevatorModuleMachine)((Object)m)).getSpaceElevatorTier() > 7 ? (long)((int)Math.pow(((SpaceElevatorModuleMachine)((Object)m)).isSuper() ? 8.0 : 4.0, ((SpaceElevatorModuleMachine)m).spaceElevatorMachine.getCasingTier("p_m") - 1)) : 0L);
    }

    SpaceElevatorModuleMachine(MetaMachineBlockEntity holder, boolean powerModuleTier, ToLongFunction<CustomParallelMultiblockMachine> getParallel) {
        super(holder, false, getParallel);
        this.powerModuleTier = powerModuleTier;
    }

    public int getSpaceElevatorTier() {
        if (this.spaceElevatorMachine != null && this.spaceElevatorMachine.getRecipeLogic().isWorking()) {
            return this.spaceElevatorMachine.getTier();
        }
        return 0;
    }

    private boolean isSuper() {
        return this.spaceElevatorMachine instanceof SuperSpaceElevatorMachine;
    }

    public void onUnload() {
        super.onUnload();
        this.spaceElevatorMachine = null;
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.spaceElevatorMachine = null;
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        if (this.getSpaceElevatorTier() < 8) {
            return null;
        }
        if (this.powerModuleTier && recipe.data.m_128451_("p_m") > this.spaceElevatorMachine.getCasingTier("p_m")) {
            return null;
        }
        return RecipeModifierFunction.overclocking((MetaMachine)this, (Recipe)ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)this.getParallel()), (boolean)false, (double)1.0, (double)this.getDurationMultiplier(), (double)0.5);
    }

    public boolean onWorking() {
        if (!super.onWorking()) {
            return false;
        }
        if (this.getOffsetTimer() % 10 == 0) {
            return this.getSpaceElevatorTier() >= 8;
        }
        return true;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237115_((String)("gtocore.machine.space_elevator." + (this.getSpaceElevatorTier() < 8 ? "not_" : "") + "connected")));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.duration_multiplier.tooltip", (Object[])new Object[]{FormattingUtil.formatNumbers((double)this.getDurationMultiplier())}));
    }

    private double getDurationMultiplier() {
        double mul = 1.0;
        if (this.spaceElevatorMachine != null) {
            mul = this.spaceElevatorMachine.netMachineCache == null ? 1.0 : this.spaceElevatorMachine.netMachineCache.getDurationMultiplier();
        }
        return Math.sqrt(mul / (double)((this.getSpaceElevatorTier() - 7) * (this.isSuper() ? 2 : 1)));
    }

    @Generated
    public SpaceElevatorMachine getSpaceElevatorMachine() {
        return this.spaceElevatorMachine;
    }
}

