/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfiguratorButton;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtocore.api.gui.GTOGuiTextures;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.machine.multiblock.electric.space.SpaceElevatorModuleMachine;
import com.gtocore.common.machine.multiblock.electric.space.spacestaion.SpaceElevatorConnectorModule;
import com.gtocore.data.IdleReason;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.capability.IIWirelessInteractor;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.machine.feature.multiblock.IHighlightMachine;
import com.gtolib.api.machine.multiblock.TierCasingMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.misc.PlanetManagement;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.MachineUtils;
import com.gtolib.utils.MathUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.common.menus.base.PlanetsMenuProvider;
import earth.terrarium.botarium.common.menu.ExtraDataMenuProvider;
import earth.terrarium.botarium.common.menu.MenuHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DataGeneratorScanned
public class SpaceElevatorMachine
extends TierCasingMultiblockMachine
implements IHighlightMachine,
IIWirelessInteractor<SpaceElevatorConnectorModule> {
    @DescSynced
    protected double high;
    @Persisted
    @DescSynced
    protected int spoolCount;
    protected int moduleCount;
    @DescSynced
    final List<BlockPos> poss = new ArrayList<BlockPos>();
    SpaceElevatorConnectorModule netMachineCache;

    public SpaceElevatorMachine(MetaMachineBlockEntity holder) {
        super(holder, new String[]{"p_m"});
    }

    void initialize() {
        this.poss.clear();
        BlockPos blockPos = MachineUtils.getOffsetPos((int)3, (int)-2, (Direction)this.getFrontFacing(), (BlockPos)this.getPos());
        this.poss.add(blockPos.m_7918_(7, 2, 0));
        this.poss.add(blockPos.m_7918_(7, 2, 2));
        this.poss.add(blockPos.m_7918_(7, 2, -2));
        this.poss.add(blockPos.m_7918_(-7, 2, 0));
        this.poss.add(blockPos.m_7918_(-7, 2, 2));
        this.poss.add(blockPos.m_7918_(-7, 2, -2));
        this.poss.add(blockPos.m_7918_(0, 2, 7));
        this.poss.add(blockPos.m_7918_(2, 2, 7));
        this.poss.add(blockPos.m_7918_(-2, 2, 7));
        this.poss.add(blockPos.m_7918_(0, 2, -7));
        this.poss.add(blockPos.m_7918_(2, 2, -7));
        this.poss.add(blockPos.m_7918_(-2, 2, -7));
    }

    protected void update(boolean promptly) {
        if (promptly || this.getOffsetTimer() % 80 == 0) {
            this.moduleCount = 0;
            if (this.spoolCount < this.getMaxSpoolCount()) {
                this.forEachInputItems((stack, amount) -> {
                    if (stack.m_41720_() == GTOItems.NANOTUBE_SPOOL.get()) {
                        int count = Math.min(stack.m_41613_(), this.getMaxSpoolCount() - this.spoolCount);
                        if (count < 1) {
                            return true;
                        }
                        this.spoolCount += count;
                        this.inputItem((ItemLike)stack.m_41720_(), count);
                    }
                    return false;
                });
                return;
            }
            Level level = this.getLevel();
            if (level == null) {
                return;
            }
            for (BlockPos blockPoss : this.poss) {
                SpaceElevatorModuleMachine moduleMachine;
                MetaMachine metaMachine = SpaceElevatorMachine.getMachine((BlockGetter)level, (BlockPos)blockPoss);
                if (!(metaMachine instanceof SpaceElevatorModuleMachine) || !(moduleMachine = (SpaceElevatorModuleMachine)metaMachine).isFormed()) continue;
                if (moduleMachine.spaceElevatorMachine != this) {
                    moduleMachine.getRecipeLogic().updateTickSubscription();
                }
                moduleMachine.spaceElevatorMachine = this;
                ++this.moduleCount;
            }
        }
    }

    public int getMaxSpoolCount() {
        return 256;
    }

    int getBaseHigh() {
        return 40;
    }

    protected void onStructureFormedAfter() {
        super.onStructureFormedAfter();
        this.update(true);
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.initialize();
        this.high = this.getBaseHigh();
        if (!this.isRemote()) {
            this.getNetMachine();
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.removeNetMachineCache();
    }

    public void onUnload() {
        super.onUnload();
        this.removeNetMachineCache();
    }

    public void clientTick() {
        super.clientTick();
        if (this.getRecipeLogic().isWorking()) {
            this.high = (float)(12 * this.getBaseHigh() + 100) + (float)(100 + this.getBaseHigh()) * MathUtil.sin((float)((float)this.getOffsetTimer() / 160.0f));
        }
    }

    public boolean onWorking() {
        if (!super.onWorking()) {
            return false;
        }
        this.update(false);
        if (this.getRecipeLogic().getProgress() > 190) {
            this.getRecipeLogic().setProgress(1);
            this.getNetMachine();
        }
        return true;
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        this.update(false);
        if (this.spoolCount < this.getMaxSpoolCount()) {
            textList.add((Component)Component.m_237115_((String)"item.gtocore.nanotube_spool").m_130946_(": ").m_7220_((Component)Component.m_237110_((String)"gui.ae2.Missing", (Object[])new Object[]{this.getMaxSpoolCount() - this.spoolCount})));
        }
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.module", (Object[])new Object[]{this.moduleCount}));
        if (this.netMachineCache != null) {
            textList.add((Component)Component.m_237110_((String)"spacestation.space_elevator.connected_current_planet", (Object[])new Object[]{Math.sqrt(this.netMachineCache.getDurationMultiplier())}));
        } else {
            textList.add((Component)Component.m_237115_((String)"spacestation.space_elevator.not_connected_current_planet"));
        }
    }

    public void attachConfigurators(@NotNull ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        this.attachHighlightConfigurators(configuratorPanel);
        IFancyConfigurator[] iFancyConfiguratorArray = new IFancyConfigurator[1];
        iFancyConfiguratorArray[0] = new IFancyConfiguratorButton.Toggle((IGuiTexture)GTOGuiTextures.PLANET_TELEPORT.getSubTexture(0.0, 0.5, 1.0, 0.5), (IGuiTexture)GTOGuiTextures.PLANET_TELEPORT.getSubTexture(0.0, 0.0, 1.0, 0.5), () -> ((RecipeLogic)this.getRecipeLogic()).isWorking(), (clickData, pressed) -> {
            Player patt0$temp;
            if (!clickData.isRemote && this.getRecipeLogic().isWorking() && configuratorPanel.getGui() != null && (patt0$temp = configuratorPanel.getGui().entityPlayer) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                PlanetManagement.unlock((UUID)player.m_20148_(), (ResourceLocation)GTODimensions.BARNARDA_C);
                player.m_20049_("spaceelevatorst");
                MenuHooks.openMenu((ServerPlayer)player, (ExtraDataMenuProvider)new PlanetsMenuProvider());
            }
        }).setTooltipsSupplier(pressed -> List.of(Component.m_237115_((String)"gtocore.machine.space_elevator.set_out")));
        configuratorPanel.attachConfigurators(iFancyConfiguratorArray);
    }

    @Nullable
    private Recipe getRecipe() {
        if (this.getTier() > 7) {
            double exCWUt = this.netMachineCache == null ? 1.0 : 1.5;
            Recipe recipe = this.getRecipeBuilder().duration(400).CWUt((int)((double)(128 * (this.getTier() - 7)) * exCWUt)).EUt((long)GTValues.VA[this.getTier()]).buildRawRecipe();
            if (RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
                return recipe;
            }
        } else {
            this.setIdleReason(IdleReason.VOLTAGE_TIER_NOT_SATISFIES);
        }
        return null;
    }

    @NotNull
    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe, true);
    }

    public List<BlockPos> getHighlightPos() {
        return this.poss;
    }

    public Class<SpaceElevatorConnectorModule> getProviderClass() {
        return SpaceElevatorConnectorModule.class;
    }

    public boolean testMachine(SpaceElevatorConnectorModule machine) {
        return this.isFormed() && machine.isFormed() && machine.isWorkspaceReady();
    }

    public boolean firstTestMachine(SpaceElevatorConnectorModule machine) {
        Level level = machine.getLevel();
        if (level != null && this.testMachine(machine)) {
            machine.registerElevator(this, this.getCasingTier("p_m"));
            return true;
        }
        return false;
    }

    public void removeNetMachineCache() {
        if (this.netMachineCache != null) {
            this.netMachineCache.unregisterElevator(this);
            this.netMachineCache = null;
        }
    }

    public Level getTargetLevel() {
        if (this.isRemote() || this.getLevel() == null) {
            return null;
        }
        Planet planet = PlanetApi.API.getPlanet(this.getLevel());
        if (planet == null) {
            return null;
        }
        Optional orbitLevel = planet.orbit();
        if (orbitLevel.isEmpty()) {
            return null;
        }
        MinecraftServer server = this.getLevel().m_7654_();
        if (server == null) {
            return null;
        }
        return server.m_129880_((ResourceKey)orbitLevel.get());
    }

    @Generated
    public double getHigh() {
        return this.high;
    }

    @Generated
    public int getSpoolCount() {
        return this.spoolCount;
    }

    @Generated
    public SpaceElevatorConnectorModule getNetMachineCache() {
        return this.netMachineCache;
    }

    @Generated
    public void setNetMachineCache(SpaceElevatorConnectorModule netMachineCache) {
        this.netMachineCache = netMachineCache;
    }
}

