/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtocore.common.data.GTOFluids;
import com.gtocore.common.saved.DysonSphereSavaedData;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeRunner;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DysonSphereReceivingStationMcahine
extends ElectricMultiblockMachine {
    private ResourceKey<Level> dimension;

    public DysonSphereReceivingStationMcahine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    private ResourceKey<Level> getDimension() {
        if (this.dimension == null) {
            this.dimension = Objects.requireNonNull(this.getLevel()).m_46472_();
        }
        return this.dimension;
    }

    protected boolean beforeWorking(@NotNull Recipe recipe) {
        DysonSphereSavaedData.setDysonUse(this.getDimension(), true);
        return super.beforeWorking(recipe);
    }

    public void afterWorking() {
        super.afterWorking();
        DysonSphereSavaedData.setDysonUse(this.getDimension(), false);
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        DysonSphereSavaedData.setDysonUse(this.getDimension(), false);
    }

    @Nullable
    private Recipe getRecipe() {
        int integer;
        if (DysonSphereSavaedData.getDimensionUse(this.getDimension())) {
            return null;
        }
        IntIntImmutablePair pair = DysonSphereSavaedData.getDimensionData(this.getDimension());
        if (pair.leftInt() < 1) {
            return null;
        }
        if ((double)GTValues.RNG.m_188501_() < (double)0.01f * (1.0 + (double)pair.leftInt() / 128.0)) {
            if (pair.rightInt() > 99) {
                int count = pair.leftInt() - 1;
                if (count < 1) {
                    DysonSphereSavaedData.setDysonData(this.getDimension(), 0, 0);
                    return null;
                }
                DysonSphereSavaedData.setDysonData(this.getDimension(), count, 0);
            } else {
                DysonSphereSavaedData.setDysonData(this.getDimension(), pair.leftInt(), pair.rightInt() + 1);
            }
        }
        if ((integer = GTODimensions.getPlanetDistances((ResourceLocation)this.getDimension().m_135782_())) == 0) {
            return null;
        }
        Recipe recipe = this.getRecipeBuilder().duration(20).CWUt(Math.max(1, pair.leftInt() * integer / 2)).EUt(-GTValues.V[14] * (long)pair.leftInt() * (long)(50 - Math.max(0, pair.rightInt() - 60)) / 50L).inputFluids(new FluidStack((Fluid)GTOFluids.GELID_CRYOTHEUM.get(), Math.max(1, (int)Math.sqrt(pair.leftInt())))).buildRawRecipe();
        if (RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe) && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
            return recipe;
        }
        return null;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        IntIntImmutablePair pair = DysonSphereSavaedData.getDimensionData(this.getDimension());
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.dyson_sphere.number", (Object[])new Object[]{pair.leftInt()}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.dyson_sphere.voltage", (Object[])new Object[]{pair.leftInt() > 0 ? this.getOverclockVoltage() : 0L}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.fission_reactor.damaged", (Object[])new Object[]{pair.rightInt()}).m_130946_("%"));
    }
}

