/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.space;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gtocore.common.saved.DysonSphereSavaedData;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class DysonSphereLaunchSiloMachine
extends ElectricMultiblockMachine {
    private ResourceKey<Level> dimension;

    public DysonSphereLaunchSiloMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    private ResourceKey<Level> getDimension() {
        if (this.dimension == null) {
            this.dimension = Objects.requireNonNull(this.getLevel()).m_46472_();
        }
        return this.dimension;
    }

    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        int integer = GTODimensions.getPlanetDistances((ResourceLocation)this.getDimension().m_135782_());
        if (integer > 0) {
            recipe.duration = recipe.duration * integer / 4;
        }
        return recipe;
    }

    protected boolean beforeWorking(@NotNull Recipe recipe) {
        return GTODimensions.isPlanet((ResourceLocation)this.getDimension().m_135782_()) && super.beforeWorking(recipe);
    }

    public void onRecipeFinish() {
        super.onRecipeFinish();
        IntIntImmutablePair pair = DysonSphereSavaedData.getDimensionData(this.getDimension());
        if (pair.leftInt() < 10000) {
            if (pair.rightInt() > 60) {
                DysonSphereSavaedData.setDysonData(this.getDimension(), pair.leftInt(), 0);
            } else {
                DysonSphereSavaedData.setDysonData(this.getDimension(), pair.leftInt() + 1, pair.rightInt());
            }
        }
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        if (DysonSphereSavaedData.getDimensionUse(this.getDimension())) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.working"));
        }
    }
}

