/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.miner;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.cover.filter.Filter;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfiguratorButton;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IDataInfoProvider;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.common.item.PortableScannerBehavior;
import com.gtocore.client.forge.ForgeClientEvent;
import com.gtolib.api.machine.feature.IDigitalMiner;
import com.gtolib.api.machine.impl.DigitalMinerLogic;
import com.hepdd.gtmthings.api.gui.widget.SimpleNumberInputWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SingleDigitalMiner
extends SimpleTieredMachine
implements IDigitalMiner,
IDataInfoProvider {
    private static final int BORDER_WIDTH = 3;
    @Persisted
    protected final CustomItemStackHandler filterInventory;
    private final int maximumRadius;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription exportItemSubs;
    @Nullable
    protected ISubscription energySubs;
    protected ItemFilter itemFilter;
    protected SlotWidget filterSlot;
    protected ButtonWidget resetButton;
    protected ButtonWidget silkButton;
    private long energyPerTick;
    @Persisted
    @DescSynced
    private int minerRadius;
    @Persisted
    @DescSynced
    private int minHeight;
    @Persisted
    @DescSynced
    private int maxHeight;
    private int silkLevel;
    @Nullable
    private ForgeClientEvent.HighlightNeed need;

    public SingleDigitalMiner(MetaMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, GTMachineUtils.defaultTankSizeFunction, args);
        this.energyPerTick = GTValues.VEX[tier - 1];
        this.filterInventory = this.createFilterItemHandler();
        this.silkLevel = 0;
        this.minHeight = 0;
        this.maxHeight = 64;
        this.minerRadius = this.maximumRadius = (int)(8.0 * Math.pow(2.0, tier));
    }

    protected CustomItemStackHandler createFilterItemHandler() {
        CustomItemStackHandler transfer = new CustomItemStackHandler();
        transfer.setFilter(item -> item.m_150930_(GTItems.ITEM_FILTER.m_5456_()) || item.m_150930_(GTItems.TAG_FILTER.m_5456_()));
        return transfer;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new DigitalMinerLogic((IRecipeLogicMachine)this);
    }

    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.exportItems.storage);
        this.clearInventory((IItemHandlerModifiable)this.filterInventory);
    }

    public AABB getMinerArea() {
        BlockPos pos = this.getPos();
        return new AABB((double)(pos.m_123341_() - this.minerRadius), (double)this.maxHeight, (double)(pos.m_123343_() - this.minerRadius), (double)(pos.m_123341_() + this.minerRadius), (double)this.minHeight, (double)(pos.m_123343_() + this.minerRadius));
    }

    public IDigitalMiner.MinerConfig getMinerConfig() {
        return new IDigitalMiner.MinerConfig(this.getMinerArea(), this.silkLevel > 0 ? this.energyPerTick * 4L : this.energyPerTick, 20, (int)Math.pow(2.0, this.tier - 1), this.silkLevel, (Filter)this.itemFilter, null, IDigitalMiner.FluidMode.Ignore);
    }

    public DigitalMinerLogic getRecipeLogic() {
        return (DigitalMinerLogic)super.getRecipeLogic();
    }

    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.filterChange();
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
            }
            this.exportItemSubs = this.exportItems.addChangedListener(this::updateAutoOutputSubscription);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
            this.exportItemSubs = null;
        }
        if (this.energySubs != null) {
            this.energySubs.unsubscribe();
            this.energySubs = null;
        }
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacingItems = this.getFrontFacing();
        if (!this.exportItems.isEmpty() && ItemTransferHelper.getItemTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(outputFacingItems), (Direction)outputFacingItems.m_122424_()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::autoOutput, 20);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void autoOutput() {
        this.exportItems.exportToNearby(new Direction[]{this.getFrontFacing()});
        this.updateAutoOutputSubscription();
    }

    public boolean drainInput(boolean simulate) {
        long resultEnergy = this.energyContainer.getEnergyStored() - this.energyPerTick;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.removeEnergy(this.energyPerTick);
            }
            return true;
        }
        return false;
    }

    public Widget createUIWidget() {
        int rowSize = 3;
        int colSize = 9;
        int width = colSize * 18 + 16;
        int height = rowSize * 18 + 76 + 4;
        int index = 0;
        WidgetGroup group = new WidgetGroup(0, 0, width, height);
        ComponentPanelWidget componentPanel = new ComponentPanelWidget(4, 5, this::addDisplayText).setMaxWidthLimit(110);
        WidgetGroup container = new WidgetGroup(8, 0, 87, 76);
        container.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, container.getSize().width - 8, container.getSize().height - 8).setBackground((IGuiTexture)GuiTextures.DISPLAY).addWidget((Widget)componentPanel));
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        WidgetGroup slots = new WidgetGroup(8, 78, colSize * 18, rowSize * 18);
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < colSize; ++x) {
                Widget slot = new SlotWidget((IItemHandlerModifiable)this.exportItems, index++, x * 18, y * 18, true, false).setBackground(new IGuiTexture[]{GuiTextures.SLOT});
                slots.addWidget(slot);
            }
        }
        group.addWidget((Widget)slots);
        this.filterSlot = new SlotWidget((IItemHandlerModifiable)this.filterInventory, 0, 117, 4, true, true);
        this.filterSlot.setChangeListener(this::filterChange).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.FILTER_SLOT_OVERLAY});
        group.addWidget((Widget)this.filterSlot);
        group.addWidget((Widget)new LabelWidget(99, 26, "\u6c34\u5e73\u8303\u56f4:"));
        group.addWidget((Widget)new SimpleNumberInputWidget(140, 24, 24, 12, this::getMinerRadius, this::setMinerRadius).setMin(1).setMax((int)(8.0 * Math.pow(2.0, this.getTier()))));
        group.addWidget((Widget)new LabelWidget(99, 44, "\u6700\u5c0f\u9ad8\u5ea6:"));
        group.addWidget((Widget)new SimpleNumberInputWidget(140, 42, 24, 12, this::getMinHeight, this::setMinHeight).setMin(this.getLevel().m_141937_()).setMax(this.getLevel().m_151558_()));
        group.addWidget((Widget)new LabelWidget(99, 62, "\u6700\u5927\u9ad8\u5ea6:"));
        group.addWidget((Widget)new SimpleNumberInputWidget(140, 60, 24, 12, this::getMaxHeight, this::setMaxHeight).setMin(this.getLevel().m_141937_()).setMax(this.getLevel().m_151558_()));
        this.resetButton = new ButtonWidget(16, 49, 18, 13, (IGuiTexture)new TextTexture("\u91cd\u7f6e").setDropShadow(false).setColor(ChatFormatting.GRAY.m_126665_().intValue()), this::reset);
        this.resetButton.setHoverTooltips(new Component[]{Component.m_237113_((String)"\u4fee\u6539\u914d\u7f6e\u540e\u5fc5\u987b\u91cd\u7f6e\u624d\u80fd\u751f\u6548\u3002")});
        group.addWidget((Widget)this.resetButton);
        this.silkButton = new ButtonWidget(36, 49, 18, 13, (IGuiTexture)new TextTexture("\u7cbe\u51c6").setDropShadow(false).setColor((this.silkLevel == 0 ? ChatFormatting.GRAY.m_126665_() : ChatFormatting.GREEN.m_126665_()).intValue()), this::setSilk);
        this.silkButton.setHoverTooltips(new Component[]{Component.m_237113_((String)"\u5f00\u542f\u7cbe\u51c6\u91c7\u96c6\u6a21\u5f0f\uff0c4\u500d\u8017\u7535\u3002")});
        group.addWidget((Widget)this.silkButton);
        return group;
    }

    private void resetRecipe() {
        this.setWorkingEnabled(false);
        this.getRecipeLogic().resetRecipeLogic();
    }

    private void filterChange() {
        this.itemFilter = null;
        if (!this.filterInventory.getStackInSlot(0).m_41619_()) {
            this.itemFilter = ItemFilter.loadFilter((ItemStack)this.filterInventory.getStackInSlot(0));
        }
        this.resetRecipe();
    }

    private void reset(ClickData clickData) {
        this.resetRecipe();
    }

    private void setSilk(ClickData clickData) {
        if (this.silkLevel == 0) {
            this.silkLevel = 1;
            this.silkButton.setButtonTexture(new IGuiTexture[]{new TextTexture("\u7cbe\u51c6").setDropShadow(false).setColor(ChatFormatting.GREEN.m_126665_().intValue())});
            this.energyPerTick = GTValues.VEX[this.getTier() - 1] * 4L;
        } else {
            this.silkLevel = 0;
            this.silkButton.setButtonTexture(new IGuiTexture[]{new TextTexture("\u7cbe\u51c6").setDropShadow(false).setColor(ChatFormatting.GRAY.m_126665_().intValue())});
            this.energyPerTick = GTValues.VEX[this.getTier() - 1];
        }
        this.resetRecipe();
    }

    private void addDisplayText(List<Component> textList) {
        textList.add((Component)Component.m_237113_((String)"\u6316\u6398: ").m_130946_(String.valueOf(this.getRecipeLogic().getOreAmount())));
        if (this.getRecipeLogic().isDone()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.done").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
        } else if (this.getRecipeLogic().isWorking()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.working").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
        } else if (!this.isWorkingEnabled()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.work_paused"));
        }
        if (this.getRecipeLogic().isInventoryFull()) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.invfull").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
        if (!this.drainInput(true)) {
            textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.needspower").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
    }

    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (this.isRemote()) {
            return InteractionResult.SUCCESS;
        }
        if (!this.isActive()) {
            int currentRadius = this.minerRadius;
            this.minerRadius = currentRadius == 1 ? this.maximumRadius : (playerIn.m_6144_() ? Math.max(1, Math.round((float)currentRadius / 2.0f)) : Math.max(1, currentRadius - 1));
            this.getRecipeLogic().resetArea(true);
            int workingArea = this.minerRadius;
            playerIn.m_213846_((Component)Component.m_237110_((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{workingArea, workingArea}));
        } else {
            playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.multiblock.large_miner.errorradius"));
        }
        return InteractionResult.SUCCESS;
    }

    public List<Component> getDataInfo(PortableScannerBehavior.DisplayMode mode) {
        if (mode == PortableScannerBehavior.DisplayMode.SHOW_ALL || mode == PortableScannerBehavior.DisplayMode.SHOW_MACHINE_INFO) {
            int workingArea = this.minerRadius;
            return Collections.singletonList(Component.m_237110_((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{workingArea, workingArea}));
        }
        return new ArrayList<Component>();
    }

    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        configuratorPanel.attachConfigurators(new IFancyConfigurator[]{new IFancyConfiguratorButton.Toggle((IGuiTexture)GuiTextures.LIGHT_ON, (IGuiTexture)GuiTextures.LIGHT_ON, () -> false, (clickData, pressed) -> {
            if (clickData.isRemote && this.self().getLevel() != null) {
                if (this.need != null && ForgeClientEvent.CUstomHighlightNeeds.containsKey((Object)this.need)) {
                    ForgeClientEvent.CUstomHighlightNeeds.removeInt((Object)this.need);
                    this.need = null;
                    return;
                }
                this.need = new ForgeClientEvent.HighlightNeed(this.getPos().m_122030_(this.minerRadius).m_122013_(this.minerRadius).m_175288_(this.maxHeight), this.getPos().m_122025_(this.minerRadius).m_122020_(this.minerRadius).m_175288_(this.minHeight), ChatFormatting.WHITE.m_126665_());
                ForgeClientEvent.CUstomHighlightNeeds.computeIfAbsent((Object)this.need, k -> 200);
            }
        }).setTooltipsSupplier(pressed -> Collections.singletonList(Component.m_237115_((String)"gtocore.digital_miner.show_range.tooltip")))});
    }

    @Generated
    public ItemFilter getItemFilter() {
        return this.itemFilter;
    }

    @Generated
    public int getMinerRadius() {
        return this.minerRadius;
    }

    @Generated
    public void setMinerRadius(int minerRadius) {
        this.minerRadius = minerRadius;
    }

    @Generated
    public int getMinHeight() {
        return this.minHeight;
    }

    @Generated
    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    @Generated
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Generated
    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }
}

