/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.assembly;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gtocore.common.data.GTOItems;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.api.recipe.modifier.RecipeModifierFunction;
import com.gtolib.utils.ItemUtils;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CircuitAssemblyLineMachine
extends StorageMultiblockMachine {
    private int inputEUt;
    private int parallel;

    public CircuitAssemblyLineMachine(MetaMachineBlockEntity holder) {
        super(holder, 64, i -> ItemUtils.getId((ItemStack)i).contains("precision_circuit_assembly_robot_mk"));
    }

    @NotNull
    public NotifiableItemStackHandler createMachineStorage(Predicate<ItemStack> filter) {
        NotifiableItemStackHandler storage = new NotifiableItemStackHandler((MetaMachine)this, 1, IO.IN, IO.BOTH, slots -> new CustomItemStackHandler(1){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                CircuitAssemblyLineMachine.this.onMachineChanged();
            }
        });
        storage.setFilter(filter);
        return storage;
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.onMachineChanged();
    }

    public void onMachineChanged() {
        this.inputEUt = 0;
        ItemStack item = this.getStorageStack();
        if (item.m_41720_() == GTOItems.PRECISION_CIRCUIT_ASSEMBLY_ROBOT_MK1.get()) {
            this.inputEUt = GTValues.VA[8];
        } else if (item.m_41720_() == GTOItems.PRECISION_CIRCUIT_ASSEMBLY_ROBOT_MK2.get()) {
            this.inputEUt = GTValues.VA[9];
        } else if (item.m_41720_() == GTOItems.PRECISION_CIRCUIT_ASSEMBLY_ROBOT_MK3.get()) {
            this.inputEUt = GTValues.VA[10];
        } else if (item.m_41720_() == GTOItems.PRECISION_CIRCUIT_ASSEMBLY_ROBOT_MK4.get()) {
            this.inputEUt = GTValues.VA[11];
        } else if (item.m_41720_() == GTOItems.PRECISION_CIRCUIT_ASSEMBLY_ROBOT_MK5.get()) {
            this.inputEUt = GTValues.VA[12];
        }
        this.parallel = item.m_41613_() << 1;
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        if ((long)this.inputEUt == recipe.getInputEUt()) {
            recipe = ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)this.parallel);
        }
        return RecipeModifierFunction.overclocking((MetaMachine)this, (Recipe)recipe);
    }
}

