/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric.adventure;

import appeng.util.Platform;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtocore.api.entity.ILivingEntity;
import com.gtocore.common.data.GTOFluids;
import com.gtocore.common.data.GTOItems;
import com.gtocore.data.IdleReason;
import com.gtolib.api.item.ItemStackSet;
import com.gtolib.api.machine.feature.multiblock.ITierCasingMachine;
import com.gtolib.api.machine.multiblock.StorageMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.machine.trait.TierCasingTrait;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.boss.ApothBoss;
import dev.shadowsoffire.apotheosis.adventure.boss.BossRegistry;
import dev.shadowsoffire.apotheosis.adventure.boss.BossSummonerItem;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemRegistry;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import earth.terrarium.adastra.common.entities.mob.GlacianRam;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import snownee.jade.util.CommonProxy;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class SlaughterhouseMachine
extends StorageMultiblockMachine
implements ITierCasingMachine {
    private int attackDamage;
    private DamageSource damageSource;
    private ItemStack activeWeapon = ItemStack.f_41583_;
    private boolean bossMode = false;
    @Persisted
    private boolean filterNbt = false;
    private String entityId;
    private static final String[] mobList1 = new String[]{"minecraft:chicken", "minecraft:rabbit", "minecraft:sheep", "minecraft:cow", "minecraft:horse", "minecraft:pig", "minecraft:donkey", "minecraft:skeleton_horse", "minecraft:iron_golem", "minecraft:wolf", "minecraft:goat", "minecraft:parrot", "minecraft:camel", "minecraft:cat", "minecraft:fox", "minecraft:llama", "minecraft:panda", "minecraft:polar_bear"};
    private static final String[] mobList2 = new String[]{"minecraft:ghast", "minecraft:zombie", "minecraft:pillager", "minecraft:zombie_villager", "minecraft:skeleton", "minecraft:drowned", "minecraft:witch", "minecraft:spider", "minecraft:creeper", "minecraft:husk", "minecraft:wither_skeleton", "minecraft:blaze", "minecraft:zombified_piglin", "minecraft:slime", "minecraft:vindicator", "minecraft:enderman"};
    private final TierCasingTrait tierCasingTrait = new TierCasingTrait((ITierCasingMachine)this, new String[]{"g_b"});

    public SlaughterhouseMachine(MetaMachineBlockEntity holder) {
        super(holder, 1, i -> i.m_41720_() instanceof SpawnEggItem || i.m_41720_() instanceof BossSummonerItem);
    }

    public boolean hasBatchConfig() {
        return false;
    }

    private static Player getFakePlayer(ServerLevel level) {
        return Platform.getFakePlayer((ServerLevel)level, null);
    }

    private DamageSource getDamageSource(ServerLevel level, Player player) {
        if (this.damageSource == null) {
            this.damageSource = new DamageSources((RegistryAccess)level.m_7654_().m_206579_()).m_269333_((LivingEntity)player);
        }
        return this.damageSource;
    }

    public void onMachineChanged() {
        Item item;
        this.entityId = null;
        ItemStack itemStack = this.getStorageStack();
        this.bossMode = itemStack.m_41720_() instanceof BossSummonerItem;
        if (itemStack.m_41619_() || !((item = itemStack.m_41720_()) instanceof SpawnEggItem)) {
            return;
        }
        SpawnEggItem egg = (SpawnEggItem)item;
        this.entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)egg.m_43228_(null)).toString();
    }

    public void onContentChanges(RecipeHandlerList handlerList) {
        if (handlerList.getHandlerIO() == IO.IN) {
            this.attackDamage = 1;
            this.activeWeapon = ItemStack.f_41583_;
            this.forEachInputItems((stack, amount) -> {
                Item patt0$temp = stack.m_41720_();
                if (patt0$temp instanceof SwordItem) {
                    SwordItem swordItem = (SwordItem)patt0$temp;
                    if (this.activeWeapon.m_41619_()) {
                        this.activeWeapon = stack;
                    }
                    this.attackDamage += (int)swordItem.m_43299_();
                }
                return false;
            });
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.tier = Math.min(this.getCasingTier("g_b"), this.tier);
        this.onMachineChanged();
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"item.gtceu.tool.tooltip.attack_damage", (Object[])new Object[]{this.attackDamage}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.slaughterhouse.active_weapon", (Object[])new Object[]{this.activeWeapon.m_41611_()}));
        textList.add((Component)Component.m_237115_((String)"gtocore.machine.slaughterhouse.filter_nbt").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[").m_7220_((Component)(this.filterNbt ? Component.m_237115_((String)"gtocore.machine.on") : Component.m_237115_((String)"gtocore.machine.off"))).m_7220_((Component)Component.m_237113_((String)"]")), (String)"filter_nbt")));
    }

    public boolean onWorking() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getOffsetTimer() % 200 == 0) {
                BlockPos blockPos = MachineUtils.getOffsetPos((int)3, (int)1, (Direction)this.getFrontFacing(), (BlockPos)this.getPos());
                for (Entity entity : serverLevel.m_45976_(LivingEntity.class, new AABB((double)(blockPos.m_123341_() - 3), (double)(blockPos.m_123342_() - 1), (double)(blockPos.m_123343_() - 3), (double)(blockPos.m_123341_() + 3), (double)(blockPos.m_123342_() + 6), (double)(blockPos.m_123343_() + 3)).m_82406_(0.1))) {
                    entity.m_6074_();
                }
            }
        }
        return super.onWorking();
    }

    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote) {
            if (componentData.equals("filter_nbt")) {
                this.filterNbt = !this.filterNbt;
            } else {
                super.handleDisplayClick(componentData, clickData);
            }
        }
    }

    @Nullable
    private Recipe getRecipe() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            boolean isFixed;
            Optional entityType;
            String entityId;
            ApothBoss item;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getTier() < 1) {
                this.setIdleReason(IdleReason.VOLTAGE_TIER_NOT_SATISFIES);
                return null;
            }
            int c = this.checkingCircuit(false);
            if (c != 1 && c != 2) {
                this.setIdleReason(IdleReason.SET_CIRCUIT);
                return null;
            }
            Player player = SlaughterhouseMachine.getFakePlayer(serverLevel);
            DamageSource source = this.getDamageSource(serverLevel, player);
            ItemStackSet itemStacks = new ItemStackSet();
            Vec3 origin = MachineUtils.getOffsetPos((int)3, (int)1, (Direction)this.getFrontFacing(), (BlockPos)this.getPos()).m_252807_();
            Entity entity = null;
            if (this.bossMode && (item = (ApothBoss)BossRegistry.INSTANCE.getRandomItem(serverLevel.m_213780_(), player.m_36336_(), new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((Level)serverLevel), GameStagesCompat.IStaged.matches((Player)player)})) != null) {
                entity = item.createBoss((ServerLevelAccessor)serverLevel, player.m_20097_(), serverLevel.m_213780_(), player.m_36336_());
            }
            if ((entityId = this.entityId) != null && (entityType = EntityType.m_20632_((String)entityId)).isPresent()) {
                entity = ((EntityType)entityType.get()).m_20615_((Level)serverLevel);
            }
            boolean bl = isFixed = entity != null;
            String[] mobList = isFixed ? null : (c == 1 ? mobList1 : mobList2);
            int parallel = (int)Math.pow(3.0, this.tier - 1);
            int tierMultiplier = Math.min(16, parallel);
            int multiplier = Math.max(1, parallel / tierMultiplier);
            long xp = 0L;
            LootParams.Builder lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81456_, (Object)player).m_287286_(LootContextParams.f_81457_, (Object)source).m_287286_(LootContextParams.f_81458_, (Object)player).m_287286_(LootContextParams.f_81459_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)origin).m_287286_(LootContextParams.f_81461_, (Object)this.getBlockState()).m_287286_(LootContextParams.f_81462_, (Object)this.holder).m_287286_(LootContextParams.f_81463_, (Object)this.activeWeapon).m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(0.0f));
            for (int i = 0; i <= tierMultiplier; ++i) {
                if (!isFixed) {
                    entityId = mobList[GTValues.RNG.m_188503_(mobList.length)];
                    Optional entityType2 = EntityType.m_20632_((String)entityId);
                    if (entityType2.isEmpty()) continue;
                    entity = ((EntityType)entityType2.get()).m_20615_((Level)serverLevel);
                }
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                if (CommonProxy.isBoss((Entity)entity)) continue;
                xp += (long)mob.m_213860_() * (long)multiplier;
                this.getAllDeathLoot(player, serverLevel, (LivingEntity)mob, source, lootParams, (Set<ItemStack>)itemStacks, multiplier);
            }
            if (xp > 0L) {
                this.outputFluid((Fluid)GTOFluids.XP_JUICE.getSource(), xp);
            }
            int duration = Math.max(60, 600 - this.attackDamage);
            RecipeBuilder builder = this.getRecipeBuilder().duration(duration).EUt(this.getOverclockVoltage());
            itemStacks.forEach(arg_0 -> ((RecipeBuilder)builder).outputItems(arg_0));
            Recipe recipe = builder.buildRawRecipe();
            if (RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)recipe)) {
                return recipe;
            }
        }
        return null;
    }

    private void getAllDeathLoot(Player player, ServerLevel level, LivingEntity entity, DamageSource source, LootParams.Builder lootParams, Set<ItemStack> itemStacks, int multiplier) {
        GlacianRam glacianRam;
        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(entity.m_5743_());
        lootTable.m_287195_(lootParams.m_287286_(LootContextParams.f_81455_, (Object)entity).m_287235_(lootTable.m_79122_())).forEach(item -> {
            int count = item.m_41613_();
            if (count < 1) {
                return;
            }
            if (this.filterNbt && item.m_41782_()) {
                return;
            }
            item.m_41764_(count * multiplier);
            itemStacks.add((ItemStack)item);
        });
        int sqrt = (int)Math.sqrt(multiplier);
        ((ILivingEntity)entity).gtocore$getAllDeathLoot(source, itemStacks, sqrt, this.filterNbt);
        if (entity instanceof Monster) {
            if (this.filterNbt) {
                return;
            }
            float chance = AdventureConfig.gemDropChance + (entity.getPersistentData().m_128441_("apoth.boss") ? AdventureConfig.gemBossBonus : 0.0f);
            if (player.m_217043_().m_188501_() <= chance) {
                sqrt *= 2;
                ItemStack item2 = GemRegistry.createRandomGemStack((RandomSource)player.m_217043_(), (ServerLevel)level, (float)player.m_36336_(), (Predicate[])new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((Level)level), GameStagesCompat.IStaged.matches((Player)player)});
                int count = item2.m_41613_();
                if (count < 1) {
                    return;
                }
                item2.m_41764_(count * entity.m_217043_().m_216339_(sqrt / 2, sqrt));
                if (item2.m_41619_()) {
                    return;
                }
                itemStacks.add(item2);
            }
        } else if (entity instanceof GlacianRam && (glacianRam = (GlacianRam)entity).m_217043_().m_188503_(Math.max(10, 20 - sqrt)) == 1) {
            itemStacks.add(GTOItems.GLACIO_SPIRIT.asStack());
        }
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }

    public Object2IntMap<String> getCasingTiers() {
        return this.tierCasingTrait.getCasingTiers();
    }
}

