/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gtocore.common.machine.multiblock.part.BallHatchPartMachine;
import com.gtocore.data.IdleReason;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.utils.MathUtil;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class IsaMillMachine
extends ElectricMultiblockMachine {
    private BallHatchPartMachine ballHatchPartMachine;

    public IsaMillMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void onPartScan(IMultiPart part) {
        super.onPartScan(part);
        if (this.ballHatchPartMachine == null && part instanceof BallHatchPartMachine) {
            BallHatchPartMachine ballHatchPart;
            this.ballHatchPartMachine = ballHatchPart = (BallHatchPartMachine)part;
        }
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.ballHatchPartMachine = null;
    }

    protected boolean beforeWorking(Recipe recipe) {
        if (!super.beforeWorking(recipe)) {
            return false;
        }
        CustomItemStackHandler storage = this.ballHatchPartMachine.getInventory().storage;
        ItemStack item = storage.getStackInSlot(0);
        int tier = BallHatchPartMachine.GRINDBALL.getOrDefault(item.m_41720_(), 0);
        if (tier == recipe.data.m_128451_("grindball")) {
            int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)item) + 1;
            int damage = item.m_41773_() + MathUtil.saturatedCast((long)(recipe.parallels / (long)level)) + 1;
            if (damage < item.m_41776_()) {
                item.m_41721_(damage);
            } else {
                storage.setStackInSlot(0, ItemStack.f_41583_);
            }
            return true;
        }
        this.setIdleReason(IdleReason.GRIND_BALL);
        return false;
    }
}

