/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtocore.common.data.GTOLoots;
import com.gtolib.GTOCore;
import com.gtolib.api.item.ItemStackSet;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.utils.MachineUtils;
import com.gtolib.utils.MathUtil;
import com.gtolib.utils.holder.IntHolder;
import com.gtolib.utils.holder.ObjectHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class FishingGroundMachine
extends ElectricMultiblockMachine {
    private static final ItemStack FISHING_ROD = new ItemStack((ItemLike)Items.f_42523_);
    private FishingHook fishingHook;
    private int piglinSoundPlayCD = 0;
    private static final SoundEvent[] soundEntries = new SoundEvent[]{SoundEvents.f_11939_, SoundEvents.f_11940_, SoundEvents.f_11941_, SoundEvents.f_11938_};

    public FishingGroundMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    private Recipe getRecipe() {
        ObjectHolder recipe = new ObjectHolder(null);
        int mode = this.checkingCircuit(false);
        if (mode > 0) {
            RecipeBuilder builder = this.getRecipeBuilder().duration(20).EUt(480L);
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                LootDataManager lootDataManager = level2.m_7654_().m_278653_();
                LootTable lootTable = lootDataManager.m_278676_(switch (mode) {
                    case 2 -> BuiltInLootTables.f_78723_;
                    case 3 -> BuiltInLootTables.f_78721_;
                    case 4 -> BuiltInLootTables.f_78722_;
                    default -> BuiltInLootTables.f_78720_;
                });
                if (this.fishingHook == null) {
                    this.fishingHook = new MyFishingHook(level2);
                }
                LootParams lootContext = new LootParams.Builder(level2).m_287289_(LootContextParams.f_81455_, (Object)this.fishingHook).m_287286_(LootContextParams.f_81463_, (Object)FISHING_ROD).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)this.getPos().m_123341_(), (double)this.getPos().m_123342_(), (double)this.getPos().m_123343_())).m_287235_(LootContextParamSets.f_81414_);
                ItemStackSet itemStacks = new ItemStackSet();
                recipe.value = ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)builder.copy(GTOCore.id((String)"test")).outputItems(Items.f_42398_).buildRawRecipe(), (long)MachineUtils.getHatchParallel((MetaMachine)this));
                if (recipe.value == null) {
                    return null;
                }
                IntHolder nbt = new IntHolder(0);
                builder.EUt(((Recipe)recipe.value).getInputEUt());
                long parallel = Math.min(1024L, ((Recipe)recipe.value).parallels);
                long multiplier = ((Recipe)recipe.value).parallels / parallel;
                GTOLoots.modifyLoot = false;
                int i2 = 0;
                while ((long)i2 < parallel) {
                    lootTable.m_287195_(lootContext).forEach(itemStack -> {
                        if (itemStack.m_41782_()) {
                            if (nbt.value > 100) {
                                return;
                            }
                            ++nbt.value;
                        }
                        itemStacks.add(itemStack);
                    });
                    ++i2;
                }
                GTOLoots.modifyLoot = true;
                itemStacks.forEach(i -> {
                    if (multiplier > 1L) {
                        i.m_41764_(MathUtil.saturatedCast((long)((long)i.m_41613_() * multiplier)));
                    }
                    builder.outputItems(i);
                });
                recipe.value = builder.buildRawRecipe();
            }
        } else {
            this.getRecipeType().findRecipe((IRecipeCapabilityHolder)this, r -> {
                Recipe modify = (Recipe)this.fullModifyRecipe(r.copy());
                if (modify != null && RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)modify) && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)((Recipe)recipe.value))) {
                    this.fishingHook = null;
                    recipe.value = modify;
                    return true;
                }
                return false;
            });
        }
        return (Recipe)recipe.value;
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }

    public boolean onWorking() {
        Level level;
        if (this.piglinSoundPlayCD > 0) {
            --this.piglinSoundPlayCD;
        } else if (this.fishingHook != null && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            SoundEvent soundEvent = soundEntries[level2.f_46441_.m_188503_(soundEntries.length)];
            level2.m_247517_(null, this.getPos(), soundEvent, SoundSource.BLOCKS);
            this.piglinSoundPlayCD = 10 + level2.f_46441_.m_188503_(100);
        }
        return super.onWorking();
    }

    private static class MyFishingHook
    extends FishingHook {
        MyFishingHook(ServerLevel level) {
            super(EntityType.f_20533_, (Level)level);
        }

        public boolean m_37166_() {
            return true;
        }
    }
}

