/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gtocore.common.machine.multiblock.part.SpoolHatchPartMachine;
import com.gtolib.api.machine.multiblock.CoilMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.utils.FunctionContainer;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class DrawingTowerMachine
extends CoilMultiblockMachine {
    private SpoolHatchPartMachine spoolHatchPartMachine;
    private int height;
    private double reduction = 1.0;
    private int parallels = 1;

    public DrawingTowerMachine(MetaMachineBlockEntity holder) {
        super(holder, false, false);
    }

    public void onPartScan(IMultiPart part) {
        super.onPartScan(part);
        if (this.spoolHatchPartMachine == null && part instanceof SpoolHatchPartMachine) {
            SpoolHatchPartMachine spoolHatchPart;
            this.spoolHatchPartMachine = spoolHatchPart = (SpoolHatchPartMachine)part;
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        FunctionContainer container = (FunctionContainer)this.getMultiblockState().getMatchContext().get((Object)"laminated_glass");
        if (container != null) {
            this.height = (Integer)container.getValue();
        }
        this.reduction = Math.max(1.0E-5, 2.0 / Math.pow(1.2, (double)this.height / 8.0 * (((double)this.getTemperature() - 5000.0) / 900.0)));
        this.parallels = this.getTemperature() <= 10000 ? 1 : (int)Math.round(Math.log(this.getTemperature() - 9600) / Math.log(1.08) - 84.0);
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.height = 0;
        this.spoolHatchPartMachine = null;
    }

    @Nullable
    protected Recipe getRealRecipe(Recipe recipe) {
        if (this.spoolHatchPartMachine == null) {
            return null;
        }
        CustomItemStackHandler storage = this.spoolHatchPartMachine.getInventory().storage;
        ItemStack item = storage.getStackInSlot(0);
        int tier = DrawingTowerMachine.getItemTier(item);
        if (tier == recipe.data.m_128451_("spool")) {
            if (item.m_41613_() > 1) {
                item.m_41774_(1);
                storage.setStackInSlot(0, item);
            } else {
                storage.setStackInSlot(0, ItemStack.f_41583_);
            }
            recipe.duration = (int)((double)recipe.duration * this.reduction);
            return ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)this.parallels);
        }
        return null;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.height", (Object[])new Object[]{this.height}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.duration_multiplier.tooltip", (Object[])new Object[]{this.reduction}));
        textList.add((Component)Component.m_237110_((String)"gtocore.machine.parallel", (Object[])new Object[]{this.parallels}));
    }

    private static int getItemTier(ItemStack item) {
        if (item.m_41619_()) {
            return 0;
        }
        return SpoolHatchPartMachine.SPOOL.getOrDefault(item.m_41720_(), 0);
    }
}

