/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gtocore.common.machine.multiblock.part.AnalyzeHolderMachine;
import com.gtocore.common.machine.multiblock.part.ResearchHolderMachine;
import com.gtolib.api.machine.multiblock.ElectricMultiblockMachine;
import com.gtolib.api.recipe.Recipe;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalysisAndResearchCenterMachine
extends ElectricMultiblockMachine {
    private AnalyzeHolderMachine AnalyzeHolder;
    private ResearchHolderMachine ResearchHolder;
    private int mode = 0;

    public AnalysisAndResearchCenterMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        for (IMultiPart part : this.getParts()) {
            if (part instanceof AnalyzeHolderMachine) {
                AnalyzeHolderMachine analyzeHolder = (AnalyzeHolderMachine)part;
                if (analyzeHolder.getFrontFacing() != this.getFrontFacing()) {
                    this.onStructureInvalid();
                    return;
                }
                this.AnalyzeHolder = analyzeHolder;
                this.addHandlerList(RecipeHandlerList.of((IO)IO.IN, (IRecipeHandler[])new IRecipeHandler[]{analyzeHolder.getAsHandler()}));
                this.mode = 1;
            }
            if (!(part instanceof ResearchHolderMachine)) continue;
            ResearchHolderMachine researchHolder = (ResearchHolderMachine)part;
            if (researchHolder.getFrontFacing() != this.getFrontFacing()) {
                this.onStructureInvalid();
                return;
            }
            this.ResearchHolder = researchHolder;
            this.addHandlerList(RecipeHandlerList.of((IO)IO.IN, (IRecipeHandler[])new IRecipeHandler[]{researchHolder.getAsHandler()}));
            this.mode = 2;
        }
        if (this.mode == 0) {
            this.onStructureInvalid();
        }
    }

    public boolean checkPattern() {
        boolean isFormed = super.checkPattern();
        if (isFormed && this.mode != 0) {
            this.onStructureInvalid();
        }
        return isFormed;
    }

    public void onStructureInvalid() {
        if (this.AnalyzeHolder != null && this.mode == 1) {
            this.AnalyzeHolder.setLocked(false);
            this.AnalyzeHolder = null;
        }
        if (this.ResearchHolder != null && this.mode == 2) {
            this.ResearchHolder.setLocked(false);
            this.ResearchHolder = null;
        }
        super.onStructureInvalid();
    }

    public boolean regressWhenWaiting() {
        return false;
    }

    public void addDisplayText(@NotNull List<Component> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isFormed()).setWorkingStatus(this.recipeLogic.isWorkingEnabled(), this.recipeLogic.isActive()).setWorkingStatusKeys("gtceu.multiblock.idling", "gtceu.multiblock.work_paused", "gtocore.machine.analysis").addEnergyUsageLine((IEnergyContainer)this.energyContainer).addEnergyTierLine(this.tier).addWorkingStatusLine().addProgressLineOnlyPercent(this.recipeLogic.getProgressPercent());
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        List itemOutputs = (List)recipe.outputs.get(ItemRecipeCapability.CAP);
        int random = GTValues.RNG.m_188503_(10000);
        int cumulative = 0;
        Content selectedContent = (Content)itemOutputs.getLast();
        for (Content content : itemOutputs) {
            if (content.chance <= 0 || random > (cumulative += content.chance)) continue;
            selectedContent = content;
            break;
        }
        if (selectedContent != null) {
            Object selectedStack = selectedContent.content;
            Content newContent = new Content(selectedStack, 10000, 0);
            List<Content> newOutputs = Collections.singletonList(newContent);
            recipe.outputs.clear();
            recipe.outputs.put(ItemRecipeCapability.CAP, newOutputs);
        }
        return super.getRealRecipe(recipe);
    }
}

