/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.FusionReactorMachine;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtolib.api.machine.multiblock.CrossRecipeMultiblockMachine;
import com.gtolib.api.machine.trait.CrossRecipeTrait;
import com.gtolib.api.machine.trait.EnergyContainerTrait;
import com.gtolib.api.recipe.IdleReason;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.utils.MachineUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class AdvancedFusionReactorMachine
extends CrossRecipeMultiblockMachine {
    @DescSynced
    private int color = -1;
    private static final int tier = 6;
    @Persisted
    private long heat = 0L;
    @Persisted
    private final EnergyContainerTrait energyContainer = this.createEnergyContainer();
    private final ConditionalSubscriptionHandler preHeatSubs = new ConditionalSubscriptionHandler((ITickSubscription)this, this::updateHeat, 0, () -> this.isFormed || this.heat > 0L);

    public AdvancedFusionReactorMachine(MetaMachineBlockEntity holder) {
        super(holder, false, true, MachineUtils::getHatchParallel);
    }

    private EnergyContainerTrait createEnergyContainer() {
        EnergyContainerTrait container = new EnergyContainerTrait((MetaMachine)this, 0L);
        container.setCapabilityValidator(Objects::isNull);
        return container;
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        int size = 0;
        for (IRecipeHandler handler : this.getCapabilitiesFlat(IO.IN, (RecipeCapability)EURecipeCapability.CAP)) {
            if (!(handler instanceof IEnergyContainer)) continue;
            ++size;
        }
        int bonusTier = this.calculateBonusTier();
        this.energyContainer.resetBasicInfo(FusionReactorMachine.calculateEnergyStorageFactor((int)(6 + bonusTier), (int)size));
        this.preHeatSubs.initialize(this.getLevel());
    }

    private int calculateBonusTier() {
        int bonusTier;
        if (this.formeds == null || this.getSubFormed().length <= 1) {
            return 0;
        }
        for (bonusTier = 0; bonusTier < this.getSubFormed().length - 1 && this.getSubFormed()[bonusTier]; ++bonusTier) {
        }
        return bonusTier;
    }

    public CrossRecipeTrait getCrossRecipeTrait() {
        return super.getCrossRecipeTrait();
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.heat = 0L;
        this.energyContainer.resetBasicInfo(0L);
        this.energyContainer.setEnergyStored(0L);
    }

    @Nullable
    public Recipe getRealRecipe(Recipe recipe) {
        long eu_to_start = recipe.data.m_128454_("eu_to_start");
        if (eu_to_start > this.energyContainer.getEnergyCapacity()) {
            this.setIdleReason(IdleReason.INSUFFICIENT_ENERGY_BUFFER);
            return null;
        }
        long heatDiff = eu_to_start - this.heat;
        if (heatDiff > 0L) {
            if (this.energyContainer.getEnergyStored() < heatDiff) {
                this.setIdleReason(IdleReason.INSUFFICIENT_ENERGY_BUFFER);
                return null;
            }
            this.energyContainer.removeEnergy(heatDiff);
            this.heat += heatDiff;
        }
        return super.getRealRecipe(recipe);
    }

    private void updateHeat() {
        long leftStorage;
        if (this.heat > 0L && (this.getRecipeLogic().isIdle() || !this.isWorkingEnabled() || this.getRecipeLogic().isWaiting() && this.getRecipeLogic().getProgress() == 0)) {
            long l = this.heat = this.heat <= 10000L ? 0L : this.heat - 10000L;
        }
        if (this.isFormed() && this.getEnergyContainer().getEnergyStored() > 0L && (leftStorage = this.energyContainer.getEnergyCapacity() - this.energyContainer.getEnergyStored()) > 0L) {
            this.energyContainer.addEnergy(this.getEnergyContainer().removeEnergy(leftStorage));
        }
        this.preHeatSubs.updateSubscription();
    }

    public boolean onWorking() {
        if (this.color == -1) {
            FluidStack stack;
            int newColor;
            GTRecipe recipe = this.recipeLogic.getLastRecipe();
            assert (recipe != null);
            if (!recipe.getOutputContents((RecipeCapability)FluidRecipeCapability.CAP).isEmpty() && this.color != (newColor = 0xFF000000 | GTUtil.getFluidColor((FluidStack)(stack = ((FluidIngredient)FluidRecipeCapability.CAP.of(((Content)recipe.getOutputContents((RecipeCapability)FluidRecipeCapability.CAP).get(0)).getContent())).getStacks()[0])))) {
                this.color = newColor;
            }
        }
        return super.onWorking();
    }

    public void onWaiting() {
        super.onWaiting();
        this.color = -1;
    }

    public void afterWorking() {
        super.afterWorking();
        this.color = -1;
    }

    public void customText(List<Component> textList) {
        super.customText(textList);
        textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.fusion_reactor.energy", (Object[])new Object[]{this.energyContainer.getEnergyStored(), this.energyContainer.getEnergyCapacity()}));
        textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.fusion_reactor.heat", (Object[])new Object[]{this.heat}));
    }

    public int getTier() {
        return 6 + this.calculateBonusTier();
    }

    @Generated
    public int getColor() {
        return this.color;
    }
}

