/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.monitor;

import com.google.common.collect.ImmutableBiMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.steam.SimpleSteamMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.client.util.TooltipHelper;
import com.gregtechceu.gtceu.common.machine.multiblock.steam.SteamParallelMultiblockMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.api.gui.helper.ProgressBarColorStyle;
import com.gtocore.common.machine.monitor.AbstractInfoProviderMonitor;
import com.gtocore.common.machine.monitor.DisplayComponent;
import com.gtocore.common.machine.monitor.DisplayComponentList;
import com.gtocore.common.machine.monitor.DisplayRegistry;
import com.gtolib.GTOCore;
import com.gtolib.api.machine.mana.feature.IManaEnergyMachine;
import com.gtolib.api.recipe.ContentBuilder;
import com.gtolib.utils.FluidUtils;
import com.gtolib.utils.GTOUtils;
import com.gtolib.utils.NumberUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import kotlin.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.impl.WailaCommonRegistration;

public class MonitorMachine
extends AbstractInfoProviderMonitor
implements IMachineModifyDrops {
    @DescSynced
    private Component[] bufferCache = new Component[0];
    @DescSynced
    private float progress = 0.0f;
    private List<FormattedCharSequence> textListCache;
    private BlockPos pos;
    private BlockEntity tile;
    private BlockAccessor accessor;
    private List<IServerDataProvider<BlockAccessor>> providers;
    private static int index = 0;
    private static final ImmutableBiMap<Integer, DisplayRegistry> DISPLAY_REGISTRY = ImmutableBiMap.builder().put((Object)index++, (Object)DisplayRegistry.MACHINE_NAME).put((Object)index++, (Object)DisplayRegistry.MACHINE_ENERGY).put((Object)index++, (Object)DisplayRegistry.MACHINE_PROGRESS).put((Object)index++, (Object)DisplayRegistry.MACHINE_RECIPE_LOGIC_EU).put((Object)index++, (Object)DisplayRegistry.MACHINE_RECIPE_LOGIC_MANA).put((Object)index++, (Object)DisplayRegistry.MACHINE_RECIPE_OUTPUT).put((Object)index++, (Object)DisplayRegistry.MACHINE_RECIPE_OUTPUT_ITEM_1).put((Object)index++, (Object)DisplayRegistry.MACHINE_RECIPE_OUTPUT_ITEM_2).put((Object)index++, (Object)DisplayRegistry.MACHINE_RECIPE_OUTPUT_ITEM_3).put((Object)index++, (Object)DisplayRegistry.MACHINE_RECIPE_OUTPUT_FLUID_1).put((Object)index++, (Object)DisplayRegistry.MACHINE_RECIPE_OUTPUT_FLUID_2).put((Object)index++, (Object)DisplayRegistry.MACHINE_RECIPE_OUTPUT_FLUID_3).put((Object)index++, (Object)DisplayRegistry.MACHINE_MANTENANCE).build();
    @Persisted
    private final NotifiableItemStackHandler inventory = this.createInventoryItemHandler();
    private boolean isCardChange = true;
    private static final IGuiTexture MACHINE_COORDS_OVERLAY = new ResourceTexture(GTOCore.id((String)"textures/gui/machine_coords_overlay.png")).scale(0.9375f);

    public MonitorMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    public MonitorMachine(Object o) {
        this((MetaMachineBlockEntity)o);
    }

    private NotifiableItemStackHandler createInventoryItemHandler() {
        NotifiableItemStackHandler storage = new NotifiableItemStackHandler((MetaMachine)this, 1, IO.NONE, IO.NONE);
        storage.setFilter(i -> {
            CompoundTag tag = i.m_41783_();
            return tag != null && tag.m_128471_("machine");
        });
        return storage;
    }

    @Override
    public DisplayComponentList provideInformation() {
        DisplayComponentList informationList = super.provideInformation();
        if (this.bufferCache.length == DISPLAY_REGISTRY.size()) {
            for (int i = 0; i < this.bufferCache.length; ++i) {
                if (!DISPLAY_REGISTRY.containsKey((Object)i) || this.bufferCache[i] == null || this.bufferCache[i].equals((Object)Component.m_237119_())) continue;
                if (DISPLAY_REGISTRY.get((Object)i) == DisplayRegistry.MACHINE_PROGRESS) {
                    Component c = this.bufferCache[i];
                    informationList.addIfAbsent(((DisplayRegistry)((Object)DISPLAY_REGISTRY.get((Object)i))).id(), DisplayComponent.progressBar(((DisplayRegistry)((Object)DISPLAY_REGISTRY.get((Object)i))).id(), this.progress, c.getString(), ProgressBarColorStyle.Companion.getDURATION()));
                    continue;
                }
                informationList.addIfAbsent(((DisplayRegistry)((Object)DISPLAY_REGISTRY.get((Object)i))).id(), this.bufferCache[i].m_7532_());
            }
        }
        return informationList;
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.getOffsetTimer() % 10 == 0 && this.bufferCache != null) {
            this.textListCache = Stream.of(this.bufferCache).map(component -> (Component)Objects.requireNonNullElse(component, Component.m_237119_())).map(Component::m_7532_).toList();
        }
    }

    @Override
    public void syncInfoFromServer() {
        if (this.textListCache == null) {
            this.bufferCache = this.getComponentArray();
        }
    }

    public Component[] getComponentArray() {
        if (this.isCardChange) {
            ItemStack card = this.inventory.storage.getStackInSlot(0);
            if (card.m_41619_()) {
                return new Component[0];
            }
            CompoundTag posTags = card.m_41783_();
            if (!(posTags != null && posTags.m_128441_("x") && posTags.m_128441_("y") && posTags.m_128441_("z"))) {
                return new Component[0];
            }
            this.pos = new BlockPos(posTags.m_128451_("x"), posTags.m_128451_("y"), posTags.m_128451_("z"));
            this.isCardChange = false;
        }
        if (this.pos == null) {
            return new Component[0];
        }
        final Level level = this.getLevel();
        final CompoundTag tags = new CompoundTag();
        this.tile = Objects.requireNonNull(this.getLevel()).m_7702_(this.pos);
        if (this.tile != null) {
            if (this.accessor == null) {
                this.accessor = new BlockAccessor(){

                    public Level getLevel() {
                        return level;
                    }

                    public Player getPlayer() {
                        return null;
                    }

                    @NotNull
                    public CompoundTag getServerData() {
                        return tags;
                    }

                    public BlockHitResult getHitResult() {
                        return null;
                    }

                    public boolean isServerConnected() {
                        return false;
                    }

                    public ItemStack getPickedResult() {
                        return null;
                    }

                    public boolean showDetails() {
                        return false;
                    }

                    public Object getTarget() {
                        return null;
                    }

                    public void toNetwork(FriendlyByteBuf friendlyByteBuf) {
                    }

                    public boolean verifyData(CompoundTag compoundTag) {
                        return false;
                    }

                    public Block getBlock() {
                        return null;
                    }

                    public BlockState getBlockState() {
                        return null;
                    }

                    public BlockEntity getBlockEntity() {
                        return MonitorMachine.this.tile;
                    }

                    public BlockPos getPosition() {
                        return MonitorMachine.this.pos;
                    }

                    public Direction getSide() {
                        return null;
                    }

                    public boolean isFakeBlock() {
                        return false;
                    }

                    public ItemStack getFakeBlock() {
                        return null;
                    }
                };
            }
            if (this.providers == null) {
                this.providers = WailaCommonRegistration.INSTANCE.getBlockNBTProviders(this.tile);
            }
            if (!this.providers.isEmpty()) {
                this.providers.forEach(provider -> {
                    try {
                        provider.appendServerData(tags, (Accessor)this.accessor);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                Component[] textListCache = new Component[DISPLAY_REGISTRY.size()];
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_NAME)] = this.tile.m_58900_().m_60734_().m_49954_().m_130946_("[").m_130946_(this.pos.m_123344_()).m_130946_("]");
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_ENERGY)] = MonitorMachine.getEnergyComponent(tags);
                Pair<Component, Float> progressPair = MonitorMachine.getProgressComponent(tags);
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_PROGRESS)] = (Component)progressPair.getFirst();
                this.progress = ((Float)progressPair.getSecond()).floatValue();
                Component[] recipeLogic = MonitorMachine.getRecipeLogicComponents(this.tile, tags);
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_RECIPE_LOGIC_EU)] = recipeLogic[0];
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_RECIPE_LOGIC_MANA)] = recipeLogic[1];
                Component[] recipeOut = MonitorMachine.getRecipeOutputComponents(tags);
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_RECIPE_OUTPUT)] = recipeOut[0];
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_RECIPE_OUTPUT_ITEM_1)] = recipeOut[1];
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_RECIPE_OUTPUT_ITEM_2)] = recipeOut[2];
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_RECIPE_OUTPUT_ITEM_3)] = recipeOut[3];
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_RECIPE_OUTPUT_FLUID_1)] = recipeOut[4];
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_RECIPE_OUTPUT_FLUID_2)] = recipeOut[5];
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_RECIPE_OUTPUT_FLUID_3)] = recipeOut[6];
                textListCache[this.IndexOf((DisplayRegistry)DisplayRegistry.MACHINE_MANTENANCE)] = MonitorMachine.getMantenanceComponent(tags);
                return textListCache;
            }
        }
        return new Component[0];
    }

    private static Component getEnergyComponent(CompoundTag tags) {
        MutableComponent component = Component.m_237119_();
        CompoundTag capData = tags.m_128469_(GTCEu.id((String)"electric_container_provider").toString()).m_128469_("null");
        if (capData.m_128441_("Energy") || capData.m_128441_("MaxEnergy")) {
            BigInteger energy = new BigInteger(capData.m_128463_("Energy"));
            BigInteger maxEnergy = new BigInteger(capData.m_128463_("MaxEnergy"));
            if (maxEnergy.compareTo(BigInteger.ZERO) > 0) {
                BigInteger threshold = BigInteger.valueOf(1000000000000L);
                String energyStr = FormattingUtil.formatNumberOrSic((BigInteger)energy, (BigInteger)threshold);
                String maxEnergyStr = FormattingUtil.formatNumberOrSic((BigInteger)maxEnergy, (BigInteger)threshold);
                component = Component.m_237110_((String)"gtceu.jade.energy_stored", (Object[])new Object[]{energyStr, maxEnergyStr});
            }
        }
        return component;
    }

    private static Pair<Component, Float> getProgressComponent(CompoundTag tags) {
        MutableComponent component = Component.m_237119_();
        float progress = 0.0f;
        CompoundTag capData = tags.m_128469_(GTCEu.id((String)"workable_provider").toString()).m_128469_("null");
        if (capData.m_128471_("Active")) {
            int currentProgress = capData.m_128451_("Progress");
            int maxProgress = capData.m_128451_("MaxProgress");
            progress = (float)currentProgress / (float)maxProgress;
            if (capData.m_128471_("Research")) {
                String current = FormattingUtil.formatNumberReadable((long)currentProgress);
                String max = FormattingUtil.formatNumberReadable((long)maxProgress);
                component = Component.m_237110_((String)"gtceu.jade.progress_computation", (Object[])new Object[]{current, max});
            } else {
                MutableComponent text = maxProgress < 20 ? Component.m_237110_((String)"gtceu.jade.progress_tick", (Object[])new Object[]{currentProgress, maxProgress}) : Component.m_237110_((String)"gtceu.jade.progress_sec", (Object[])new Object[]{Math.round((float)currentProgress / 20.0f), Math.round((float)maxProgress / 20.0f)});
                if (maxProgress > 0) {
                    component = text;
                }
            }
        }
        return new Pair((Object)component, (Object)Float.valueOf(progress));
    }

    private static Component[] getRecipeLogicComponents(BlockEntity tile, CompoundTag capData) {
        Component[] components = new Component[]{Component.m_237119_(), Component.m_237119_()};
        if (capData.m_128471_("Working")) {
            CompoundTag recipeInfo = capData.m_128469_("Recipe");
            if (!recipeInfo.m_128456_()) {
                double totalEu = recipeInfo.m_128459_("totalEu");
                if (totalEu > 0.0) {
                    MutableComponent text = Component.m_237115_((String)"gtceu.top.energy_consumption").m_130946_(" ").m_7220_((Component)Component.m_237113_((String)NumberUtils.formatDouble((double)totalEu)).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)" EU").m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN));
                    byte tier = GTUtil.getOCTierByVoltage((long)(totalEu > 9.223372036854776E18 ? Long.MAX_VALUE : (long)totalEu));
                    text = text.m_7220_((Component)Component.m_237113_((String)String.format("%sA", FormattingUtil.formatNumber2Places((double)(totalEu / (double)GTValues.VEX[tier])))));
                    if (tier < GTValues.TIER_COUNT) {
                        text = text.m_7220_((Component)Component.m_237113_((String)GTValues.VNF[tier]).m_130938_(style -> style.m_178520_(GTValues.VC[tier])));
                    } else {
                        int speed = tier - 14;
                        text = text.m_7220_((Component)Component.m_237113_((String)"MAX").m_130938_(style -> style.m_131148_(TooltipHelper.rainbowColor((float)speed))).m_7220_((Component)Component.m_237113_((String)"+").m_130938_(style -> style.m_178520_(GTValues.VC[Math.min(14, speed)])).m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatNumbers((int)(tier - 14)))).m_130938_(style -> style.m_178520_(GTValues.VC[Math.min(14, speed)]))));
                    }
                    text = text.m_7220_((Component)Component.m_237113_((String)")").m_130940_(ChatFormatting.GREEN));
                    components[0] = text;
                } else {
                    long EUt = recipeInfo.m_128454_("EUt");
                    long Manat = recipeInfo.m_128454_("Manat");
                    boolean isSteam = false;
                    if (tile instanceof MetaMachineBlockEntity) {
                        MetaMachineBlockEntity mbe = (MetaMachineBlockEntity)tile;
                        MetaMachine machine = mbe.getMetaMachine();
                        if (machine instanceof SimpleSteamMachine) {
                            SimpleSteamMachine ssm = (SimpleSteamMachine)machine;
                            EUt = (long)((double)EUt * ssm.getConversionRate());
                            isSteam = true;
                        } else if (machine instanceof SteamParallelMultiblockMachine) {
                            SteamParallelMultiblockMachine smb = (SteamParallelMultiblockMachine)machine;
                            EUt = (long)((double)EUt * smb.getConversionRate());
                            isSteam = true;
                        } else if (EUt > 0L && machine instanceof IManaEnergyMachine) {
                            Manat += EUt;
                            EUt = 0L;
                        }
                    }
                    if (EUt != 0L) {
                        MutableComponent text;
                        boolean isInput = EUt > 0L;
                        EUt = Math.abs(EUt);
                        if (isSteam) {
                            text = Component.m_237113_((String)FormattingUtil.formatNumbers((long)EUt)).m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)" mB/t").m_130940_(ChatFormatting.RESET));
                        } else {
                            byte tier = GTUtil.getOCTierByVoltage((long)EUt);
                            text = Component.m_237113_((String)FormattingUtil.formatNumbers((long)EUt)).m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)" EU/t").m_130940_(ChatFormatting.RESET).m_7220_((Component)Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN)));
                            text = text.m_7220_((Component)Component.m_237113_((String)String.format("%sA", FormattingUtil.formatNumber2Places((float)((float)EUt / (float)GTValues.VEX[tier])))));
                            if (tier < GTValues.TIER_COUNT) {
                                text = text.m_7220_((Component)Component.m_237113_((String)GTValues.VNF[tier]).m_130938_(style -> style.m_178520_(GTValues.VC[tier])));
                            } else {
                                int speed = tier - 14;
                                text = text.m_7220_((Component)Component.m_237113_((String)"MAX").m_130938_(style -> style.m_131148_(TooltipHelper.rainbowColor((float)speed))).m_7220_((Component)Component.m_237113_((String)"+").m_130938_(style -> style.m_178520_(GTValues.VC[Math.min(14, speed)])).m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatNumbers((int)(tier - 14)))).m_130938_(style -> style.m_178520_(GTValues.VC[Math.min(14, speed)]))));
                            }
                            text = text.m_7220_((Component)Component.m_237113_((String)")").m_130940_(ChatFormatting.GREEN));
                        }
                        components[0] = isInput ? Component.m_237115_((String)"gtceu.top.energy_consumption").m_130946_(" ").m_7220_((Component)text) : Component.m_237115_((String)"gtceu.top.energy_production").m_130946_(" ").m_7220_((Component)text);
                    }
                    if (Manat != 0L) {
                        boolean isInput = Manat > 0L;
                        Manat = Math.abs(Manat);
                        MutableComponent text = Component.m_237113_((String)FormattingUtil.formatNumbers((long)Manat)).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)" Mana/t").m_130940_(ChatFormatting.RESET));
                        components[1] = isInput ? Component.m_237115_((String)"gtocore.recipe.mana_consumption").m_130946_(" ").m_7220_((Component)text) : Component.m_237115_((String)"gtocore.recipe.mana_production").m_130946_(" ").m_7220_((Component)text);
                    }
                }
            }
        } else {
            MutableComponent c;
            String reason = capData.m_128461_("reason");
            if (!reason.isEmpty() && (c = Component.Serializer.m_130701_((String)reason)) != null) {
                components[0] = c.m_130940_(ChatFormatting.GRAY);
            }
        }
        return components;
    }

    private static Component[] getRecipeOutputComponents(CompoundTag tags) {
        Component[] components = new Component[]{Component.m_237119_(), Component.m_237119_(), Component.m_237119_(), Component.m_237119_(), Component.m_237119_(), Component.m_237119_(), Component.m_237119_()};
        CompoundTag capData = tags.m_128469_(GTCEu.id((String)"recipe_output_info").toString()).m_128469_("null");
        if (capData.m_128471_("Working")) {
            long count;
            boolean estimated;
            ItemStack stack;
            int i;
            Iterator tag2;
            ListTag itemTags;
            ArrayList<CompoundTag> outputItems = new ArrayList<CompoundTag>();
            if (capData.m_128425_("OutputItems", 9) && !(itemTags = capData.m_128437_("OutputItems", 10)).isEmpty()) {
                for (Iterator tag2 : itemTags) {
                    if (!(tag2 instanceof CompoundTag)) continue;
                    CompoundTag tCompoundTag = (CompoundTag)tag2;
                    outputItems.add(tCompoundTag);
                }
            }
            ArrayList<CompoundTag> outputFluids = new ArrayList<CompoundTag>();
            if (capData.m_128425_("OutputFluids", 9)) {
                ListTag fluidTags = capData.m_128437_("OutputFluids", 10);
                for (Tag tag3 : fluidTags) {
                    if (!(tag3 instanceof CompoundTag)) continue;
                    CompoundTag tCompoundTag = (CompoundTag)tag3;
                    outputFluids.add(tCompoundTag);
                }
            }
            if (!outputItems.isEmpty() || !outputFluids.isEmpty()) {
                components[0] = Component.m_237115_((String)"gtceu.top.recipe_output");
            }
            for (i = 0; i < Math.min(outputItems.size(), 3); ++i) {
                tag2 = (CompoundTag)outputItems.get(i);
                if (tag2 == null || tag2.m_128456_()) continue;
                stack = GTOUtils.loadItemStack((CompoundTag)tag2);
                int chance = tag2.m_128451_("c");
                estimated = chance < ContentBuilder.maxChance;
                count = tag2.m_128454_("a");
                if (estimated) {
                    count = Math.max(1L, count * tag2.m_128454_("p") * (long)chance / (long)ContentBuilder.maxChance);
                }
                components[i + 1] = Component.m_237113_((String)" ").m_130946_((estimated ? "~" : "") + count).m_130946_("\u00d7 ").m_7220_(MonitorMachine.getItemName(stack)).m_130940_(ChatFormatting.WHITE);
            }
            for (i = 0; i < Math.min(outputFluids.size(), 3); ++i) {
                tag2 = (CompoundTag)outputFluids.get(i);
                if (tag2 == null || tag2.m_128456_()) continue;
                stack = GTOUtils.loadFluidStack((CompoundTag)tag2);
                int chance = tag2.m_128451_("c");
                estimated = chance < ContentBuilder.maxChance;
                count = tag2.m_128454_("a");
                if (estimated) {
                    count = Math.max(1L, count * tag2.m_128454_("p") * (long)chance / (long)ContentBuilder.maxChance);
                }
                components[i + 4] = Component.m_237113_((String)" ").m_130946_((estimated ? "~" : "") + FluidUtils.getUnicodeMillibuckets((long)count)).m_130946_(" ").m_7220_(MonitorMachine.getFluidName((FluidStack)stack)).m_130940_(ChatFormatting.WHITE);
            }
        }
        return components;
    }

    private static Component getMantenanceComponent(CompoundTag tags) {
        MutableComponent component = Component.m_237119_();
        CompoundTag capData = tags.m_128469_(GTCEu.id((String)"maintenance_info").toString()).m_128469_("null");
        if (capData.m_128425_("hasProblems", 1)) {
            component = capData.m_128471_("hasProblems") ? Component.m_237115_((String)"gtceu.top.maintenance_broken").m_130940_(ChatFormatting.RED) : Component.m_237115_((String)"gtceu.top.maintenance_fixed").m_130940_(ChatFormatting.GREEN);
        }
        return component;
    }

    @Override
    public List<ResourceLocation> getAvailableRLs() {
        List rls = super.getAvailableRLs();
        rls.addAll(DISPLAY_REGISTRY.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).map(DisplayRegistry::id).toList());
        return rls;
    }

    private static Component getItemName(ItemStack stack) {
        return ComponentUtils.m_130748_((Component)stack.m_41720_().m_41466_()).m_130940_(ChatFormatting.WHITE);
    }

    private static Component getFluidName(FluidStack stack) {
        return ComponentUtils.m_130748_((Component)stack.getDisplayName()).m_130940_(ChatFormatting.WHITE);
    }

    private int IndexOf(DisplayRegistry name) {
        return (Integer)DISPLAY_REGISTRY.inverse().get((Object)name);
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup baseWidget = (WidgetGroup)super.createUIWidget();
        SlotWidget slot = new SlotWidget((IItemHandlerModifiable)this.inventory.storage, 0, 16, 144, true, true);
        slot.appendHoverTooltips(new Component[]{Component.m_237115_((String)"gtocore.machine.machine_monitor.slot")});
        slot.setChangeListener(() -> {
            this.isCardChange = true;
        });
        slot.setBackground(new IGuiTexture[]{GuiTextures.SLOT.copy().scale(1.125f), MACHINE_COORDS_OVERLAY});
        baseWidget.addWidget((Widget)slot);
        return baseWidget;
    }

    public void onDrops(List<ItemStack> drops) {
        this.clearInventory((IItemHandlerModifiable)this.inventory);
    }
}

