/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.monitor;

import com.gtocore.data.lang.LangHandler;
import com.gtolib.GTOCore;
import net.minecraft.resources.ResourceLocation;

public enum DisplayRegistry {
    OWNER("owner", "\u6240\u6709\u8005", "Owner"),
    MANA_CURRENT("mana_current", "\u5f53\u524d\u9b54\u529b", "Current Mana"),
    MANA_CURRENT_AS_POOL("mana_current_as_pool", "\u5f53\u524d\u9b54\u529b\uff08\u4ee5\u6c60\u8ba1\u7b97\uff09", "Current Mana (as Pool)"),
    MANA_CHANGE("mana_change", "\u9b54\u529b\u53d8\u5316", "Mana Change"),
    MANA_CHANGE_AS_POOL("mana_change_as_pool", "\u9b54\u529b\u53d8\u5316\uff08\u4ee5\u6c60\u8ba1\u7b97\uff09", "Mana Change (as Pool)"),
    MANA_REMAINING_TIME("mana_remaining_time", "\u5269\u4f59\u8017\u5c3d\u65f6\u95f4", "Remaining Time Until Depletion"),
    TOTAL_ENERGY("total_energy", "\u603b\u80fd\u91cf", "Total Energy"),
    ENERGY_TRANSFER_LIMIT("energy_transfer_limit", "\u80fd\u91cf\u4f20\u8f93\u4e0a\u9650", "Energy Transfer Limit"),
    ENERGY_STAT_TITLE("energy_stat_title", "\u80fd\u91cf\u7edf\u8ba1\u6807\u9898", "Energy Statistics Title"),
    ENERGY_STAT_MINUTE("energy_stat_minute", "\u80fd\u91cf\u7edf\u8ba1\uff08\u4e0a\u4e00\u5206\u949f\uff09", "Energy Statistics (Last Minute)"),
    ENERGY_STAT_HOUR("energy_stat_hour", "\u80fd\u91cf\u7edf\u8ba1\uff08\u4e0a\u4e00\u5c0f\u65f6\uff09", "Energy Statistics (Last Hour)"),
    ENERGY_STAT_DAY("energy_stat_day", "\u80fd\u91cf\u7edf\u8ba1\uff08\u4e0a\u4e00\u5929\uff09", "Energy Statistics (Last Day)"),
    ENERGY_STAT_NOW("energy_stat_now", "\u80fd\u91cf\u7edf\u8ba1\uff08\u5f53\u524d\uff09", "Energy Statistics (Now)"),
    ENERGY_STAT_TITLE_INPUT("energy_stat_title_input", "\u80fd\u91cf\u7edf\u8ba1\u6807\u9898\uff08\u8f93\u5165\uff09", "Energy Statistics Title (INPUT)"),
    ENERGY_STAT_MINUTE_INPUT("energy_stat_minute_input", "\u80fd\u91cf\u7edf\u8ba1\uff08\u4e0a\u4e00\u5206\u949f \u8f93\u5165\uff09", "Energy Statistics (Last Minute INPUT)"),
    ENERGY_STAT_HOUR_INPUT("energy_stat_hour_input", "\u80fd\u91cf\u7edf\u8ba1\uff08\u4e0a\u4e00\u5c0f\u65f6 \u8f93\u5165\uff09", "Energy Statistics (Last Hour INPUT)"),
    ENERGY_STAT_DAY_INPUT("energy_stat_day_input", "\u80fd\u91cf\u7edf\u8ba1\uff08\u4e0a\u4e00\u5929 \u8f93\u5165\uff09", "Energy Statistics (Last Day INPUT)"),
    ENERGY_STAT_NOW_INPUT("energy_stat_now_input", "\u80fd\u91cf\u7edf\u8ba1\uff08\u5f53\u524d \u8f93\u5165\uff09", "Energy Statistics (Now INPUT)"),
    ENERGY_STAT_TITLE_OUTPUT("energy_stat_title_output", "\u80fd\u91cf\u7edf\u8ba1\u6807\u9898\uff08\u8f93\u51fa\uff09", "Energy Statistics Title (OUTPUT)"),
    ENERGY_STAT_MINUTE_OUTPUT("energy_stat_minute_output", "\u80fd\u91cf\u7edf\u8ba1\uff08\u4e0a\u4e00\u5206\u949f \u8f93\u51fa\uff09", "Energy Statistics (Last Minute OUTPUT)"),
    ENERGY_STAT_HOUR_OUTPUT("energy_stat_hour_output", "\u80fd\u91cf\u7edf\u8ba1\uff08\u4e0a\u4e00\u5c0f\u65f6 \u8f93\u51fa\uff09", "Energy Statistics (Last Hour OUTPUT)"),
    ENERGY_STAT_DAY_OUTPUT("energy_stat_day_output", "\u80fd\u91cf\u7edf\u8ba1\uff08\u4e0a\u4e00\u5929 \u8f93\u51fa\uff09", "Energy Statistics (Last Day OUTPUT)"),
    ENERGY_STAT_NOW_OUTPUT("energy_stat_now_output", "\u80fd\u91cf\u7edf\u8ba1\uff08\u5f53\u524d \u8f93\u51fa\uff09", "Energy Statistics (Now OUTPUT)"),
    ENERGY_STAT_REMAINING_TIME("energy_stat_remaining_time", "\u80fd\u91cf\u7edf\u8ba1\uff08\u5269\u4f59\u65f6\u95f4\uff09", "Energy Statistics (Remaining Time)"),
    ENERGY_STAT_BOUND_INFO("energy_stat_bound_info", "\u80fd\u6e90\u5854\u7ed1\u5b9a\u4fe1\u606f", "Energy Tower Binding Information"),
    EU_STATUS_BAR("eu_status_bar", "\u7535\u7f51\u5b58\u91cf\u6761", "Energy Grid Status Bar"),
    EnergyInputHistoryDay("energy_input_history", "\u8f93\u5165\u5386\u53f2\uff08\u5929\uff09", "Input History (Days)"),
    EnergyOutputHistoryDay("energy_output_history", "\u8f93\u51fa\u5386\u53f2\uff08\u5929\uff09", "Output History (Days)"),
    EnergyInputHistoryHour("energy_input_history_short", "\u8f93\u5165\u5386\u53f2\uff08\u5c0f\u65f6\uff09", "Input History (Hours)"),
    EnergyOutputHistoryHour("energy_output_history_short", "\u8f93\u51fa\u5386\u53f2\uff08\u5c0f\u65f6\uff09", "Output History (Hours)"),
    EnergyInputHistoryMinute("energy_input_history_minute", "\u8f93\u5165\u5386\u53f2\uff08\u5206\u949f\uff09", "Input History (Minutes)"),
    EnergyOutputHistoryMinute("energy_output_history_minute", "\u8f93\u51fa\u5386\u53f2\uff08\u5206\u949f\uff09", "Output History (Minutes)"),
    COMPUTATION_WORK("computation_work", "\u7b97\u529b\u4f7f\u7528\u60c5\u51b5", "Computation Work Usage"),
    COMPUTATION_WORK_USED("computation_work_used", "\u7b97\u529b\u4f7f\u7528\u91cf", "Computation Work Used"),
    COMPUTATION_WORK_UNAVAILABLE("computation_work_unavailable", "\u7b97\u529b\u5bb9\u5668\u4e0d\u53ef\u7528\u4fe1\u606f", "Computation Work Container Unavailable Information"),
    AE_ERROR("ae_error", "ME\u76d1\u89c6\u5668\u9519\u8bef\u4fe1\u606f", "ME Monitor Error Information"),
    AE_STATUS_0("ae_status", "\u76d1\u89c6\u7684\u7269\u54c1\u4fe1\u606f", "Monitored Item Information"),
    AE_STATUS_1("ae_status1", "\u76d1\u89c6\u7684\u6d41\u4f53\u4fe1\u606f", "Monitored Fluid Information"),
    AE_AMOUNT_0("ae_amount", "\u7269\u54c1\u603b\u91cf\u7edf\u8ba1", "Item Amount"),
    AE_AMOUNT_1("ae_amount1", "\u6d41\u4f53\u603b\u91cf\u7edf\u8ba1", "Fluid Amount"),
    AE_STAT_TITLE("ae_stat_title", "\u7edf\u8ba1\u6807\u9898", "Statistics Title"),
    AE_STAT_MINUTE_0("ae_stat_minute", "\u4e0a\u4e00\u5206\u949f\u7269\u54c1\u7edf\u8ba1", "Last Minute Item Statistics"),
    AE_STAT_MINUTE_1("ae_stat_minute1", "\u4e0a\u4e00\u5206\u949f\u6d41\u4f53\u7edf\u8ba1", "Last Minute Fluid Statistics"),
    AE_STAT_HOUR_0("ae_stat_hour", "\u4e0a\u4e00\u5c0f\u65f6\u7269\u54c1\u7edf\u8ba1", "Last Hour Item Statistics"),
    AE_STAT_HOUR_1("ae_stat_hour1", "\u4e0a\u4e00\u5c0f\u65f6\u6d41\u4f53\u7edf\u8ba1", "Last Hour Fluid Statistics"),
    AE_STAT_DAY_0("ae_stat_day", "\u4e0a\u4e00\u5929\u7269\u54c1\u7edf\u8ba1", "Last Day Item Statistics"),
    AE_STAT_DAY_1("ae_stat_day1", "\u4e0a\u4e00\u5929\u6d41\u4f53\u7edf\u8ba1", "Last Day Fluid Statistics"),
    AE_STAT_REMAINING_TIME_0("ae_stat_remaining_time", "\u5269\u4f59\u65f6\u95f4\u7edf\u8ba1\uff08\u7269\u54c1\uff09", "Remaining Time Statistics (Item)"),
    AE_STAT_REMAINING_TIME_1("ae_stat_remaining_time1", "\u5269\u4f59\u65f6\u95f4\u7edf\u8ba1\uff08\u6d41\u4f53\uff09", "Remaining Time Statistics (Fluid)"),
    AE_CPU_MONITORED("ae_cpu_monitored", "\u76d1\u89c6\u7684CPU\u4fe1\u606f", "Monitored CPU Information"),
    AE_CPU_USAGE("ae_cpu_usage", "CPU\u4f7f\u7528\u7387", "CPU Usage"),
    AE_CPU_CAPACITY("ae_cpu_capacity", "CPU\u5bb9\u91cf", "CPU Capacity"),
    AE_CPU_MODE("ae_cpu_mode", "CPU\u6a21\u5f0f", "CPU Mode"),
    AE_CPU_CURRENT_CRAFTING("ae_cpu_current_crafting", "\u5f53\u524d\u6b63\u5728\u5236\u4f5c\u7684\u7269\u54c1", "Currently Crafting Item"),
    AE_CPU_CURRENT_PROGRESS("ae_cpu_current_progress", "\u5f53\u524d\u5236\u4f5c\u8fdb\u5ea6", "Current Crafting Progress"),
    CUSTOM_DISPLAY("custom_display", "\u81ea\u5b9a\u4e49\u663e\u793a", "Custom Display"),
    MACHINE_NAME("machine_name", "\u673a\u5668\u540d", "Machine Name"),
    MACHINE_ENERGY("machine_energy", "\u80fd\u91cf", "Energy"),
    MACHINE_PROGRESS("machine_progress", "\u5de5\u4f5c\u8fdb\u5ea6", "Progress"),
    MACHINE_RECIPE_LOGIC_EU("machine_recipe_logic_eu", "\u80fd\u8017\u00b7\u4ea7\u80fd(EU)", "EU Consumption/Production"),
    MACHINE_RECIPE_LOGIC_MANA("machine_recipe_logic_mana", "\u80fd\u8017\u00b7\u4ea7\u80fd(Mana)", "Mana Consumption/Production"),
    MACHINE_RECIPE_OUTPUT("machine_recipe_output", "\u914d\u65b9\u4ea7\u7269", "Recipe Output"),
    MACHINE_RECIPE_OUTPUT_ITEM_1("machine_recipe_output_item1", "\u914d\u65b9\u4ea7\u72691(\u7269\u54c1)", "Recipe Output #1 (Item)"),
    MACHINE_RECIPE_OUTPUT_ITEM_2("machine_recipe_output_item2", "\u914d\u65b9\u4ea7\u72692(\u7269\u54c1)", "Recipe Output #2 (Item)"),
    MACHINE_RECIPE_OUTPUT_ITEM_3("machine_recipe_output_item3", "\u914d\u65b9\u4ea7\u72693(\u7269\u54c1)", "Recipe Output #3 (Item)"),
    MACHINE_RECIPE_OUTPUT_FLUID_1("machine_recipe_output_fluid1", "\u914d\u65b9\u4ea7\u72691(\u6d41\u4f53)", "Recipe Output #1 (Fluid)"),
    MACHINE_RECIPE_OUTPUT_FLUID_2("machine_recipe_output_fluid2", "\u914d\u65b9\u4ea7\u72692(\u6d41\u4f53)", "Recipe Output #2 (Fluid)"),
    MACHINE_RECIPE_OUTPUT_FLUID_3("machine_recipe_output_fluid3", "\u914d\u65b9\u4ea7\u72693(\u6d41\u4f53)", "Recipe Output #3 (Fluid)"),
    MACHINE_MANTENANCE("machine_mantenance", "\u7ef4\u62a4\u72b6\u6001", "Mantenance Status");

    private final ResourceLocation id;
    private final String langCN;
    private final String langEN;

    private DisplayRegistry(String id, String langCN, String langEN) {
        this.id = GTOCore.id((String)id);
        this.langCN = langCN;
        this.langEN = langEN;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public static String langKey(ResourceLocation id) {
        return "gtocore.machine.monitor.display_key." + id.m_135827_() + "." + id.m_135815_();
    }

    public static void registerLanguage() {
        for (DisplayRegistry displayRegistry : DisplayRegistry.values()) {
            LangHandler.addCNEN(DisplayRegistry.langKey(displayRegistry.id), displayRegistry.langCN, displayRegistry.langEN);
        }
    }
}

