/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.monitor;

import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.me.common.StackSizeRenderer;
import com.gtocore.api.gui.graphic.impl.GTOLineChartClientComponent;
import com.gtocore.api.gui.graphic.impl.GTOLineChartToolTipComponent;
import com.gtocore.api.gui.graphic.impl.GTOProgressClientComponent;
import com.gtocore.api.gui.graphic.impl.GTOProgressToolTipComponent;
import com.gtocore.api.gui.helper.GuiIn3DHelper;
import com.gtocore.api.gui.helper.ProgressBarColorStyle;
import com.gtocore.common.machine.monitor.DisplayType;
import com.gtocore.common.machine.monitor.IDisplayComponent;
import com.gtocore.common.machine.monitor.Manager;
import com.mojang.blaze3d.vertex.PoseStack;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class DisplayComponent
implements IDisplayComponent {
    private final ResourceLocation id;

    private DisplayComponent(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    public static Text text(ResourceLocation id) {
        return new Text(id);
    }

    public static Text text(ResourceLocation id, FormattedCharSequence text) {
        return DisplayComponent.text(id).setInformation(text);
    }

    public static ProgressBar progressBar(ResourceLocation id, float progress) {
        return DisplayComponent.progressBar(id, progress, 15);
    }

    public static ProgressBar progressBar(ResourceLocation id, float progress, int height) {
        return new ProgressBar(id).setInformation(Float.valueOf(progress), height);
    }

    public static ProgressBar progressBar(ResourceLocation id, float progress, String text) {
        return DisplayComponent.progressBar(id, progress, text, 15);
    }

    public static ProgressBar progressBar(ResourceLocation id, float progress, String text, int height) {
        return new ProgressBar(id).setInformation(progress, text, ProgressBarColorStyle.Companion.getDEFAULT_GREEN(), height);
    }

    public static ProgressBar progressBar(ResourceLocation id, float progress, String text, ProgressBarColorStyle style) {
        return DisplayComponent.progressBar(id, progress, text, style, 15);
    }

    public static ProgressBar progressBar(ResourceLocation id, float progress, String text, ProgressBarColorStyle style, int height) {
        return new ProgressBar(id).setInformation(progress, text, style, height);
    }

    public static LineChart lineChart(ResourceLocation id, List<BigInteger> data) {
        return new LineChart(id).setInformation(data);
    }

    public static Text textWithStack(ResourceLocation id, FormattedCharSequence text, @Nullable GenericStack stack) {
        if (stack == null) {
            return DisplayComponent.text(id, text);
        }
        return new TextWithStack(id).setInformation(text, stack);
    }

    public static class Text
    extends DisplayComponent {
        private FormattedCharSequence text = FormattedCharSequence.f_13691_;

        private Text(ResourceLocation id) {
            super(id);
        }

        @Override
        public Text setInformation(Object ... information) {
            FormattedCharSequence text0;
            Object object;
            this.text = information.length > 0 && (object = information[0]) instanceof FormattedCharSequence ? (text0 = (FormattedCharSequence)object) : FormattedCharSequence.f_13691_;
            return this;
        }

        @Override
        public FormattedCharSequence getDisplayValue() {
            return this.text;
        }

        @Override
        public DisplayType getDisplayType() {
            return DisplayType.STYLED_TEXT;
        }

        @Override
        public int getVisualWidth() {
            Font font = Minecraft.m_91087_().f_91062_;
            return font.m_92724_(this.text);
        }

        @Override
        public int getVisualHeight() {
            Font font = Minecraft.m_91087_().f_91062_;
            Objects.requireNonNull(font);
            return 9;
        }
    }

    public static class ProgressBar
    extends DisplayComponent {
        private final GTOProgressToolTipComponent toolTipComponent = new GTOProgressToolTipComponent(0.0f, "", ProgressBarColorStyle.Companion.getDEFAULT_GREEN());

        private ProgressBar(ResourceLocation id) {
            super(id);
        }

        public ProgressBar setInformation(float progress, String text, ProgressBarColorStyle style, int height) {
            return this.setInformation(Float.valueOf(progress), height, text, style);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public ProgressBar setInformation(Object ... information) {
            Object object;
            if (information.length >= 2 && (object = information[0]) instanceof Float) {
                Float progressValue = (Float)object;
                object = information[1];
                if (object instanceof Integer) {
                    Object object2;
                    Integer heightValue = (Integer)object;
                    if (information.length >= 4 && (object2 = information[2]) instanceof String) {
                        String textValue = (String)object2;
                        object2 = information[3];
                        if (object2 instanceof ProgressBarColorStyle) {
                            ProgressBarColorStyle styleValue = (ProgressBarColorStyle)object2;
                            this.toolTipComponent.setText(textValue);
                            this.toolTipComponent.setProgressColorStyle(styleValue);
                        }
                    }
                    this.toolTipComponent.setPercentage(progressValue.floatValue());
                    this.toolTipComponent.setHeight(heightValue);
                    return this;
                }
            }
            this.toolTipComponent.setPercentage(0.0f);
            return this;
        }

        @Override
        public int getVisualWidth() {
            return this.toolTipComponent.getWidth();
        }

        @Override
        public int getVisualHeight() {
            return this.toolTipComponent.getHeight();
        }

        @Override
        public DisplayType getDisplayType() {
            return DisplayType.CUSTOM_RENDERER;
        }

        @Override
        public void renderDisplay(Manager.GridNetwork network, BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, int lastLineX, int startY) {
            GuiIn3DHelper.renderIn3D(stack, (gui, pose) -> {
                pose.m_85841_(1.0f, 1.0f, 0.01f);
                new GTOProgressClientComponent(this.toolTipComponent).m_183452_(Minecraft.m_91087_().f_91062_, 0, startY, (GuiGraphics)gui);
            });
        }
    }

    public static class LineChart
    extends DisplayComponent {
        private final GTOLineChartToolTipComponent toolTipComponent = new GTOLineChartToolTipComponent(new ArrayList(), -13710223, true);

        private LineChart(ResourceLocation id) {
            super(id);
        }

        @Override
        public LineChart setInformation(Object ... information) {
            if (information.length > 0 && information[0] instanceof List) {
                try {
                    List dataList = (List)information[0];
                    this.toolTipComponent.setData(dataList);
                }
                catch (ClassCastException e) {
                    this.toolTipComponent.setData(new ArrayList());
                }
            } else {
                this.toolTipComponent.setData(new ArrayList());
            }
            return this;
        }

        @Override
        public int getVisualWidth() {
            return this.toolTipComponent.getWidth();
        }

        @Override
        public int getVisualHeight() {
            return this.toolTipComponent.getHeight();
        }

        @Override
        public DisplayType getDisplayType() {
            return DisplayType.CUSTOM_RENDERER;
        }

        @Override
        public void renderDisplay(Manager.GridNetwork network, BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, int lastLineX, int startY) {
            GuiIn3DHelper.renderIn3D(stack, (gui, pose) -> {
                pose.m_85841_(1.0f, 1.0f, 0.01f);
                new GTOLineChartClientComponent(this.toolTipComponent).m_183452_(Minecraft.m_91087_().f_91062_, 0, startY, (GuiGraphics)gui);
            });
        }
    }

    public static class TextWithStack
    extends Text {
        @Nullable
        private GenericStack genericStack;

        private TextWithStack(ResourceLocation id) {
            super(id);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public TextWithStack setInformation(Object ... information) {
            long l;
            AEKey what;
            Object object;
            super.setInformation(information);
            if (information.length <= 1 || !((object = information[1]) instanceof GenericStack)) return this;
            GenericStack genericStack = (GenericStack)object;
            try {
                AEKey aEKey;
                what = aEKey = genericStack.what();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            long amount = l = genericStack.amount();
            this.genericStack = new GenericStack(what, amount);
            return this;
        }

        @Override
        public void renderDisplay(Manager.GridNetwork network, BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, int lastLineX, int startY) {
            if (this.genericStack != null) {
                GuiIn3DHelper.renderIn3D(stack, (guiGraphics, pose) -> {
                    pose.m_85841_(1.0f, 1.0f, 0.001f);
                    AEKeyRendering.drawInGui((Minecraft)Minecraft.m_91087_(), (GuiGraphics)guiGraphics, (int)(super.getVisualWidth() + 2), (int)startY, (AEKey)this.genericStack.what());
                    pose.m_252880_(0.0f, 0.0f, 0.001f);
                    if (this.genericStack.amount() > 0L) {
                        String amtText = this.genericStack.what().formatAmount(this.genericStack.amount(), AmountFormat.SLOT);
                        StackSizeRenderer.renderSizeLabel((GuiGraphics)guiGraphics, (Font)Minecraft.m_91087_().f_91062_, (float)(super.getVisualWidth() + 2), (float)startY, (String)amtText, (boolean)false);
                    }
                });
            }
        }

        @Override
        public DisplayType getDisplayType() {
            return DisplayType.BOTH;
        }

        @Override
        public int getVisualWidth() {
            return super.getVisualWidth() + (this.genericStack != null ? 18 : 0);
        }

        @Override
        public int getVisualHeight() {
            int iconHeight = this.genericStack != null ? 16 : 0;
            return Math.max(super.getVisualHeight(), iconHeight);
        }
    }
}

