/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana.multiblock;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gtocore.common.data.GTOLoots;
import com.gtocore.common.machine.mana.multiblock.ManaMultiblockMachine;
import com.gtolib.GTOCore;
import com.gtolib.api.item.ItemStackSet;
import com.gtolib.api.machine.trait.CustomRecipeLogic;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.RecipeRunner;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.gtolib.utils.MachineUtils;
import com.gtolib.utils.MathUtil;
import com.gtolib.utils.holder.IntHolder;
import com.gtolib.utils.holder.ObjectHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class ElfExchangeMachine
extends ManaMultiblockMachine {
    private PiglinMerchant piglin;
    private int piglinSoundPlayCD = 0;
    private static final SoundEvent[] soundEntries = new SoundEvent[]{SoundEvents.f_12241_, SoundEvents.f_12243_, SoundEvents.f_12238_, SoundEvents.f_12239_, SoundEvents.f_12245_};

    public ElfExchangeMachine(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Nullable
    private Recipe getRecipe() {
        ServerLevel level;
        ObjectHolder recipe = new ObjectHolder(null);
        int mode = this.checkingCircuit(false);
        Level level2 = this.getLevel();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).m_46472_() == Level.f_46429_ && mode > 0) {
            RecipeBuilder builder = this.getRecipeBuilder().duration(120).MANAt(10L);
            LootTable lootTable = level.m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78738_);
            if (this.piglin == null) {
                this.piglin = new PiglinMerchant(level);
            }
            LootParams lootContext = new LootParams.Builder(level).m_287286_(LootContextParams.f_81455_, (Object)this.piglin).m_287235_(LootContextParamSets.f_81417_);
            ItemStackSet itemStacks = new ItemStackSet();
            recipe.value = ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)builder.copy(GTOCore.id((String)"test")).inputItems(Items.f_42417_).outputItems(Items.f_42398_).buildRawRecipe(), (long)MachineUtils.getHatchParallel((MetaMachine)this));
            if (recipe.value == null) {
                return null;
            }
            IntHolder nbt = new IntHolder(0);
            builder.MANAt(((Recipe)recipe.value).getInputMANAt());
            builder.inputItems(FastSizedIngredient.create((ItemLike)Items.f_42417_, (long)((Recipe)recipe.value).parallels));
            long parallel = Math.min(1024L, ((Recipe)recipe.value).parallels);
            long multiplier = ((Recipe)recipe.value).parallels / parallel;
            GTOLoots.modifyLoot = false;
            int i2 = 0;
            while ((long)i2 < parallel) {
                lootTable.m_287195_(lootContext).forEach(itemStack -> {
                    if (itemStack.m_41782_()) {
                        if (mode == 2 || nbt.value > 100) {
                            return;
                        }
                        ++nbt.value;
                    }
                    itemStacks.add(itemStack);
                });
                ++i2;
            }
            GTOLoots.modifyLoot = true;
            itemStacks.forEach(i -> {
                if (multiplier > 1L) {
                    i.m_41764_(MathUtil.saturatedCast((long)((long)i.m_41613_() * multiplier)));
                }
                builder.outputItems(i);
            });
            recipe.value = builder.buildRawRecipe();
        } else {
            this.getRecipeType().findRecipe((IRecipeCapabilityHolder)this, r -> {
                Recipe modify = (Recipe)this.fullModifyRecipe(r.copy());
                if (modify != null && RecipeRunner.matchRecipe((IRecipeCapabilityHolder)this, (Recipe)modify) && RecipeRunner.matchTickRecipe((IRecipeCapabilityHolder)this, (Recipe)((Recipe)recipe.value))) {
                    this.piglin = null;
                    recipe.value = modify;
                    return true;
                }
                return false;
            });
        }
        return (Recipe)recipe.value;
    }

    public boolean onWorking() {
        Level level;
        if (this.piglinSoundPlayCD > 0) {
            --this.piglinSoundPlayCD;
        } else if (this.piglin != null && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            SoundEvent soundEvent = soundEntries[level2.f_46441_.m_188503_(soundEntries.length)];
            level2.m_247517_(null, this.getPos(), soundEvent, SoundSource.BLOCKS);
            this.piglinSoundPlayCD = 10 + level2.f_46441_.m_188503_(100);
        }
        return super.onWorking();
    }

    public RecipeLogic createRecipeLogic(Object ... args) {
        return new CustomRecipeLogic((IRecipeLogicMachine)this, this::getRecipe);
    }

    private static class PiglinMerchant
    extends Piglin {
        PiglinMerchant(ServerLevel level) {
            super(EntityType.f_20511_, (Level)level);
        }
    }
}

