/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana.multiblock;

import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gtocore.common.machine.mana.multiblock.ManaMultiblockMachine;
import com.gtolib.api.GTOValues;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.modifier.ParallelLogic;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import earth.terrarium.adastra.api.planets.PlanetApi;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CosmicCelestialSpireOfConvergence
extends ManaMultiblockMachine {
    @Persisted
    private long solaris = 0L;
    @Persisted
    private long lunara = 0L;
    @Persisted
    private long voidflux = 0L;
    @Persisted
    private long stellarm = 0L;
    private static final long max_capacity = 5000000000000000000L;
    @Persisted
    private short accelerate = 0;
    private int timing;
    private TickableSubscription tickSubs;

    public CosmicCelestialSpireOfConvergence(MetaMachineBlockEntity holder) {
        super(holder);
    }

    @Nullable
    protected Recipe getRealRecipe(@NotNull Recipe recipe) {
        if (!super.beforeWorking(recipe)) {
            return null;
        }
        int solarisCost = recipe.data.m_128451_("solaris");
        int lunaraCost = recipe.data.m_128451_("lunara");
        int voidfluxCost = recipe.data.m_128451_("voidflux");
        int stellarmCost = recipe.data.m_128451_("stellarm");
        int anyCost = recipe.data.m_128451_("any");
        long parallel = 0L;
        if (solarisCost > 0) {
            parallel = this.solaris / (long)solarisCost;
        } else if (lunaraCost > 0) {
            parallel = this.lunara / (long)lunaraCost;
        } else if (voidfluxCost > 0) {
            parallel = this.voidflux / (long)voidfluxCost;
        } else if (stellarmCost > 0) {
            parallel = this.stellarm / (long)stellarmCost;
        } else if (anyCost > 0) {
            parallel = (this.solaris + this.lunara + this.voidflux + this.stellarm) / (long)anyCost;
        }
        if (parallel == 0L) {
            return null;
        }
        if ((recipe = ParallelLogic.accurateParallel((MetaMachine)this, (Recipe)recipe, (long)parallel)) == null) {
            return null;
        }
        parallel = recipe.parallels;
        if (solarisCost > 0) {
            this.solaris = Math.max(0L, this.solaris - (long)solarisCost * parallel);
        } else if (lunaraCost > 0) {
            this.lunara = Math.max(0L, this.lunara - (long)lunaraCost * parallel);
        } else if (voidfluxCost > 0) {
            this.voidflux = Math.max(0L, this.voidflux - (long)voidfluxCost * parallel);
        } else if (stellarmCost > 0) {
            this.stellarm = Math.max(0L, this.stellarm - (long)stellarmCost * parallel);
        } else {
            long deduct;
            long remainingCost = (long)anyCost * parallel;
            if (remainingCost > 0L && this.solaris > 0L) {
                deduct = Math.min(this.solaris, remainingCost);
                this.solaris = Math.max(0L, this.solaris - deduct);
                remainingCost -= deduct;
            }
            if (remainingCost > 0L && this.lunara > 0L) {
                deduct = Math.min(this.lunara, remainingCost);
                this.lunara = Math.max(0L, this.lunara - deduct);
                remainingCost -= deduct;
            }
            if (remainingCost > 0L && this.voidflux > 0L) {
                deduct = Math.min(this.voidflux, remainingCost);
                this.voidflux = Math.max(0L, this.voidflux - deduct);
                remainingCost -= deduct;
            }
            if (remainingCost > 0L && this.stellarm > 0L) {
                deduct = Math.min(this.stellarm, remainingCost);
                this.stellarm = Math.max(0L, this.stellarm - deduct);
                remainingCost -= deduct;
            }
            if (remainingCost > 0L) {
                return null;
            }
        }
        return recipe;
    }

    public void customText(@NotNull List<Component> textList) {
        super.customText(textList);
        if (this.isFormed()) {
            textList.add((Component)Component.m_237110_((String)"gtocore.machine.oc_amount", (Object[])new Object[]{this.accelerate}).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gtocore.machine.steam_parallel_machine.oc")))));
            textList.add((Component)Component.m_237115_((String)"gtocore.machine.steam_parallel_machine.modification_oc").m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[-] "), (String)"ocSub")).m_7220_(ComponentPanelWidget.withButton((Component)Component.m_237113_((String)"[+]"), (String)"ocAdd")));
        }
        if (this.solaris > 0L) {
            textList.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.solaris", (Object[])new Object[]{this.solaris}));
        }
        if (this.lunara > 0L) {
            textList.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.lunara", (Object[])new Object[]{this.lunara}));
        }
        if (this.voidflux > 0L) {
            textList.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.voidflux", (Object[])new Object[]{this.voidflux}));
        }
        if (this.stellarm > 0L) {
            textList.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.stellarm", (Object[])new Object[]{this.stellarm}));
        }
    }

    public void handleDisplayClick(@NotNull String componentData, ClickData clickData) {
        if (!clickData.isRemote) {
            this.accelerate = (short)Mth.m_14045_((int)(this.accelerate + ("ocAdd".equals(componentData) ? 1 : -1)), (int)0, (int)4);
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tickUpdate, 10);
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        ITickSubscription.unsubscribe((ISubscription)this.tickSubs);
        this.tickSubs = null;
    }

    public void onUnload() {
        super.onUnload();
        ITickSubscription.unsubscribe((ISubscription)this.tickSubs);
        this.tickSubs = null;
    }

    private void tickUpdate() {
        if (!this.isFormed()) {
            return;
        }
        Level world = this.getLevel();
        if (world == null) {
            return;
        }
        this.increase(world);
        if (this.timing == 0) {
            this.getRecipeLogic().updateTickSubscription();
            this.timing = 20;
        } else {
            --this.timing;
        }
    }

    private void increase(Level world) {
        ResourceLocation dimLocation = world.m_46472_().m_135782_();
        if (this.accelerate > 0) {
            int cost = GTOValues.MANA[this.accelerate * 2 + 4] * 2;
            if ((long)cost > this.removeMana(cost, 1, false)) {
                this.accelerate = 0;
            } else if ((long)cost > this.removeMana(cost, 1, true)) {
                this.accelerate = 0;
            }
        }
        int i = 1 << this.accelerate * 5;
        if (PlanetApi.API.isSpace(this.getLevel())) {
            this.stellarm = Math.min(5000000000000000000L, this.stellarm + 2000L * (long)i);
        } else if (GTODimensions.isVoid((ResourceLocation)dimLocation)) {
            this.solaris = Math.min(5000000000000000000L, this.solaris + 500L * (long)i);
            this.lunara = Math.min(5000000000000000000L, this.lunara + 500L * (long)i);
        } else if (GTODimensions.OTHERSIDE.equals((Object)dimLocation)) {
            this.voidflux = Math.min(5000000000000000000L, this.voidflux + 5000L * (long)i);
        } else if (GTODimensions.ALFHEIM.equals((Object)dimLocation)) {
            if (world.m_46461_()) {
                this.solaris = Math.min(5000000000000000000L, this.solaris + 2000L * (long)i);
            } else if (world.m_46462_()) {
                this.lunara = Math.min(5000000000000000000L, this.lunara + 2000L * (long)i);
            }
        } else if (world.m_46472_().equals((Object)Level.f_46430_)) {
            this.voidflux = Math.min(5000000000000000000L, this.voidflux + 1000L * (long)i);
        } else if (world.m_46461_()) {
            this.solaris = Math.min(5000000000000000000L, this.solaris + 1000L * (long)i);
        } else if (world.m_46462_()) {
            this.lunara = Math.min(5000000000000000000L, this.lunara + 1000L * (long)i);
        }
    }
}

