/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana;

import appbot.ae2.ManaKey;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.integration.ae2.machine.feature.IGridConnectedMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.GridNodeHolder;
import com.gtocore.utils.ManaUnification;
import com.gtolib.api.machine.mana.feature.IWirelessManaContainerHolder;
import com.gtolib.api.wireless.WirelessManaContainer;
import com.hepdd.gtmthings.utils.BigIntegerUtils;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import gripe._90.arseng.me.key.SourceKey;
import java.math.BigInteger;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class MEManaInterface
extends MetaMachine
implements IGridConnectedMachine,
MEStorage,
IMachineLife,
IWirelessManaContainerHolder,
IStorageProvider,
IFancyUIMachine {
    private WirelessManaContainer wirelessManaContainerCache;
    @Persisted
    private final GridNodeHolder nodeHolder = new GridNodeHolder((IGridConnectedMachine)this);
    @DescSynced
    private boolean isOnline;
    @Persisted
    private int priority = 0;

    public MEManaInterface(MetaMachineBlockEntity holder) {
        super(holder);
        this.getMainNode().addService(IStorageProvider.class, (IGridNodeService)this);
    }

    public IManagedGridNode getMainNode() {
        return this.nodeHolder.getMainNode();
    }

    public Component getDescription() {
        return Component.m_237115_((String)"ars_nouveau.category.source").m_130946_("&").m_7220_((Component)Component.m_237115_((String)"ftbquests.task.ftbquests.botania_mana"));
    }

    @Nullable
    public UUID getUUID() {
        return this.getOwnerUUID();
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return what == ManaKey.KEY || what == SourceKey.KEY;
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (what != ManaKey.KEY && what != SourceKey.KEY || this.getWirelessManaContainer() == null) {
            return 0L;
        }
        long converted = this.convert(what, amount);
        if (mode == Actionable.MODULATE) {
            this.getWirelessManaContainer().setStorage(this.getWirelessManaContainer().getStorage().add(BigInteger.valueOf(converted)));
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (what != ManaKey.KEY && what != SourceKey.KEY || this.getWirelessManaContainer() == null) {
            return 0L;
        }
        long converted = this.convert(what, amount);
        long stored = BigIntegerUtils.getLongValue((BigInteger)this.getWirelessManaContainer().getStorage());
        long toExtract = Math.min(stored, converted);
        if (mode == Actionable.MODULATE) {
            this.getWirelessManaContainer().setStorage(this.getWirelessManaContainer().getStorage().subtract(BigInteger.valueOf(toExtract)));
        }
        return toExtract;
    }

    private long convert(AEKey what, long amount) {
        if (what == ManaKey.KEY) {
            return amount;
        }
        if (what == SourceKey.KEY) {
            return ManaUnification.sourceToMana(amount);
        }
        return 0L;
    }

    public void getAvailableStacks(KeyCounter toAdd) {
        long storedSource;
        if (this.getWirelessManaContainer() == null) {
            return;
        }
        long stored = BigIntegerUtils.getLongValue((BigInteger)this.getWirelessManaContainer().getStorage());
        if (stored > 0L) {
            toAdd.add(ManaKey.KEY, stored);
        }
        if ((storedSource = ManaUnification.manaToSource(stored)) > 0L) {
            toAdd.add(SourceKey.KEY, storedSource);
        }
    }

    public void onMachinePlaced(@Nullable LivingEntity player, ItemStack stack) {
        if (player != null) {
            this.setOwnerUUID(player.m_20148_());
        }
    }

    public void mountInventories(IStorageMounts storageMounts) {
        storageMounts.mount((MEStorage)this);
    }

    public Widget createUIWidget() {
        int before = this.priority;
        IntInputWidget intWidget = new IntInputWidget(this::getPriority, this::setPriority);
        intWidget.setMax((Number)100000000);
        intWidget.setMin((Number)-100000000);
        intWidget.setValue((Number)before);
        return new WidgetGroup(0, 0, 100, 20).addWidget((Widget)intWidget).addWidget(new LabelWidget(24, -16, () -> "gui.ae2.Priority").setHoverTooltips(new String[]{"gui.ae2.PriorityExtractionHint", "gui.ae2.PriorityInsertionHint"}));
    }

    private void setPriority(int integer) {
        if (integer != this.priority) {
            this.priority = integer;
            if (this.getMainNode() != null) {
                IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
            }
        }
    }

    @Generated
    public WirelessManaContainer getWirelessManaContainerCache() {
        return this.wirelessManaContainerCache;
    }

    @Generated
    public void setWirelessManaContainerCache(WirelessManaContainer wirelessManaContainerCache) {
        this.wirelessManaContainerCache = wirelessManaContainerCache;
    }

    @Generated
    public boolean isOnline() {
        return this.isOnline;
    }

    @Generated
    public void setOnline(boolean isOnline) {
        this.isOnline = isOnline;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }
}

