/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.mana;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IWailaDisplayProvider;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.machine.SimpleNoEnergyMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import earth.terrarium.adastra.api.planets.PlanetApi;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class CelestialCondenser
extends SimpleNoEnergyMachine
implements IWailaDisplayProvider {
    public static final String SOLARIS = "solaris";
    public static final String LUNARA = "lunara";
    public static final String VOIDFLUX = "voidflux";
    public static final String STELLARM = "stellarm";
    @Persisted
    private int solaris = 0;
    @Persisted
    private int lunara = 0;
    @Persisted
    private int voidflux = 0;
    @Persisted
    private int stellarm = 0;
    private static final int max_capacity = 1000000;
    private int timing;
    private boolean clearSky;
    private TickableSubscription tickSubs;

    public CelestialCondenser(MetaMachineBlockEntity holder) {
        super(holder, 1, t -> 16000, new Object[0]);
    }

    public boolean beforeWorking(@NotNull GTRecipe recipe) {
        int solarisCost = recipe.data.m_128451_(SOLARIS);
        int lunaraCost = recipe.data.m_128451_(LUNARA);
        int voidfluxCost = recipe.data.m_128451_(VOIDFLUX);
        int stellarmCost = recipe.data.m_128451_(STELLARM);
        int anyCost = recipe.data.m_128451_("any");
        if (solarisCost > 0 && solarisCost > this.solaris) {
            return false;
        }
        if (lunaraCost > 0 && lunaraCost > this.lunara) {
            return false;
        }
        if (voidfluxCost > 0 && voidfluxCost > this.voidflux) {
            return false;
        }
        if (stellarmCost > 0 && stellarmCost > this.stellarm) {
            return false;
        }
        if (anyCost > 0 && anyCost > this.solaris && anyCost > this.lunara && anyCost > this.voidflux && anyCost > this.stellarm) {
            return false;
        }
        if (!super.beforeWorking(recipe)) {
            return false;
        }
        if (solarisCost > 0) {
            this.solaris -= solarisCost;
        } else if (lunaraCost > 0) {
            this.lunara -= lunaraCost;
        } else if (voidfluxCost > 0) {
            this.voidflux -= voidfluxCost;
        } else if (stellarmCost > 0) {
            this.stellarm -= stellarmCost;
        } else if (anyCost > 0) {
            if (this.solaris >= anyCost) {
                this.solaris -= anyCost;
            } else if (this.lunara >= anyCost) {
                this.lunara -= anyCost;
            } else if (this.voidflux >= anyCost) {
                this.voidflux -= anyCost;
            } else {
                this.stellarm -= anyCost;
            }
        }
        return true;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tickUpdate, 10);
        }
    }

    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    private void tickUpdate() {
        Level world = this.getLevel();
        if (world == null) {
            return;
        }
        BlockPos pos = this.getPos();
        if (this.timing == 0) {
            this.getRecipeLogic().updateTickSubscription();
            this.clearSky = CelestialCondenser.hasClearSky(world, pos);
            this.timing = 20;
        } else if (this.timing % 5 == 0) {
            this.clearSky = CelestialCondenser.hasClearSky(world, pos);
            --this.timing;
        } else {
            --this.timing;
        }
        if (this.clearSky) {
            this.increase(world);
        }
    }

    private void increase(Level world) {
        ResourceLocation dimLocation = world.m_46472_().m_135782_();
        if (PlanetApi.API.isSpace(this.getLevel())) {
            this.stellarm = Math.min(1000000, this.stellarm + 20);
        } else if (GTODimensions.isVoid((ResourceLocation)dimLocation)) {
            this.solaris = Math.min(1000000, this.solaris + 5);
            this.lunara = Math.min(1000000, this.lunara + 5);
        } else if (GTODimensions.OTHERSIDE.equals((Object)dimLocation)) {
            this.voidflux = Math.min(1000000, this.voidflux + 50);
        } else if (GTODimensions.ALFHEIM.equals((Object)dimLocation)) {
            if (world.m_46461_()) {
                this.solaris = Math.min(1000000, this.solaris + 20);
            } else if (world.m_46462_()) {
                this.lunara = Math.min(1000000, this.lunara + 20);
            }
        } else if (world.m_46472_().equals((Object)Level.f_46430_)) {
            this.voidflux = Math.min(1000000, this.voidflux + 10);
        } else if (world.m_46461_()) {
            this.solaris = Math.min(1000000, this.solaris + 10);
        } else if (world.m_46462_()) {
            this.lunara = Math.min(1000000, this.lunara + 10);
        }
    }

    private static boolean hasClearSky(Level world, BlockPos pos) {
        BlockPos checkPos = pos.m_7494_();
        if (!CelestialCondenser.canSeeSky(world, pos)) {
            return false;
        }
        if (world.m_46472_().equals((Object)Level.f_46430_)) {
            return true;
        }
        Biome biome = (Biome)world.m_204166_(checkPos).m_203334_();
        boolean hasPrecipitation = world.m_46471_() && (biome.m_198906_(checkPos) || biome.m_198904_(checkPos));
        return !hasPrecipitation;
    }

    private static boolean canSeeSky(Level world, BlockPos blockPos) {
        int maxY = world.m_151558_();
        BlockPos.MutableBlockPos checkPos = blockPos.m_122032_().m_122173_(Direction.UP);
        while (checkPos.m_123342_() < maxY) {
            if (!world.m_8055_((BlockPos)checkPos).m_60734_().equals(Blocks.f_50016_)) {
                return false;
            }
            checkPos.m_122173_(Direction.UP);
        }
        return true;
    }

    public void appendWailaTooltip(CompoundTag data, ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        int solaris = data.m_128451_(SOLARIS);
        int lunara = data.m_128451_(LUNARA);
        int voidflux = data.m_128451_(VOIDFLUX);
        int stellarm = data.m_128451_(STELLARM);
        int maxCapacity = data.m_128451_("max_capacity");
        if (solaris > 0) {
            iTooltip.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.solaris", (Object[])new Object[]{solaris + "/" + maxCapacity}));
        }
        if (lunara > 0) {
            iTooltip.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.lunara", (Object[])new Object[]{lunara + "/" + maxCapacity}));
        }
        if (voidflux > 0) {
            iTooltip.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.voidflux", (Object[])new Object[]{voidflux + "/" + maxCapacity}));
        }
        if (stellarm > 0) {
            iTooltip.add((Component)Component.m_237110_((String)"gtocore.celestial_condenser.stellarm", (Object[])new Object[]{stellarm + "/" + maxCapacity}));
        }
    }

    public void appendWailaData(CompoundTag data, BlockAccessor blockAccessor) {
        data.m_128405_(SOLARIS, this.solaris);
        data.m_128405_(LUNARA, this.lunara);
        data.m_128405_(VOIDFLUX, this.voidflux);
        data.m_128405_(STELLARM, this.stellarm);
        data.m_128405_("max_capacity", 1000000);
    }
}

