/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.machine.generator;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.item.KineticRotorItem;
import com.gtolib.api.annotation.Scanned;
import com.gtolib.api.annotation.dynamic.DynamicInitialValue;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.machine.part.ItemPartMachine;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Scanned
public final class WindMillTurbineMachine
extends TieredEnergyMachine
implements IMachineLife,
IFancyUIMachine {
    @DynamicInitialValue(key="wind_mill_turbine.amperage_out", typeKey="amperage_out", easyValue="2", normalValue="1", expertValue="1", cn="\u8f93\u51fa\u7535\u6d41", cnComment="\u98ce\u529b\u6da1\u8f6e\u673a\u7684\u6700\u5927\u8f93\u51fa\u7535\u6d41\u3002", en="Output Amperage", enComment="The maximum output amperage of the wind turbine.")
    private static int amperage_out = 2;
    @Persisted
    private final NotifiableItemStackHandler inventory = this.createMachineStorage();
    @Persisted
    @DescSynced
    private float spinSpeed;
    private float bladeAngle;
    @DescSynced
    private int material;
    @DescSynced
    private boolean hasRotor;
    @DescSynced
    private boolean obstructed;
    @DescSynced
    private float wind;
    @DescSynced
    private int actualPower;
    private TickableSubscription energySubs;

    public WindMillTurbineMachine(MetaMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, args);
    }

    private static int getMaxWind(int tier) {
        return 10 + 10 * tier;
    }

    public static int getAmperage_out() {
        return amperage_out;
    }

    private NotifiableItemStackHandler createMachineStorage() {
        NotifiableItemStackHandler storage = new NotifiableItemStackHandler((MetaMachine)this, 1, IO.NONE, IO.BOTH);
        storage.setFilter(i -> i.m_41720_() instanceof KineticRotorItem);
        return storage;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.energySubs = this.subscribeServerTick(this.energySubs, this::checkEnergy, 20);
        }
    }

    public void onUnload() {
        super.onUnload();
        this.unsubscribe();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        this.bladeAngle += this.spinSpeed;
    }

    private void unsubscribe() {
        if (this.energySubs != null) {
            this.energySubs.unsubscribe();
            this.energySubs = null;
        }
    }

    private void checkEnergy() {
        Item item;
        int maxDamage;
        Planet planet;
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.actualPower = 0;
        ItemStack stack = this.inventory.storage.getStackInSlot(0);
        if (!(GTODimensions.isOverworld((ResourceLocation)level.m_46472_().m_135782_()) || (planet = PlanetApi.API.getPlanet(level)) != null && planet.oxygen())) {
            this.unsubscribe();
            return;
        }
        BlockPos pos = this.getPos();
        float multiplier = level.m_46470_() ? 2.0f : (level.m_46471_() ? 1.5f : 1.0f);
        this.wind = (float)((double)multiplier * Math.sqrt((float)pos.m_123342_() + 4.0f * multiplier * GTValues.RNG.m_188501_()));
        int damage = stack.m_41773_();
        if (damage < (maxDamage = stack.m_41776_()) && (item = stack.m_41720_()) instanceof KineticRotorItem) {
            int y;
            int x;
            KineticRotorItem rotorItem = (KineticRotorItem)item;
            this.hasRotor = true;
            this.material = rotorItem.getMaterial();
            this.obstructed = false;
            Direction facing = this.getFrontFacing();
            Direction back = facing.m_122424_();
            boolean permuteXZ = back.m_122434_() == Direction.Axis.Z;
            BlockPos centerPos = pos.m_121945_(back);
            block0: for (x = -2; x < 3; ++x) {
                for (y = -2; y < 3; ++y) {
                    MetaMachine metaMachine;
                    if (x == 0 && y == 0 || !((metaMachine = WindMillTurbineMachine.getMachine((BlockGetter)level, (BlockPos)pos.m_7918_(permuteXZ ? x : 0, y, permuteXZ ? 0 : x))) instanceof WindMillTurbineMachine)) continue;
                    WindMillTurbineMachine machine = (WindMillTurbineMachine)metaMachine;
                    if (!machine.hasRotor || machine.getFrontFacing() != facing) continue;
                    this.obstructed = true;
                    break block0;
                }
            }
            block2: for (x = -1; x < 2; ++x) {
                for (y = -1; y < 2; ++y) {
                    BlockPos blockPos = centerPos.m_7918_(permuteXZ ? x : 0, y, permuteXZ ? 0 : x);
                    List entityList = level.m_45976_(Entity.class, AABB.m_165882_((Vec3)new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()), (double)1.0, (double)1.0, (double)1.0));
                    for (Entity e : entityList) {
                        if (e instanceof LivingEntity) {
                            e.m_6469_(e.m_269291_().m_287172_(), 20.0f * this.spinSpeed);
                        }
                        this.obstructed = true;
                    }
                    if (level.m_8055_(blockPos).m_60795_()) continue;
                    this.obstructed = true;
                    break block2;
                }
            }
            int eLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack) + 1;
            if (this.obstructed) {
                stack.m_41721_(damage + (int)(40.0f * this.spinSpeed / (float)eLevel + 1.0f));
                this.spinSpeed = 0.0f;
            } else if (this.wind > (float)rotorItem.getMinWind()) {
                stack.m_41721_(damage + (int)(Math.pow(Math.ceil(this.wind / (float)rotorItem.getMaxWind()), 16.0) / (double)eLevel + 1.0));
                this.spinSpeed = Math.min(0.05f * this.wind, this.spinSpeed + 0.04f);
                this.actualPower = (int)((float)GTValues.V[this.tier] * this.spinSpeed * 20.0f * (float)this.getMaxInputOutputAmperage() / (float)WindMillTurbineMachine.getMaxWind(this.tier));
                this.energyContainer.addEnergy(20L * (long)this.actualPower);
            }
        } else {
            if (this.hasRotor) {
                this.requestSync();
                this.inventory.storage.setStackInSlot(0, ItemStack.f_41583_);
            }
            this.spinSpeed = 0.0f;
            this.hasRotor = false;
        }
    }

    public Widget createUIWidget() {
        return ItemPartMachine.createSLOTWidget((NotifiableItemStackHandler)this.inventory);
    }

    public void attachTooltips(TooltipsPanel tooltipsPanel) {
        tooltipsPanel.attachTooltips(new IFancyTooltip[]{new IFancyTooltip.Basic(() -> GuiTextures.INDICATOR_NO_STEAM.get(false), () -> List.of(Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.obstructed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))), this::isObstructed, () -> null)});
        tooltipsPanel.attachTooltips(new IFancyTooltip[]{new IFancyTooltip.Basic(() -> GuiTextures.INFO_ICON, () -> List.of(Component.m_237110_((String)"gtocore.machine.wind_mill_turbine.wind", (Object[])new Object[]{FormattingUtil.formatNumbers((double)this.wind)}), Component.m_237110_((String)"gtocore.machine.wind_mill_turbine.actualPower", (Object[])new Object[]{this.actualPower})), () -> true, () -> null)});
    }

    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.inventory.storage);
    }

    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        long tierVoltage = GTValues.V[this.getTier()];
        NotifiableEnergyContainer energyContainer = NotifiableEnergyContainer.emitterContainer((MetaMachine)this, (long)(tierVoltage << 6), (long)tierVoltage, (long)this.getMaxInputOutputAmperage());
        energyContainer.setSideOutputCondition(side -> !this.hasFrontFacing() || side == this.getFrontFacing());
        return energyContainer;
    }

    protected boolean isEnergyEmitter() {
        return true;
    }

    protected long getMaxInputOutputAmperage() {
        return amperage_out;
    }

    private boolean isObstructed() {
        return this.obstructed;
    }

    @Generated
    public float getSpinSpeed() {
        return this.spinSpeed;
    }

    @Generated
    public float getBladeAngle() {
        return this.bladeAngle;
    }

    @Generated
    public int getMaterial() {
        return this.material;
    }

    @Generated
    public boolean isHasRotor() {
        return this.hasRotor;
    }
}

