/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.gtolib.GTOCore;
import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RewardBagItem
extends Item {
    private final ResourceLocation defaultLootTable;

    public RewardBagItem(Item.Properties properties, ResourceLocation defaultLootTable) {
        super(properties.m_41487_(16).m_41497_(Rarity.UNCOMMON));
        this.defaultLootTable = defaultLootTable;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack bagStack = player.m_21120_(usedHand);
        if (level instanceof ServerLevel) {
            int consumeCount;
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(this.defaultLootTable);
            if (lootTable == LootTable.f_79105_) {
                GTOCore.LOGGER.error("Loot table not registered: {}", (Object)this.defaultLootTable);
                return InteractionResultHolder.m_19100_((Object)bagStack);
            }
            int n = consumeCount = player.m_6144_() ? bagStack.m_41613_() : 1;
            if (!player.m_7500_()) {
                bagStack.m_41774_(consumeCount);
            }
            LootParams params = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81463_, (Object)bagStack).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287235_(LootContextParamSets.f_81414_);
            for (int i = 0; i < consumeCount; ++i) {
                lootTable.m_287276_(params, serverLevel.m_213780_().m_188505_(), item -> {
                    if (item.m_41619_()) {
                        return;
                    }
                    ItemEntity itemEntity = player.m_19983_(item);
                    if (itemEntity != null) {
                        itemEntity.m_32061_();
                    }
                });
            }
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11749_, SoundSource.PLAYERS, 0.8f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)bagStack);
        }
        return InteractionResultHolder.m_19096_((Object)bagStack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.item.reward_bag.increases").m_130940_(ChatFormatting.BLUE));
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack stack, @NotNull Enchantment enchantment) {
        return enchantment == Enchantments.f_44987_ || enchantment == Enchantments.f_44984_;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return true;
    }

    @Generated
    public ResourceLocation getDefaultLootTable() {
        return this.defaultLootTable;
    }
}

