/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.gtocore.common.data.GTOItems;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GregMembershipCardItem
extends Item {
    private static final String TAG_MEMBERSHIP_DATA = "membership_data";
    private static final String TAG_UUID = "uuid";
    private static final String TAG_SHARED = "shared";

    public GregMembershipCardItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @NotNull
    private static CompoundTag getMembershipTag(@NotNull ItemStack stack) {
        return stack.m_41698_(TAG_MEMBERSHIP_DATA);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        UUID ownerUuid = GregMembershipCardItem.getSingleUuid(stack);
        MutableComponent ownerNameComponent = Component.m_237115_((String)"gtocore.gray_membership_card.hover_text.1");
        if (ownerUuid != null && level != null) {
            Player ownerPlayer = level.m_46003_(ownerUuid);
            ownerNameComponent = ownerPlayer != null ? ownerPlayer.m_7755_() : Component.m_237115_((String)"gtocore.gray_membership_card.hover_text.2");
        }
        List<UUID> sharedUuids = GregMembershipCardItem.getSharedUuids(stack);
        ArrayList<Component> sharedNameComponents = new ArrayList<Component>();
        if (level != null) {
            for (UUID sharedUuid : sharedUuids) {
                Player sharedPlayer = level.m_46003_(sharedUuid);
                sharedNameComponents.add((Component)(sharedPlayer != null ? sharedPlayer.m_7755_() : Component.m_237115_((String)"gtocore.gray_membership_card.hover_text.2")));
            }
        }
        tooltip.add((Component)Component.m_237115_((String)"gtocore.gray_membership_card.hover_text.3").m_7220_((Component)ownerNameComponent));
        if (!sharedNameComponents.isEmpty()) {
            MutableComponent sharedNamesJoined = Component.m_237119_();
            for (int i = 0; i < sharedNameComponents.size(); ++i) {
                if (i > 0) {
                    sharedNamesJoined.m_130946_(", ");
                }
                sharedNamesJoined.m_7220_((Component)sharedNameComponents.get(i));
            }
            tooltip.add((Component)Component.m_237115_((String)"gtocore.gray_membership_card.hover_text.4").m_7220_((Component)sharedNamesJoined));
        }
    }

    public static ItemStack createWithUuid(@NotNull UUID uuid) {
        ItemStack stack = new ItemStack((ItemLike)GTOItems.GREG_MEMBERSHIP_CARD.get());
        CompoundTag membershipTag = GregMembershipCardItem.getMembershipTag(stack);
        membershipTag.m_128362_(TAG_UUID, uuid);
        return stack;
    }

    public static ItemStack createWithUuidAndSharedList(@NotNull UUID uuid, @Nullable List<UUID> sharedUuids) {
        ItemStack stack = GregMembershipCardItem.createWithUuid(uuid);
        CompoundTag membershipTag = GregMembershipCardItem.getMembershipTag(stack);
        if (sharedUuids == null || sharedUuids.isEmpty()) {
            return stack;
        }
        ListTag sharedListTag = new ListTag();
        for (UUID sharedUuid : sharedUuids) {
            sharedListTag.add((Object)NbtUtils.m_129226_((UUID)sharedUuid));
        }
        membershipTag.m_128365_(TAG_SHARED, (Tag)sharedListTag);
        return stack;
    }

    public static boolean isUuidPresent(@NotNull ItemStack stack, @NotNull UUID uuidToCheck) {
        CompoundTag membershipTag = GregMembershipCardItem.getMembershipTag(stack);
        if (membershipTag.m_128403_(TAG_UUID) && membershipTag.m_128342_(TAG_UUID).equals(uuidToCheck)) {
            return true;
        }
        if (membershipTag.m_128425_(TAG_SHARED, 9)) {
            ListTag sharedListTag = membershipTag.m_128437_(TAG_SHARED, 11);
            for (Tag tag : sharedListTag) {
                try {
                    if (!NbtUtils.m_129233_((Tag)tag).equals(uuidToCheck)) continue;
                    return true;
                }
                catch (ClassCastException | IllegalArgumentException runtimeException) {
                }
            }
        }
        return false;
    }

    @Nullable
    public static UUID getSingleUuid(@NotNull ItemStack stack) {
        CompoundTag membershipTag = GregMembershipCardItem.getMembershipTag(stack);
        if (membershipTag.m_128403_(TAG_UUID)) {
            try {
                return membershipTag.m_128342_(TAG_UUID);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    @NotNull
    public static List<UUID> getSharedUuids(@NotNull ItemStack stack) {
        ArrayList<UUID> sharedUuids = new ArrayList<UUID>();
        CompoundTag membershipTag = GregMembershipCardItem.getMembershipTag(stack);
        if (!membershipTag.m_128425_(TAG_SHARED, 9)) {
            return sharedUuids;
        }
        ListTag sharedListTag = membershipTag.m_128437_(TAG_SHARED, 11);
        for (Tag tag : sharedListTag) {
            if (!(tag instanceof IntArrayTag)) continue;
            try {
                sharedUuids.add(NbtUtils.m_129233_((Tag)tag));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return sharedUuids;
    }
}

