/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.forge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.gtocore.client.screen.MessageScreen;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002()B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0007J%\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b0\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\n \u0006*\u0004\u0018\u00010\u001d0\u001dH\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\u001fH\u0002J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006*"}, d2={"Lcom/gtocore/common/forge/ClientForge;", "", "<init>", "()V", "GSON", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "getConfigPath", "Ljava/nio/file/Path;", "VERSION_PATTERN", "Ljava/util/regex/Pattern;", "DATE_PATTERN", "ZONE_UTC8", "Ljava/time/ZoneId;", "showHistoricalMessages", "", "MESSAGE_DEFINITIONS", "", "Lcom/gtocore/common/forge/ClientForge$MessageDefinition;", "getMESSAGE_DEFINITIONS", "()Ljava/util/List;", "loadConfig", "Lcom/gtocore/common/forge/ClientForge$MessageConfig;", "saveConfig", "Lkotlin/Result;", "config", "saveConfig-IoAF18A", "(Lcom/gtocore/common/forge/ClientForge$MessageConfig;)Ljava/lang/Object;", "createSeparator", "Lnet/minecraft/network/chat/MutableComponent;", "showMessageScreen", "", "msg", "page", "", "total", "showCompletionScreen", "onClientLoggedIn", "event", "Lnet/minecraftforge/client/event/ClientPlayerNetworkEvent$LoggingIn;", "MessageDefinition", "MessageConfig", "gtocore"})
@SourceDebugExtension(value={"SMAP\nClientForge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientForge.kt\ncom/gtocore/common/forge/ClientForge\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,327:1\n1#2:328\n774#3:329\n865#3,2:330\n1068#3:332\n774#3:333\n865#3,2:334\n774#3:336\n865#3,2:337\n1068#3:339\n774#3:340\n865#3,2:341\n1068#3:343\n1761#3,3:344\n774#3:347\n865#3,2:348\n1999#3,14:350\n774#3:364\n865#3,2:365\n774#3:367\n865#3,2:368\n1869#3,2:370\n*S KotlinDebug\n*F\n+ 1 ClientForge.kt\ncom/gtocore/common/forge/ClientForge\n*L\n309#1:329\n309#1:330,2\n310#1:332\n315#1:333\n315#1:334,2\n212#1:336\n212#1:337,2\n213#1:339\n219#1:340\n219#1:341,2\n220#1:343\n225#1:344,3\n267#1:347\n267#1:348,2\n268#1:350,14\n271#1:364\n271#1:365,2\n280#1:367\n280#1:368,2\n282#1:370,2\n*E\n"})
public final class ClientForge {
    @NotNull
    public static final ClientForge INSTANCE = new ClientForge();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Pattern VERSION_PATTERN = Pattern.compile("^\\d+\\.\\d+\\.\\d+");
    private static final Pattern DATE_PATTERN = Pattern.compile("^\\d{8}$");
    @NotNull
    private static final ZoneId ZONE_UTC8;
    private static boolean showHistoricalMessages;
    @NotNull
    private static final List<MessageDefinition> MESSAGE_DEFINITIONS;

    private ClientForge() {
    }

    private final Path getConfigPath() {
        Minecraft mc = Minecraft.m_91087_();
        Path path = mc.f_91069_.toPath().resolve("config/gtocore_client_messages.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final List<MessageDefinition> getMESSAGE_DEFINITIONS() {
        return MESSAGE_DEFINITIONS;
    }

    @JvmStatic
    @NotNull
    public static final MessageConfig loadConfig() {
        Object object;
        Object $this$loadConfig_u24lambda_u243;
        Object object2 = INSTANCE;
        try {
            MessageConfig messageConfig;
            $this$loadConfig_u24lambda_u243 = object2;
            boolean bl = false;
            Path configPath = ((ClientForge)$this$loadConfig_u24lambda_u243).getConfigPath();
            if (Files.exists(configPath, new LinkOption[0])) {
                Object it = Files.readString(configPath, StandardCharsets.UTF_8);
                boolean bl2 = false;
                Object object3 = GSON.fromJson((String)it, Map.class);
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                it = ((Map)object3).getOrDefault("confirmedMessages", MapsKt.emptyMap());
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                it = MapsKt.toMutableMap((Map)((Map)it));
                boolean bl4 = false;
                messageConfig = new MessageConfig((Map<String, String>)it);
            } else {
                messageConfig = new MessageConfig(null, 1, null);
            }
            $this$loadConfig_u24lambda_u243 = Result.constructor-impl((Object)messageConfig);
        }
        catch (Throwable bl) {
            $this$loadConfig_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$loadConfig_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            it.printStackTrace();
            object = new MessageConfig(null, 1, null);
        }
        return (MessageConfig)object;
    }

    @JvmStatic
    @NotNull
    public static final Object saveConfig-IoAF18A(@NotNull MessageConfig config) {
        Object object;
        block2: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            object = INSTANCE;
            try {
                ClientForge $this$saveConfig_IoAF18A_u24lambda_u245 = object;
                boolean bl = false;
                Path configPath = $this$saveConfig_IoAF18A_u24lambda_u245.getConfigPath();
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                object2 = Result.constructor-impl((Object)Files.writeString(configPath, (CharSequence)GSON.toJson((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"confirmedMessages", config.getConfirmedMessages()))), StandardCharsets.UTF_8, new OpenOption[0]));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object it = object2 = throwable;
            boolean bl = false;
            ((Throwable)it).printStackTrace();
        }
        return object;
    }

    private final MutableComponent createSeparator() {
        Minecraft mc = Minecraft.m_91087_();
        boolean bl = false;
        int count = RangesKt.coerceAtLeast((int)(mc.f_91065_.m_93076_().m_93813_() / mc.f_91062_.m_92895_("\u2501")), (int)1);
        return Component.m_237113_((String)StringsKt.repeat((CharSequence)"\u2501", (int)count)).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY));
    }

    private final void showMessageScreen(MessageDefinition msg, int page, int total) {
        Minecraft mc = Minecraft.m_91087_();
        String langCode = mc.m_91102_().m_264236_();
        MessageConfig config = ClientForge.loadConfig();
        Function0 onConfirm = () -> ClientForge.showMessageScreen$lambda$14(config, msg, langCode, mc);
        mc.m_91152_((Screen)new MessageScreen(msg, page, total, onConfirm, null, null, 48, null));
    }

    private final void showCompletionScreen() {
        Minecraft mc = Minecraft.m_91087_();
        String langCode = mc.m_91102_().m_264236_();
        Object[] objectArray = new MutableComponent[]{Component.m_237115_((String)"gto.message.all_recent_confirmed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)), Component.m_237113_((String)"").m_130948_(Style.f_131099_), Component.m_237115_((String)"gto.message.older_messages").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)), Component.m_237115_((String)"gto.message.view_them").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY))};
        MessageDefinition completionMsg = new MessageDefinition("completion_screen", "0.0.0", "20250101", ClientForge::showCompletionScreen$lambda$15, CollectionsKt.listOf((Object[])objectArray), 0, 32, null);
        Function0 onExpand = () -> ClientForge.showCompletionScreen$lambda$20(langCode);
        Function0 onMarkAll = () -> ClientForge.showCompletionScreen$lambda$24(langCode, mc);
        Function0 onClose = () -> ClientForge.showCompletionScreen$lambda$25(mc);
        mc.m_91152_((Screen)new MessageScreen(completionMsg, 0, 0, (Function0<Unit>)onClose, (Function0<Unit>)onExpand, (Function0<Unit>)onMarkAll));
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent(priority=EventPriority.LOWEST)
    @JvmStatic
    public static final void onClientLoggedIn(@NotNull ClientPlayerNetworkEvent.LoggingIn event) {
        block2: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable;
            void $this$sortedByDescending$iv;
            Object element$iv$iv2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Minecraft mc = Minecraft.m_91087_();
            String langCode = mc.m_91102_().m_264236_();
            MessageConfig config = INSTANCE.loadConfig();
            Object object = MESSAGE_DEFINITIONS;
            boolean $i$f$filter = false;
            void var7_7 = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                MessageDefinition it = (MessageDefinition)element$iv$iv2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)langCode);
                if (!(it.shouldShow(langCode) && !config.isConfirmed(it.getContentHash()) && (showHistoricalMessages || it.isRecent()))) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            $this$filter$iv2 = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            object = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    MessageDefinition it = (MessageDefinition)b2;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (MessageDefinition)a2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
                }
            });
            Iterable it = object;
            boolean bl = false;
            Iterable iterable2 = iterable = !((Collection)it).isEmpty() ? object : null;
            if (iterable == null || (object = (MessageDefinition)CollectionsKt.first((List)iterable)) == null) break block2;
            Object msg = object;
            boolean bl2 = false;
            Iterable $i$f$filterTo22 = MESSAGE_DEFINITIONS;
            boolean $i$f$filter2 = false;
            element$iv$iv2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                MessageDefinition it2 = (MessageDefinition)element$iv$iv3;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)langCode);
                if (!(it2.shouldShow(langCode) && !config.isConfirmed(it2.getContentHash()) && (showHistoricalMessages || it2.isRecent()))) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            int total = ((List)destination$iv$iv2).size();
            Thread.startVirtualThread(() -> ClientForge.onClientLoggedIn$lambda$32$lambda$31(mc, (MessageDefinition)msg, total));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit showMessageScreen$lambda$14(MessageConfig $config, MessageDefinition $msg, String $langCode, Minecraft $mc) {
        void $this$sortedByDescending$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        $config.confirmMessage($msg.getContentHash(), $msg.getId());
        ClientForge.saveConfig-IoAF18A($config);
        Iterable iterable = MESSAGE_DEFINITIONS;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MessageDefinition it = (MessageDefinition)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$langCode);
            if (!(it.shouldShow($langCode) && !$config.isConfirmed(it.getContentHash()) && (showHistoricalMessages || it.isRecent()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List remaining = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                MessageDefinition it = (MessageDefinition)b2;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority());
                it = (MessageDefinition)a2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
            }
        });
        boolean bl = false;
        if (!((Collection)remaining).isEmpty()) {
            void $this$sortedByDescending$iv2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            destination$iv$iv = MESSAGE_DEFINITIONS;
            boolean $i$f$filter2 = false;
            Iterator iterator = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                MessageDefinition it = (MessageDefinition)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)$langCode);
                if (!(it.shouldShow($langCode) && (showHistoricalMessages || it.isRecent()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$sortedByDescending2 = false;
            List allVisible = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    MessageDefinition it = (MessageDefinition)b2;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (MessageDefinition)a2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
                }
            });
            int nextPage = allVisible.indexOf(remaining.get(0)) + 1;
            INSTANCE.showMessageScreen((MessageDefinition)remaining.get(0), nextPage, allVisible.size());
        } else {
            boolean bl3;
            block10: {
                Iterable $this$any$iv = MESSAGE_DEFINITIONS;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MessageDefinition it = (MessageDefinition)element$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)$langCode);
                        if (!(it.shouldShow($langCode) && !$config.isConfirmed(it.getContentHash()) && !it.isRecent())) continue;
                        bl3 = true;
                        break block10;
                    }
                    bl3 = false;
                }
            }
            if (bl3 && !showHistoricalMessages) {
                INSTANCE.showCompletionScreen();
            } else {
                LocalPlayer localPlayer = $mc.f_91074_;
                if (localPlayer != null) {
                    localPlayer.m_213846_((Component)Component.m_237115_((String)"gto.message.all_confirmed").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
                }
                showHistoricalMessages = false;
                $mc.m_91152_(null);
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean showCompletionScreen$lambda$15(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit showCompletionScreen$lambda$20(String $langCode) {
        block7: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object e$iv;
            Object maxElem$iv;
            Object v0;
            void $this$filterTo$iv$iv2;
            showHistoricalMessages = true;
            Iterable $this$filter$iv2 = MESSAGE_DEFINITIONS;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                MessageDefinition it = (MessageDefinition)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)$langCode);
                if (!(it.shouldShow($langCode) && !ClientForge.loadConfig().isConfirmed(it.getContentHash()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    MessageDefinition it = (MessageDefinition)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.getPriority();
                    do {
                        e$iv = iterator$iv.next();
                        MessageDefinition it2 = (MessageDefinition)e$iv;
                        $i$a$-maxByOrNull-ClientForge$showCompletionScreen$onExpand$1$2 = false;
                        int v$iv = it2.getPriority();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            MessageDefinition messageDefinition = v0;
            if (messageDefinition == null) break block7;
            MessageDefinition msg = messageDefinition;
            boolean bl = false;
            maxElem$iv = MESSAGE_DEFINITIONS;
            boolean $i$f$filter2 = false;
            e$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MessageDefinition it = (MessageDefinition)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)$langCode);
                if (!(it.shouldShow($langCode) && !ClientForge.loadConfig().isConfirmed(it.getContentHash()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            int total = ((List)destination$iv$iv2).size();
            INSTANCE.showMessageScreen(msg, 1, total);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit showCompletionScreen$lambda$24(String $langCode, Minecraft $mc) {
        block2: {
            List list;
            MessageDefinition it;
            void $this$filterTo$iv$iv;
            MessageConfig config = ClientForge.loadConfig();
            Iterable $this$filter$iv = MESSAGE_DEFINITIONS;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (MessageDefinition)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)$langCode);
                if (!(it.shouldShow($langCode) && !config.isConfirmed(it.getContentHash()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List messages = list = (List)destination$iv$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = messages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (MessageDefinition)element$iv;
                boolean bl2 = false;
                config.confirmMessage(it.getContentHash(), it.getId());
            }
            ClientForge.saveConfig-IoAF18A(config);
            showHistoricalMessages = false;
            LocalPlayer localPlayer = $mc.f_91074_;
            if (localPlayer == null) break block2;
            Object[] objectArray = new Object[]{messages.size()};
            localPlayer.m_213846_((Component)Component.m_237110_((String)"gto.message.marked_read", (Object[])objectArray).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit showCompletionScreen$lambda$25(Minecraft $mc) {
        $mc.m_91152_(null);
        showHistoricalMessages = false;
        return Unit.INSTANCE;
    }

    private static final void onClientLoggedIn$lambda$32$lambda$31$lambda$30(MessageDefinition $msg, int $total) {
        INSTANCE.showMessageScreen($msg, 1, $total);
    }

    private static final void onClientLoggedIn$lambda$32$lambda$31(Minecraft $mc, MessageDefinition $msg, int $total) {
        Thread.sleep(1000L);
        $mc.execute(() -> ClientForge.onClientLoggedIn$lambda$32$lambda$31$lambda$30($msg, $total));
    }

    static {
        ZoneId zoneId = ZoneId.of("UTC+8");
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(...)");
        ZONE_UTC8 = zoneId;
        MESSAGE_DEFINITIONS = new ArrayList();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0004J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001f\u0010\u000f\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/gtocore/common/forge/ClientForge$MessageConfig;", "", "confirmedMessages", "", "", "<init>", "(Ljava/util/Map;)V", "getConfirmedMessages", "()Ljava/util/Map;", "confirmMessage", "hash", "id", "isConfirmed", "", "component1", "copy", "equals", "other", "hashCode", "", "toString", "gtocore"})
    public static final class MessageConfig {
        @NotNull
        private final Map<String, String> confirmedMessages;

        public MessageConfig(@NotNull Map<String, String> confirmedMessages) {
            Intrinsics.checkNotNullParameter(confirmedMessages, (String)"confirmedMessages");
            this.confirmedMessages = confirmedMessages;
        }

        public /* synthetic */ MessageConfig(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = new LinkedHashMap();
            }
            this(map);
        }

        @NotNull
        public final Map<String, String> getConfirmedMessages() {
            return this.confirmedMessages;
        }

        @Nullable
        public final String confirmMessage(@NotNull String hash, @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return this.confirmedMessages.put(hash, id);
        }

        public final boolean isConfirmed(@NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return this.confirmedMessages.containsKey(hash);
        }

        @NotNull
        public final Map<String, String> component1() {
            return this.confirmedMessages;
        }

        @NotNull
        public final MessageConfig copy(@NotNull Map<String, String> confirmedMessages) {
            Intrinsics.checkNotNullParameter(confirmedMessages, (String)"confirmedMessages");
            return new MessageConfig(confirmedMessages);
        }

        public static /* synthetic */ MessageConfig copy$default(MessageConfig messageConfig, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = messageConfig.confirmedMessages;
            }
            return messageConfig.copy(map);
        }

        @NotNull
        public String toString() {
            return "MessageConfig(confirmedMessages=" + this.confirmedMessages + ")";
        }

        public int hashCode() {
            return ((Object)this.confirmedMessages).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageConfig)) {
                return false;
            }
            MessageConfig messageConfig = (MessageConfig)other;
            return Intrinsics.areEqual(this.confirmedMessages, messageConfig.confirmedMessages);
        }

        public MessageConfig() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010%\u001a\u00020\fH\u00c6\u0003JQ\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010'\u001a\u00020\u001c2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\fH\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010\u00a8\u0006+"}, d2={"Lcom/gtocore/common/forge/ClientForge$MessageDefinition;", "", "id", "", "gameVersion", "dateString", "languagePredicate", "Ljava/util/function/Predicate;", "messages", "", "Lnet/minecraft/network/chat/Component;", "priority", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/function/Predicate;Ljava/util/List;I)V", "getId", "()Ljava/lang/String;", "getGameVersion", "getDateString", "getLanguagePredicate", "()Ljava/util/function/Predicate;", "getMessages", "()Ljava/util/List;", "getPriority", "()I", "contentHash", "getContentHash", "shouldShow", "", "lang", "isRecent", "formatDate", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "toString", "gtocore"})
    @SourceDebugExtension(value={"SMAP\nClientForge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientForge.kt\ncom/gtocore/common/forge/ClientForge$MessageDefinition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,327:1\n1869#2,2:328\n1#3:330\n*S KotlinDebug\n*F\n+ 1 ClientForge.kt\ncom/gtocore/common/forge/ClientForge$MessageDefinition\n*L\n58#1:328,2\n*E\n"})
    public static final class MessageDefinition {
        @NotNull
        private final String id;
        @NotNull
        private final String gameVersion;
        @NotNull
        private final String dateString;
        @NotNull
        private final Predicate<String> languagePredicate;
        @NotNull
        private final List<Component> messages;
        private final int priority;
        @NotNull
        private final String contentHash;

        /*
         * WARNING - void declaration
         */
        public MessageDefinition(@NotNull String id, @NotNull String gameVersion, @NotNull String dateString, @NotNull Predicate<String> languagePredicate, @NotNull List<? extends Component> messages, int priority) {
            SimpleDateFormat simpleDateFormat;
            void content;
            String $this$contentHash_u24lambda_u241;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)gameVersion, (String)"gameVersion");
            Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
            Intrinsics.checkNotNullParameter(languagePredicate, (String)"languagePredicate");
            Intrinsics.checkNotNullParameter(messages, (String)"messages");
            this.id = id;
            this.gameVersion = gameVersion;
            this.dateString = dateString;
            this.languagePredicate = languagePredicate;
            this.messages = messages;
            this.priority = priority;
            StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
            MessageDefinition messageDefinition = this;
            boolean bl = false;
            ((StringBuilder)((Object)$this$contentHash_u24lambda_u241)).append("version:" + this.gameVersion + "\ndate:" + this.dateString + "\npriority:" + this.priority + "\n");
            Iterable $this$forEach$iv = this.messages;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component it = (Component)element$iv;
                boolean bl2 = false;
                ((StringBuilder)((Object)$this$contentHash_u24lambda_u241)).append(it.getString()).append("\n");
            }
            $this$contentHash_u24lambda_u241 = stringBuilder.toString();
            boolean bl3 = false;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            void var11_16 = content;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = var11_16.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] it = messageDigest.digest(byArray);
            boolean bl4 = false;
            String string = Base64.getEncoder().encodeToString(it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
            messageDefinition.contentHash = string;
            if (!VERSION_PATTERN.matcher(this.gameVersion).find()) {
                boolean $i$a$-require-ClientForge$MessageDefinition$32 = false;
                String $i$a$-require-ClientForge$MessageDefinition$32 = "Game version must start with x.x.x format, got: " + this.gameVersion;
                throw new IllegalArgumentException($i$a$-require-ClientForge$MessageDefinition$32.toString());
            }
            if (!DATE_PATTERN.matcher(this.dateString).matches()) {
                boolean $i$a$-require-ClientForge$MessageDefinition$42 = false;
                String $i$a$-require-ClientForge$MessageDefinition$42 = "Date string must be in yyyyMMdd format (UTC+8), got: " + this.dateString;
                throw new IllegalArgumentException($i$a$-require-ClientForge$MessageDefinition$42.toString());
            }
            SimpleDateFormat $this$_init__u24lambda_u246 = simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            boolean bl5 = false;
            $this$_init__u24lambda_u246.setLenient(false);
            simpleDateFormat.parse(this.dateString);
        }

        public /* synthetic */ MessageDefinition(String string, String string2, String string3, Predicate predicate, List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x20) != 0) {
                n = 0;
            }
            this(string, string2, string3, predicate, list, n);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getGameVersion() {
            return this.gameVersion;
        }

        @NotNull
        public final String getDateString() {
            return this.dateString;
        }

        @NotNull
        public final Predicate<String> getLanguagePredicate() {
            return this.languagePredicate;
        }

        @NotNull
        public final List<Component> getMessages() {
            return this.messages;
        }

        public final int getPriority() {
            return this.priority;
        }

        @NotNull
        public final String getContentHash() {
            return this.contentHash;
        }

        public final boolean shouldShow(@NotNull String lang) {
            Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
            return this.languagePredicate.test(lang);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isRecent() {
            Object object;
            if (this.priority != 0) return true;
            Object object2 = this;
            try {
                MessageDefinition $this$isRecent_u24lambda_u247 = object2;
                boolean bl = false;
                LocalDate messageDate = LocalDate.parse($this$isRecent_u24lambda_u247.dateString, DateTimeFormatter.ofPattern("yyyyMMdd"));
                object = Result.constructor-impl((Object)(ChronoUnit.DAYS.between(messageDate, LocalDate.now(ZONE_UTC8)) <= 30L ? 1 : 0));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            object = true;
            if ((Boolean)(Result.isFailure-impl((Object)object2) ? object : object2) == false) return false;
            return true;
        }

        @NotNull
        public final String formatDate() {
            Object object;
            if (this.dateString.length() == 8) {
                String string = StringsKt.take((String)this.dateString, (int)4);
                String string2 = this.dateString.substring(4, 6);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String string3 = this.dateString.substring(6, 8);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                object = string + "-" + string2 + "-" + string3;
            } else {
                object = this.dateString;
            }
            return object;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.gameVersion;
        }

        @NotNull
        public final String component3() {
            return this.dateString;
        }

        @NotNull
        public final Predicate<String> component4() {
            return this.languagePredicate;
        }

        @NotNull
        public final List<Component> component5() {
            return this.messages;
        }

        public final int component6() {
            return this.priority;
        }

        @NotNull
        public final MessageDefinition copy(@NotNull String id, @NotNull String gameVersion, @NotNull String dateString, @NotNull Predicate<String> languagePredicate, @NotNull List<? extends Component> messages, int priority) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)gameVersion, (String)"gameVersion");
            Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
            Intrinsics.checkNotNullParameter(languagePredicate, (String)"languagePredicate");
            Intrinsics.checkNotNullParameter(messages, (String)"messages");
            return new MessageDefinition(id, gameVersion, dateString, languagePredicate, messages, priority);
        }

        public static /* synthetic */ MessageDefinition copy$default(MessageDefinition messageDefinition, String string, String string2, String string3, Predicate predicate, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = messageDefinition.id;
            }
            if ((n2 & 2) != 0) {
                string2 = messageDefinition.gameVersion;
            }
            if ((n2 & 4) != 0) {
                string3 = messageDefinition.dateString;
            }
            if ((n2 & 8) != 0) {
                predicate = messageDefinition.languagePredicate;
            }
            if ((n2 & 0x10) != 0) {
                list = messageDefinition.messages;
            }
            if ((n2 & 0x20) != 0) {
                n = messageDefinition.priority;
            }
            return messageDefinition.copy(string, string2, string3, predicate, list, n);
        }

        @NotNull
        public String toString() {
            return "MessageDefinition(id=" + this.id + ", gameVersion=" + this.gameVersion + ", dateString=" + this.dateString + ", languagePredicate=" + this.languagePredicate + ", messages=" + this.messages + ", priority=" + this.priority + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.gameVersion.hashCode();
            result = result * 31 + this.dateString.hashCode();
            result = result * 31 + this.languagePredicate.hashCode();
            result = result * 31 + ((Object)this.messages).hashCode();
            result = result * 31 + Integer.hashCode(this.priority);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageDefinition)) {
                return false;
            }
            MessageDefinition messageDefinition = (MessageDefinition)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)messageDefinition.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gameVersion, (Object)messageDefinition.gameVersion)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dateString, (Object)messageDefinition.dateString)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.languagePredicate, messageDefinition.languagePredicate)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.messages, messageDefinition.messages)) {
                return false;
            }
            return this.priority == messageDefinition.priority;
        }
    }
}

