/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.data;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gtolib.GTOCore;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.machine.feature.ITemperatureMachine;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@DataGeneratorScanned
public final class GTODamageTypes {
    private static final ResourceKey<DamageType> GENERIC = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)GTOCore.id((String)"generic"));
    private static final ResourceKey<DamageType> MACHINE_HEAT_WAVE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)GTOCore.id((String)"machine_heat_wave"));
    private static final ResourceKey<DamageType> BLAST_FURNACE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)GTOCore.id((String)"blast_furnace"));
    public static final RegistrySetBuilder DAMAGE_TYPES_BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_268580_, GTODamageTypes::bootstrap);
    @RegisterLanguage(cn="\u5458\u5de5 %s \u5728\u9ad8\u7089\u91cc\u9877\u523b\u70bc\u5316", en="Player %s melted in a blast furnace.")
    private static final String BLAST_FURNACE_MSG_ID_1 = "gtocore.death.attack.blast_furnace.1";
    @RegisterLanguage(cn="\u5458\u5de5 %s \u5c1d\u8bd5\u5728\u9ad8\u7089\u91cc\u84b8\u6851\u62ff", en="Player %s tired to have a sauna in a blast furnace.")
    private static final String BLAST_FURNACE_MSG_ID_2 = "gtocore.death.attack.blast_furnace.2";
    @RegisterLanguage(cn="\u60b2\uff0c\u5458\u5de5 %s \u6b7b\u4e8e%s %sK\u7684\u70ed\u6d6a", en="Sad, employee %s died from a heat wave of %s %sK")
    private static final String MACHINE_HEAT_WAVE_MSG_ID = "gtocore.death.attack.machine_heat_wave";

    private static void bootstrap(BootstapContext<DamageType> context) {
        context.m_255272_(GENERIC, (Object)new DamageType("generic", DamageScaling.NEVER, 0.0f, DamageEffects.HURT, DeathMessageType.DEFAULT));
        context.m_255272_(MACHINE_HEAT_WAVE, (Object)new DamageType("machine_heat_wave", DamageScaling.NEVER, 0.0f, DamageEffects.BURNING, DeathMessageType.DEFAULT));
        context.m_255272_(BLAST_FURNACE, (Object)new DamageType("blast_furnace", DamageScaling.NEVER, 0.0f, DamageEffects.BURNING, DeathMessageType.DEFAULT));
    }

    public static DamageSource getGenericDamageSource(Entity entity, Component customComponent, Runnable onDeath) {
        return new GenericDamageSource((Holder<DamageType>)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(GENERIC), entity, customComponent, onDeath);
    }

    public static DamageSource getMachineHeatWaveDamageSource(Entity entity, ITemperatureMachine machine) {
        return new MachineHeatWaveDamageSource((Holder<DamageType>)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(MACHINE_HEAT_WAVE), entity, machine);
    }

    public static DamageSource getBlastFurnaceDamageSource(Entity entity) {
        return new BlastFurnaceDamageSource((Holder<DamageType>)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(BLAST_FURNACE), entity);
    }

    private static final class GenericDamageSource
    extends DamageSource {
        private final Component customComponent;
        private final Runnable onDeath;

        private GenericDamageSource(Holder<DamageType> type, Entity entity, Component customComponent, Runnable onDeath) {
            super(type, entity);
            this.customComponent = customComponent;
            this.onDeath = onDeath;
        }

        public @NotNull Component m_6157_(@NotNull LivingEntity livingEntity) {
            this.onDeath.run();
            return this.customComponent;
        }
    }

    private static final class MachineHeatWaveDamageSource
    extends DamageSource {
        private final ITemperatureMachine machine;

        private MachineHeatWaveDamageSource(Holder<DamageType> type, Entity entity, ITemperatureMachine machine) {
            super(type, entity);
            this.machine = machine;
        }

        @NotNull
        public Component m_6157_(@NotNull LivingEntity livingEntity) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                ITemperatureMachine iTemperatureMachine = this.machine;
                if (iTemperatureMachine instanceof MetaMachine) {
                    MetaMachine metaMachine = (MetaMachine)iTemperatureMachine;
                    return Component.m_237110_((String)GTODamageTypes.MACHINE_HEAT_WAVE_MSG_ID, (Object[])new Object[]{player.m_5446_(), metaMachine.getBlockState().m_60734_().m_49954_(), this.machine.getTemperature()});
                }
            }
            return super.m_6157_(livingEntity);
        }
    }

    private static final class BlastFurnaceDamageSource
    extends DamageSource {
        private BlastFurnaceDamageSource(Holder<DamageType> type, Entity entity) {
            super(type, entity);
        }

        @NotNull
        public Component m_6157_(@NotNull LivingEntity livingEntity) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                return Component.m_237110_((String)(GTValues.RNG.m_188499_() ? GTODamageTypes.BLAST_FURNACE_MSG_ID_1 : GTODamageTypes.BLAST_FURNACE_MSG_ID_2), (Object[])new Object[]{player.m_5446_()});
            }
            return super.m_6157_(livingEntity);
        }
    }
}

