/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.data;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.glodblock.github.extendedae.common.EPPItemAndBlock;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gtocore.common.saved.DysonSphereSavaedData;
import com.gtolib.api.data.Dimension;
import com.gtolib.api.misc.PlanetManagement;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.gtolib.utils.GTOUtils;
import com.gtolib.utils.ItemUtils;
import com.gtolib.utils.RLUtils;
import com.gtolib.utils.StringConverter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import org.embeddedt.modernfix.spark.SparkLaunchProfiler;

public final class GTOCommands {
    public static void init(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"gtocore").then(Commands.m_82127_((String)"gc").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Start garbage cleanup"), false);
            GTOUtils.gc();
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"spark").then(Commands.m_82127_((String)"start").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Started profiling"), false);
            SparkLaunchProfiler.start((String)"all");
            return 1;
        }))).then(Commands.m_82127_((String)"stop").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Stopped profiling"), false);
            SparkLaunchProfiler.stop((String)"all");
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"space").then(Commands.m_82127_((String)"planet").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unlock").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.m_82981_(Arrays.stream(Dimension.values()).filter(Dimension::isWithinGalaxy).map(Dimension::getLocation).map(ResourceLocation::toString), (SuggestionsBuilder)builder)).executes(ctx -> {
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)ctx, (String)"player");
            ResourceLocation id = RLUtils.parse((String)StringArgumentType.getString((CommandContext)ctx, (String)"id"));
            PlanetManagement.unlock((UUID)player.m_20148_(), (ResourceLocation)id);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)(PlanetManagement.isUnlocked((ServerPlayer)player, (ResourceLocation)id) ? "gtocore.unlocked" : "gtocore.ununlocked")), false);
            return 1;
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dyson").then(Commands.m_82127_((String)"info").executes(ctx -> {
            DysonSphereSavaedData.INSTANCE.getDysonLaunchData().forEach((g, p) -> ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\nGalaxy: ").m_130946_(g.name()).m_130946_("\nCount: " + p).m_130946_("\nDamage: " + DysonSphereSavaedData.INSTANCE.getDysonDamageData().getOrDefault(g, 0)).m_130946_("\nIn use: " + DysonSphereSavaedData.INSTANCE.getDysonUse().getOrDefault(g, false)), false));
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clean").requires(source -> source.m_6761_(2))).executes(ctx -> {
            DysonSphereSavaedData.INSTANCE.getDysonLaunchData().clear();
            DysonSphereSavaedData.INSTANCE.getDysonDamageData().clear();
            DysonSphereSavaedData.INSTANCE.getDysonUse().clear();
            DysonSphereSavaedData.INSTANCE.m_77762_();
            return 1;
        }))))).then(Commands.m_82127_((String)"hand").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (player != null) {
                GTOCommands.hand(player);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"givecell").requires(ctx -> ctx.m_6761_(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (player != null) {
                GTOCommands.giveCell(player);
            }
            return 1;
        })));
    }

    private static void giveCell(ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        GenericStack contained = ContainerItemStrategies.getContainedStack((ItemStack)stack);
        AEItemKey key = contained == null ? AEItemKey.of((ItemStack)stack) : contained.what();
        ItemStack cell = EPPItemAndBlock.INFINITY_CELL.getRecordCell((AEKey)key);
        if (!player.m_150109_().m_36054_(cell)) {
            player.m_36176_(cell, false);
        }
        player.m_213846_((Component)Component.m_237113_((String)"Given an Infinity Cell containing: ").m_7220_((Component)Component.m_237113_((String)key.getId().toString()).m_130940_(ChatFormatting.GREEN)));
    }

    private static Component copy(Component c) {
        return Component.m_237113_((String)"- ").m_130940_(ChatFormatting.GRAY).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, c.getString()))).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to copy")))).m_7220_(c);
    }

    private static void hand(ServerPlayer player) {
        Item tag2;
        player.m_213846_((Component)Component.m_237113_((String)"Item in hand:"));
        ItemStack stack = player.m_21205_();
        String s = StringConverter.fromItem((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), (int)1);
        if (s != null) {
            player.m_213846_(GTOCommands.copy((Component)Component.m_237113_((String)s).m_130940_(ChatFormatting.DARK_BLUE)));
        }
        player.m_213846_(GTOCommands.copy((Component)Component.m_237113_((String)ItemUtils.getId((ItemStack)stack)).m_130940_(ChatFormatting.GREEN)));
        if (stack.m_41782_()) {
            player.m_213846_(GTOCommands.copy((Component)Component.m_237113_((String)stack.m_41783_().toString()).m_130940_(ChatFormatting.AQUA)));
        }
        for (Item tag2 : stack.m_220173_().m_203616_().toList()) {
            player.m_213846_(GTOCommands.copy((Component)Component.m_237113_((String)tag2.f_203868_().toString()).m_130940_(ChatFormatting.YELLOW)));
        }
        tag2 = stack.m_41720_();
        if (tag2 instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)tag2;
            player.m_213846_((Component)Component.m_237113_((String)"Held fluid:"));
            Fluid fluid = bucketItem.getFluid();
            String f = StringConverter.fromFluid((FluidIngredient)FastFluidIngredient.of((long)1000L, (Fluid[])new Fluid[]{fluid}), (boolean)false);
            if (f != null) {
                player.m_213846_(GTOCommands.copy((Component)Component.m_237113_((String)f).m_130940_(ChatFormatting.AQUA)));
            }
            player.m_213846_(GTOCommands.copy((Component)Component.m_237113_((String)fluid.m_205069_().m_205785_().m_135782_().toString()).m_130940_(ChatFormatting.GREEN)));
        }
    }
}

