/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.block;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gtocore.common.block.BlockMap;
import com.gtolib.GTOCore;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.NotNull;

public class WirelessEnergyUnitBlock
extends Block {
    private final BigInteger capacity;
    private final int loss;
    private final int tier;

    public WirelessEnergyUnitBlock(BlockBehaviour.Properties properties, int tier) {
        super(properties);
        int loss_tmp;
        int sec_base = 60 << 4 - GTOCore.difficulty;
        this.capacity = BigInteger.valueOf(GTValues.VEX[tier << 1]).divide(BigInteger.valueOf(GTOCore.difficulty)).add(BigInteger.valueOf(GTValues.VEX[tier] * 20L * (long)sec_base)).multiply(BigInteger.valueOf(tier));
        int n = loss_tmp = GTOCore.isEasy() ? 0 : 14 - tier << GTOCore.difficulty;
        if (tier < 6) {
            loss_tmp += 10 * (GTOCore.difficulty << 2) / tier;
        }
        this.loss = loss_tmp;
        this.tier = tier;
    }

    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        if (GTUtil.isShiftDown()) {
            tooltip.add((Component)Component.m_237110_((String)"gtceu.multiblock.power_substation.capacity", (Object[])new Object[]{FormattingUtil.formatNumbers((Object)this.capacity)}));
            tooltip.add((Component)Component.m_237110_((String)"gtceu.machine.fluid_drilling_rig.depletion", (Object[])new Object[]{(double)this.loss / 10.0}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ad_astra.shift_description"));
        }
        tooltip.add((Component)Component.m_237115_((String)"gtocore.machine.wireless_energy_unit.tooltip"));
    }

    @Nullable
    public static WirelessEnergyUnitBlock get(int tier) {
        if (tier < 1 || tier > BlockMap.WIRELESS_ENERGY_UNIT.length + 1) {
            return null;
        }
        return (WirelessEnergyUnitBlock)BlockMap.WIRELESS_ENERGY_UNIT[tier - 1];
    }

    @Generated
    public BigInteger getCapacity() {
        return this.capacity;
    }

    @Generated
    public int getLoss() {
        return this.loss;
    }

    @Generated
    public int getTier() {
        return this.tier;
    }

    public record BlockData(@Nullable WirelessEnergyUnitBlock block, BlockPos pos) {
    }
}

