/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.block;

import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.block.IFusionCasingType;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.block.FusionCasingBlock;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOBlocks;
import com.gtolib.GTOCore;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.NotNull;

public final class FusionCasings
extends FusionCasingBlock {
    public FusionCasings(BlockBehaviour.Properties properties, IFusionCasingType casingType) {
        super(properties, casingType);
    }

    public static Block getCompressedCoilState(int tier) {
        return switch (tier) {
            case 6 -> (ActiveBlock)GTOBlocks.IMPROVED_SUPERCONDUCTOR_COIL.get();
            case 7 -> (ActiveBlock)GTOBlocks.COMPRESSED_FUSION_COIL.get();
            case 8 -> (ActiveBlock)GTOBlocks.ADVANCED_COMPRESSED_FUSION_COIL.get();
            case 9 -> (ActiveBlock)GTOBlocks.COMPRESSED_FUSION_COIL_MK2_PROTOTYPE.get();
            default -> (ActiveBlock)GTOBlocks.COMPRESSED_FUSION_COIL_MK2.get();
        };
    }

    public static Block getCoilState(int tier) {
        return tier == 9 ? (Block)GTOBlocks.ADVANCED_FUSION_COIL.get() : (Block)GTOBlocks.FUSION_COIL_MK2.get();
    }

    public static Block getFrameState(int tier) {
        return switch (tier) {
            case 6 -> ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.NaquadahAlloy);
            case 7 -> ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Duranium);
            case 8 -> ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Naquadria);
            case 9 -> ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Trinium);
            default -> ChemicalHelper.getBlock((TagPrefix)TagPrefix.frameGt, (Material)GTMaterials.Neutronium);
        };
    }

    public static Block getCasingState(int tier) {
        return switch (tier) {
            case 6 -> (FusionCasingBlock)GTBlocks.FUSION_CASING.get();
            case 7 -> (FusionCasingBlock)GTBlocks.FUSION_CASING_MK2.get();
            case 8 -> (FusionCasingBlock)GTBlocks.FUSION_CASING_MK3.get();
            case 9 -> (Block)GTOBlocks.FUSION_CASING_MK4.get();
            default -> (Block)GTOBlocks.FUSION_CASING_MK5.get();
        };
    }

    public static IFusionCasingType getCasingType(int tier) {
        return switch (tier) {
            case 6 -> FusionCasingBlock.CasingType.FUSION_CASING;
            case 7 -> FusionCasingBlock.CasingType.FUSION_CASING_MK2;
            case 8 -> FusionCasingBlock.CasingType.FUSION_CASING_MK3;
            case 9 -> CasingType.FUSION_CASING_MK4;
            default -> CasingType.FUSION_CASING_MK5;
        };
    }

    public static enum CasingType implements IFusionCasingType
    {
        FUSION_CASING_MK4("fusion_casing_mk4"),
        FUSION_CASING_MK5("fusion_casing_mk5");

        private final String name;
        private final int harvestLevel;

        private CasingType(String name) {
            this.name = name;
            this.harvestLevel = 3;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public ResourceLocation getTexture() {
            return GTOCore.id((String)"block/casings/fusion/%s".formatted(this.name));
        }

        public int getHarvestLevel() {
            return this.harvestLevel;
        }
    }
}

