/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.item;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gtocore.common.data.GTOMaterials;
import com.gtolib.utils.ColorUtils;
import java.util.function.IntSupplier;
import net.minecraft.util.Mth;
import vazkii.botania.client.core.handler.ClientTickHandler;

public final class MaterialsColorMap {
    public static final ImmutableMap<Material, IntSupplier> MaterialColors;
    static final IntSupplier quantumColor;
    private static final IntSupplier shimmer;

    public static int getCurrentRainbowColor() {
        return MaterialsColorMap.HSBToRGB((float)(System.currentTimeMillis() % 18000L) / 18000.0f);
    }

    private static int HSBToRGB(float hue) {
        int r = 0;
        int g = 0;
        int b2 = 0;
        float h = (hue - (float)Math.floor(hue)) * 6.0f;
        float f = h - (float)Math.floor(h);
        float q = 1.0f - f;
        float t = 1.0f - (1.0f - f);
        switch ((int)h) {
            case 0: {
                r = 255;
                g = (int)(t * 255.0f + 0.5f);
                break;
            }
            case 1: {
                r = (int)(q * 255.0f + 0.5f);
                g = 255;
                break;
            }
            case 2: {
                g = 255;
                b2 = (int)(t * 255.0f + 0.5f);
                break;
            }
            case 3: {
                g = (int)(q * 255.0f + 0.5f);
                b2 = 255;
                break;
            }
            case 4: {
                r = (int)(t * 255.0f + 0.5f);
                b2 = 255;
                break;
            }
            case 5: {
                r = 255;
                b2 = (int)(q * 255.0f + 0.5f);
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b2;
    }

    static {
        quantumColor = () -> {
            float spot = (float)(System.currentTimeMillis() / 500L % 10L) / 10.0f;
            if ((double)spot > 0.5) {
                spot = 1.0f - spot;
            }
            return ColorUtils.getInterpolatedColor((int)65412, (int)16743936, (float)(spot * 2.0f));
        };
        shimmer = () -> {
            float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
            return Mth.m_14169_((float)(time % 200.0f / 200.0f), (float)0.4f, (float)0.9f);
        };
        ImmutableMap.Builder MaterialBuilder = ImmutableMap.builder();
        MaterialBuilder.put((Object)GTOMaterials.Gaia, () -> Mth.m_14169_((float)((float)((ClientTickHandler.ticksInGame << 1) % 360) / 360.0f), (float)0.25f, (float)1.0f));
        MaterialBuilder.put((Object)GTOMaterials.Shimmerwood, (Object)shimmer);
        MaterialBuilder.put((Object)GTOMaterials.Shimmerrock, (Object)shimmer);
        MaterialBuilder.put((Object)GTOMaterials.BifrostPerm, (Object)shimmer);
        MaterialBuilder.put((Object)GTOMaterials.StarStone, () -> ColorUtils.getInterpolatedColor((int)11917774, (int)0xFFFFFF, (float)Math.abs(1.0f - (float)(System.currentTimeMillis() % 10000L) / 5000.0f)));
        MaterialBuilder.put((Object)GTOMaterials.ChromaticGlass, MaterialsColorMap::getCurrentRainbowColor);
        MaterialBuilder.put((Object)GTOMaterials.Hypogen, () -> ColorUtils.getInterpolatedColor((int)16727296, (int)14323968, (float)Math.abs(1.0f - (float)(System.currentTimeMillis() % 6000L) / 3000.0f)));
        MaterialBuilder.put((Object)GTOMaterials.HexaphaseCopper, () -> {
            float spot = (float)(System.currentTimeMillis() % 4000L) / 4000.0f;
            return ColorUtils.getInterpolatedColor((int)15497494, (int)65301, (float)((double)spot > 0.1 && (double)spot < 0.15 || (double)spot > 0.18 && (double)spot < 0.22 ? 1.0f : 0.0f));
        });
        MaterialBuilder.put((Object)GTOMaterials.HeavyQuarkDegenerateMatter, (Object)quantumColor);
        MaterialBuilder.put((Object)GTOMaterials.QuantumChromoDynamicallyConfinedMatter, (Object)quantumColor);
        MaterialColors = MaterialBuilder.build();
    }
}

