/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.item;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gtocore.client.renderer.item.MaterialsColorMap;
import com.gtolib.utils.ClientUtil;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import committee.nova.mods.renderblender.RenderBlenderLib;
import committee.nova.mods.renderblender.api.client.render.buffer.AlphaOverrideVertexConsumer;
import java.util.function.IntSupplier;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public record HaloItemRenderer(float pulse, IntSupplier colour, IntSupplier size, ResourceLocation texture) implements IRenderer
{
    public static final HaloItemRenderer WHITE_HALO = HaloItemRenderer.create(0.0f, -1, 4, RenderBlenderLib.rl((String)"misc/halo"));
    public static final HaloItemRenderer QUANTUM_CHROMO_DYNAMICALLY_HALO = HaloItemRenderer.create(0.0f, () -> com.gtolib.utils.ColorUtils.createARGBColor((int)MaterialsColorMap.quantumColor.getAsInt(), (int)150), () -> GTValues.RNG.m_188503_(4) + 2, RenderBlenderLib.rl((String)"misc/halo"));
    public static final HaloItemRenderer COSMIC_HALO = HaloItemRenderer.create(0.0f, -1308617415, 6, RenderBlenderLib.rl((String)"misc/halo"));
    public static final HaloItemRenderer NEUTRONIUM_HALO = HaloItemRenderer.create(0.0f, -1711276033, 8, RenderBlenderLib.rl((String)"misc/halo_noise"));
    public static final HaloItemRenderer COSMIC_NEUTRONIUM_HALO = HaloItemRenderer.create(0.05f, -1724966647, 10, RenderBlenderLib.rl((String)"misc/halo_noise"));
    public static final HaloItemRenderer CHAOS_HALO = HaloItemRenderer.create(0.2f, 0, 0, null);
    public static final HaloItemRenderer CHAOS_INFINITY_HALO = HaloItemRenderer.create(0.25f, () -> -16777216, () -> GTValues.RNG.m_188503_(4) + 6, RenderBlenderLib.rl((String)"misc/halo"));
    public static final HaloItemRenderer MAGNETOHYDRODYNAMICALLY_CONSTRAINED_STAR_MATTER_HALO = HaloItemRenderer.create(0.0f, -1291894491, 6, RenderBlenderLib.rl((String)"misc/halo"));
    public static final HaloItemRenderer INFINITY_HALO = HaloItemRenderer.create(0.1f, -16777216, 10, RenderBlenderLib.rl((String)"misc/halo"));
    public static final HaloItemRenderer ETERNITY_HALO = HaloItemRenderer.create(0.1f, -16777216, 10, RenderBlenderLib.rl((String)"misc/halo"));
    public static final HaloItemRenderer MAGMATTER_HALO = HaloItemRenderer.create(0.15f, -14606047, 10, RenderBlenderLib.rl((String)"misc/halo"));
    public static final HaloItemRenderer RADIOACTIVE = HaloItemRenderer.create(0.0f, -14581471, 9, RenderBlenderLib.rl((String)"misc/halo_noise"));

    private static HaloItemRenderer create(float pulse, int colour, int size, ResourceLocation textures) {
        return HaloItemRenderer.create(pulse, () -> colour, () -> size, textures);
    }

    private static HaloItemRenderer create(float pulse, IntSupplier colour, IntSupplier size, ResourceLocation textures) {
        return GTCEu.isClientSide() ? new HaloItemRenderer(pulse, colour, size, textures) : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        model = ClientUtil.getVanillaModel((ItemStack)stack, null, null);
        if (transformType == ItemDisplayContext.GUI) {
            if (this.texture != null) {
                poseStack.m_85836_();
                poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
                Tesselator tess = Tesselator.m_85913_();
                BufferBuilder buf = tess.m_85915_();
                buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                RenderSystem.enableBlend();
                RenderSystem.disableDepthTest();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                int colour = this.colour.getAsInt();
                RenderSystem.setShaderColor((float)ColorUtils.red((int)colour), (float)ColorUtils.green((int)colour), (float)ColorUtils.blue((int)colour), (float)ColorUtils.alpha((int)colour));
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                TextureAtlasSprite sprite = ModelFactory.getBlockSprite((ResourceLocation)this.texture);
                float minU = sprite.m_118409_();
                float maxU = sprite.m_118410_();
                float minV = sprite.m_118411_();
                float maxV = sprite.m_118412_();
                float spread = (float)this.size.getAsInt() / 16.0f;
                float min = 0.0f - spread;
                float max = 1.0f + spread;
                Matrix4f pos = poseStack.m_85850_().m_252922_();
                buf.m_252986_(pos, max, max, 0.0f).m_7421_(maxU, minV).m_5752_();
                buf.m_252986_(pos, min, max, 0.0f).m_7421_(minU, minV).m_5752_();
                buf.m_252986_(pos, min, min, 0.0f).m_7421_(minU, maxV).m_5752_();
                buf.m_252986_(pos, max, min, 0.0f).m_7421_(maxU, maxV).m_5752_();
                tess.m_85914_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.m_85849_();
            }
            ClientUtil.vanillaRender((ItemStack)stack, (ItemDisplayContext)transformType, (boolean)leftHand, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)combinedLight, (int)combinedOverlay, (BakedModel)model);
            if (this.pulse != 0.0f && !(stack.m_41720_() instanceof BlockItem)) {
                poseStack.m_85836_();
                poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
                float scale = GTValues.RNG.m_188501_() * this.pulse + 1.0f;
                float trans = (1.0f - scale) / 2.0f;
                poseStack.m_252880_(trans, trans, 0.0f);
                poseStack.m_85841_(scale, scale, 1.0001f);
                model.m_7442_().m_269404_(transformType).m_111763_(leftHand, poseStack);
                VertexConsumer vertexConsumer = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)true), (boolean)true, (boolean)stack.m_41790_());
                ClientUtil.getItemRenderer().m_115189_(model, stack, combinedLight, combinedOverlay, poseStack, (VertexConsumer)new AlphaOverrideVertexConsumer(vertexConsumer, (double)0.6f));
                poseStack.m_85849_();
            }
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
        } else {
            ClientUtil.vanillaRender((ItemStack)stack, (ItemDisplayContext)transformType, (boolean)leftHand, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)combinedLight, (int)combinedOverlay, (BakedModel)model);
        }
    }
}

