/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.hud;

import com.gtocore.api.gui.helper.LineChartHelper;
import com.gtocore.client.hud.IMoveableHUD;
import com.gtocore.config.GTOConfig;
import com.gtolib.api.annotation.DataGeneratorScanned;
import com.gtolib.api.annotation.language.RegisterLanguage;
import com.gtolib.api.player.IEnhancedPlayer;
import com.gtolib.api.player.PlayerData;
import com.hepdd.gtmthings.utils.FormatUtil;
import java.awt.Color;
import java.math.BigInteger;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@DataGeneratorScanned
public class WirelessEnergyHUD
implements IMoveableHUD {
    public static final WirelessEnergyHUD INSTANCE = new WirelessEnergyHUD();
    @RegisterLanguage(en="%s / %s EU (%d%%)", cn="%s / %s EU (%d%%)")
    public static final String FORMAT_WIRELESS_ENERGY_HUD = "hud.gtocore.wireless_energy";
    private static final int width = 80;
    private static final int height = 40;
    private int realWidth = 80;
    private int realHeight = 40;
    private boolean isDragging = false;
    private int dragStartX = 0;
    private int dragStartY = 0;
    private int pendingMovedX = 0;
    private int pendingMovedY = 0;

    @Override
    public void m_88315_(@NotNull GuiGraphics guiGraphics, int i, int i1, float v) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.pendingMovedX, (float)this.pendingMovedY, 1500.0f);
        this.renderGeneral(guiGraphics, v, Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    public void renderGeneral(GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        if (IEnhancedPlayer.of((Player)mc.f_91074_) == null) {
            return;
        }
        PlayerData playerData = IEnhancedPlayer.of((Player)mc.f_91074_).getPlayerData();
        if (playerData.electricityCapacityCache.compareTo(BigInteger.ZERO) <= 0) {
            return;
        }
        MutableComponent label = Component.m_237110_((String)FORMAT_WIRELESS_ENERGY_HUD, (Object[])new Object[]{Component.m_237113_((String)FormatUtil.formatBigIntegerNumberOrSic((BigInteger)playerData.electricityStorageCache)).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)FormatUtil.formatBigIntegerNumberOrSic((BigInteger)playerData.electricityCapacityCache)).m_130940_(ChatFormatting.GOLD), playerData.electricityStorageCache.multiply(BigInteger.valueOf(100L)).divide(playerData.electricityCapacityCache).intValue()});
        this.realWidth = Math.max(80, font.m_92852_((FormattedText)label) + 4);
        Objects.requireNonNull(font);
        this.realHeight = 40 + 9 + 2;
        Rect2i bounds = this.getBounds(screenWidth, screenHeight);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_((double)bounds.m_110085_(), (double)bounds.m_110086_(), 0.0);
        LineChartHelper.INSTANCE.builder(guiGraphics, playerData.getClientElectricityHistoryCache()).width(80).height(40).backgroundColor(-1975500736).borderColor(-1979711488).lineColor(0xBB000000 | Color.decode(GTOConfig.INSTANCE.hud.wirelessEnergyHUDLineColor).getRGB()).drawAreaFill(true).areaFillColor(1076808817).drawAreaFill(false).autoReboundY(false).yBound(0.0, 100.0).draw();
        guiGraphics.m_280614_(font, (Component)label, 2, 42, 0xFFFFFF, false);
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    public Rect2i getBounds(int screenWidth, int screenHeight) {
        int absX = (int)((double)GTOConfig.INSTANCE.hud.wirelessEnergyHUDDefaultX / 100.0 * (double)(screenWidth - this.realWidth));
        int absY = (int)((double)GTOConfig.INSTANCE.hud.wirelessEnergyHUDDefaultY / 100.0 * (double)(screenHeight - this.realHeight));
        return new Rect2i(absX, absY, this.realWidth, this.realHeight);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button2) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.isDragging = true;
            this.dragStartX = (int)mouseX;
            this.dragStartY = (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button2, double dragX, double dragY) {
        if (this.isDragging) {
            this.pendingMovedX = (int)(mouseX - (double)this.dragStartX);
            this.pendingMovedY = (int)(mouseY - (double)this.dragStartY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button2) {
        if (this.pendingMovedX != 0 || this.pendingMovedY != 0) {
            Minecraft mc = Minecraft.m_91087_();
            int screenWidth = mc.m_91268_().m_85445_();
            int screenHeight = mc.m_91268_().m_85446_();
            Rect2i bounds = this.getBounds(screenWidth, screenHeight);
            int newX = bounds.m_110085_() + this.pendingMovedX;
            int newY = bounds.m_110086_() + this.pendingMovedY;
            GTOConfig.set("wirelessEnergyHUDDefaultX", (int)Mth.m_14008_((double)((double)newX * 100.0 / (double)(screenWidth - this.realWidth)), (double)0.0, (double)100.0), "hud");
            GTOConfig.set("wirelessEnergyHUDDefaultY", (int)Mth.m_14008_((double)((double)newY * 100.0 / (double)(screenHeight - this.realHeight)), (double)0.0, (double)100.0), "hud");
            this.pendingMovedX = 0;
            this.pendingMovedY = 0;
            this.isDragging = false;
            return true;
        }
        return false;
    }

    @Override
    public void toggleEnabled() {
        GTOConfig.set("wirelessEnergyHUDEnabled", !GTOConfig.INSTANCE.hud.wirelessEnergyHUDEnabled, "hud");
    }

    @Override
    public boolean isEnabled() {
        return GTOConfig.INSTANCE.hud.wirelessEnergyHUDEnabled;
    }
}

