/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.forge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00100\u000f\u00a8\u0006\u0012"}, d2={"Lcom/gtocore/client/forge/ThickPolylineRenderer;", "", "<init>", "()V", "drawSegments", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "camera", "Lnet/minecraft/client/Camera;", "colorRGBA", "", "width", "", "segments", "", "Lkotlin/Pair;", "Lnet/minecraft/world/phys/Vec3;", "gtocore"})
final class ThickPolylineRenderer {
    @NotNull
    public static final ThickPolylineRenderer INSTANCE = new ThickPolylineRenderer();

    private ThickPolylineRenderer() {
    }

    public final void drawSegments(@NotNull PoseStack poseStack, @NotNull Camera camera, int colorRGBA, float width, @NotNull List<? extends Pair<? extends Vec3, ? extends Vec3>> segments) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        if (segments.isEmpty()) {
            return;
        }
        float half = width / 2.0f;
        poseStack.m_85836_();
        poseStack.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.disableCull();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (Pair<? extends Vec3, ? extends Vec3> pair : segments) {
            ThickPolylineRenderer.drawSegments$emitSeg(camera, half, buffer, matrix, colorRGBA, (Vec3)pair.getFirst(), (Vec3)pair.getSecond());
        }
        tesselator.m_85914_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        poseStack.m_85849_();
    }

    private static final void drawSegments$emitSeg(Camera $camera, float half, BufferBuilder buffer, Matrix4f matrix, int $colorRGBA, Vec3 aIn, Vec3 bIn) {
        float bx = (float)bIn.f_82479_;
        float ax = (float)aIn.f_82479_;
        float dx = bx - ax;
        float by = (float)bIn.f_82480_;
        float ay = (float)aIn.f_82480_;
        float dy = by - ay;
        float bz = (float)bIn.f_82481_;
        float az = (float)aIn.f_82481_;
        float dz = bz - az;
        float len = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (len < 1.0E-6f) {
            return;
        }
        float ux = dx / len;
        float uy = dy / len;
        float uz = dz / len;
        float mx = (ax + bx) * 0.5f;
        float vx = (float)($camera.m_90583_().f_82479_ - (double)mx);
        float my = (ay + by) * 0.5f;
        float vy = (float)($camera.m_90583_().f_82480_ - (double)my);
        float mz = (az + bz) * 0.5f;
        float vz = (float)($camera.m_90583_().f_82481_ - (double)mz);
        float vlen = (float)Math.sqrt(vx * vx + vy * vy + vz * vz);
        float nvx = vlen > 1.0E-6f ? vx / vlen : 0.0f;
        float nvy = vlen > 1.0E-6f ? vy / vlen : 0.0f;
        float nvz = vlen > 1.0E-6f ? vz / vlen : 0.0f;
        float nx = uy * nvz - uz * nvy;
        float ny = uz * nvx - ux * nvz;
        float nz = ux * nvy - uy * nvx;
        float nlen = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (nlen < 1.0E-6f && (nlen = (float)Math.sqrt((nx = -uz) * nx + (ny = 0.0f) * ny + (nz = ux) * nz)) < 1.0E-6f) {
            return;
        }
        float offx = (nx /= nlen) * half;
        float offy = (ny /= nlen) * half;
        float offz = (nz /= nlen) * half;
        float ex = ux * half;
        float ey = uy * half;
        float ez = uz * half;
        float axEx = ax - ex;
        float ayEy = ay - ey;
        float azEz = az - ez;
        float bxEx = bx + ex;
        float byEy = by + ey;
        float bzEz = bz + ez;
        buffer.m_252986_(matrix, axEx + offx, ayEy + offy, azEz + offz).m_193479_($colorRGBA).m_5752_();
        buffer.m_252986_(matrix, bxEx + offx, byEy + offy, bzEz + offz).m_193479_($colorRGBA).m_5752_();
        buffer.m_252986_(matrix, bxEx - offx, byEy - offy, bzEz - offz).m_193479_($colorRGBA).m_5752_();
        buffer.m_252986_(matrix, axEx - offx, ayEy - offy, azEz - offz).m_193479_($colorRGBA).m_5752_();
    }
}

