/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client;

import appeng.api.client.AEKeyRenderHandler;
import appeng.api.client.AEKeyRendering;
import appeng.api.parts.PartModels;
import appeng.api.stacks.AEKeyType;
import appeng.init.client.InitScreens;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gtocore.client.KeyBind;
import com.gtocore.client.forge.ForgeClientEvent;
import com.gtocore.client.forge.GTOComponentHandler;
import com.gtocore.client.forge.GTOComponentRegistry;
import com.gtocore.client.forge.GTORender;
import com.gtocore.client.hud.AdAstraHUD;
import com.gtocore.client.hud.IMoveableHUD;
import com.gtocore.client.hud.WirelessEnergyHUD;
import com.gtocore.client.renderer.item.MonitorItemDecorations;
import com.gtocore.common.CommonProxy;
import com.gtocore.common.data.GTOFluids;
import com.gtocore.common.forge.ClientForge;
import com.gtocore.common.machine.monitor.MonitorBlockItem;
import com.gtolib.GTOCore;
import com.gtolib.api.ae2.me2in1.Me2in1Menu;
import com.gtolib.api.ae2.me2in1.Me2in1Screen;
import com.gtolib.api.ae2.me2in1.Me2in1TerminalPart;
import com.gtolib.api.ae2.me2in1.Wireless;
import com.gtolib.api.ae2.me2in1.emi.CategoryMappingSubMenu;
import com.gtolib.api.ae2.me2in1.emi.CategoryMappingSubScreen;
import com.gtolib.api.ae2.stacks.TagPrefixKey;
import com.gtolib.api.ae2.stacks.TagPrefixKeyType;
import com.gtolib.api.emi.stack.TagPrefixRenderer;
import com.lowdragmc.shimmer.client.light.ColorPointLight;
import com.lowdragmc.shimmer.client.light.LightManager;
import com.lowdragmc.shimmer.event.ShimmerReloadEvent;
import com.lowdragmc.shimmer.forge.event.ForgeShimmerReloadEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemDecorator;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public final class ClientProxy
extends CommonProxy {
    public ClientProxy() {
        ClientProxy.init();
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(ClientProxy::clientSetup);
        eventBus.addListener(ClientProxy::registerItemDeco);
        eventBus.addListener(ClientProxy::registerGuiOverlays);
        eventBus.addListener(ClientProxy::registerAdditionalModels);
        eventBus.addListener(ClientProxy::registerMenuScreen);
        eventBus.register(GTOComponentRegistry.class);
        MinecraftForge.EVENT_BUS.register(ForgeClientEvent.class);
        MinecraftForge.EVENT_BUS.register(GTOComponentHandler.class);
        MinecraftForge.EVENT_BUS.register(GTORender.class);
        MinecraftForge.EVENT_BUS.register(ClientForge.class);
        ClientProxy.registerAEModels();
        AEKeyRendering.register((AEKeyType)TagPrefixKeyType.TYPE, TagPrefixKey.class, (AEKeyRenderHandler)new TagPrefixRenderer.AEKeyHandler());
        if (GTCEu.Mods.isShimmerLoaded()) {
            eventBus.addListener(ClientProxy::registerLights);
        }
    }

    private static void init() {
        KeyBind.init();
        ClientForge.INSTANCE.getMESSAGE_DEFINITIONS().forEach(ClientForge.MessageDefinition::getContentHash);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)GTOFluids.GELID_CRYOTHEUM.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)GTOFluids.FLOWING_GELID_CRYOTHEUM.get()), (RenderType)RenderType.m_110466_());
    }

    private static void registerLights(ForgeShimmerReloadEvent e) {
        if (e.event.getReloadType() == ShimmerReloadEvent.ReloadType.COLORED_LIGHT) {
            GTOCore.LOGGER.info("registering dynamic lights");
            Int2ObjectOpenHashMap lights = new Int2ObjectOpenHashMap();
            for (Item item : ForgeRegistries.ITEMS) {
                BlockItem blockItem;
                int emission;
                if (!(item instanceof BlockItem) || (emission = (blockItem = (BlockItem)item).m_40614_().m_49966_().m_60791_()) <= 0) continue;
                ColorPointLight.Template light = (ColorPointLight.Template)lights.computeIfAbsent(emission, k -> new ColorPointLight.Template((float)emission, 1.0f, 1.0f, 1.0f, 1.0f));
                LightManager.INSTANCE.registerItemLight(item, itemStack -> light);
            }
        }
    }

    private static void registerItemDeco(RegisterItemDecorationsEvent event) {
        MonitorBlockItem.getItemList().forEach(item -> {
            if (item != null) {
                event.register((ItemLike)BuiltInRegistries.f_256975_.m_7745_(item), (IItemDecorator)MonitorItemDecorations.DECORATOR);
            }
        });
    }

    private static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        IMoveableHUD.registerHUD(event, "wireless_energy_hud", WirelessEnergyHUD.INSTANCE);
        IMoveableHUD.registerHUD(event, "adastra_hud", AdAstraHUD.gto$INSTANCE);
    }

    private static void registerMenuScreen(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            InitScreens.register((MenuType)Me2in1Menu.TYPE, Me2in1Screen::new, (String)"/screens/ex_pattern_access_terminal.json");
            InitScreens.register((MenuType)Wireless.TYPE, Wireless.Screen::new, (String)"/screens/ex_pattern_access_terminal.json");
            InitScreens.register((MenuType)CategoryMappingSubMenu.TYPE, CategoryMappingSubScreen::new, (String)"/screens/categoru_mapping_config.json");
        });
    }

    private static void registerAdditionalModels(ModelEvent.RegisterAdditional evt) {
        for (TagPrefix tagPrefix : TagPrefix.values()) {
            evt.register(GTOCore.id((String)("item/" + tagPrefix.getLowerCaseName())));
        }
    }

    private static void registerAEModels() {
        PartModels.registerModels((Collection)Me2in1TerminalPart.MODELS);
    }
}

