/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.report;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.WeightedMaterial;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gtocore.common.data.GTOMaterials;
import com.gtolib.GTOCore;
import com.gtolib.api.data.Dimension;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class OreReport {
    public static void generateOreReport() {
        try {
            Map<Material, String> materialFieldMap = OreReport.getMaterialStringMap();
            Dimension[] ALL_DIM = new Dimension[]{Dimension.OVERWORLD, Dimension.ANCIENT_WORLD, Dimension.THE_NETHER, Dimension.MOON, Dimension.MARS, Dimension.VENUS, Dimension.MERCURY, Dimension.GLACIO, Dimension.TITAN, Dimension.PLUTO, Dimension.IO, Dimension.GANYMEDE, Dimension.ENCELADUS, Dimension.CERES, Dimension.BARNARDA_C, Dimension.OTHERSIDE};
            Map<ResourceLocation, Map<Material, Double>> normalizedOreWeights = OreReport.calculateNormalizedWeights();
            Map<ResourceLocation, DimensionOreInfo> dimensionOreInfoMap = OreReport.processOreDefinitions(ALL_DIM, normalizedOreWeights);
            OreReport.generateReports(dimensionOreInfoMap, materialFieldMap);
            GTOCore.LOGGER.info("\u77ff\u77f3\u7edf\u8ba1\u62a5\u544a\u5df2\u751f\u6210");
        }
        catch (Exception e) {
            GTOCore.LOGGER.error("\u751f\u6210\u77ff\u77f3\u7edf\u8ba1\u62a5\u544a\u5931\u8d25", (Throwable)e);
        }
    }

    private static Map<ResourceLocation, Map<Material, Double>> calculateNormalizedWeights() {
        HashMap<ResourceLocation, Map<Material, Double>> normalizedOreWeights = new HashMap<ResourceLocation, Map<Material, Double>>();
        for (Map.Entry entry : GTRegistries.BEDROCK_ORE_DEFINITIONS.entries()) {
            ResourceLocation veinId = (ResourceLocation)entry.getKey();
            BedrockOreDefinition bedrockOre = (BedrockOreDefinition)entry.getValue();
            int totalOreWeightInVein = bedrockOre.materials().stream().mapToInt(WeightedMaterial::weight).sum();
            HashMap<Material, Double> weights = new HashMap<Material, Double>();
            for (WeightedMaterial wm : bedrockOre.materials()) {
                double normalizedWeight = (double)wm.weight() / (double)totalOreWeightInVein * 100.0;
                weights.put(wm.material(), normalizedWeight);
            }
            normalizedOreWeights.put(veinId, weights);
        }
        return normalizedOreWeights;
    }

    private static Map<ResourceLocation, DimensionOreInfo> processOreDefinitions(Dimension[] ALL_DIM, Map<ResourceLocation, Map<Material, Double>> normalizedOreWeights) {
        HashMap<ResourceLocation, DimensionOreInfo> dimensionOreInfoMap = new HashMap<ResourceLocation, DimensionOreInfo>();
        for (Map.Entry entry : GTRegistries.BEDROCK_ORE_DEFINITIONS.entries()) {
            ResourceLocation veinId = (ResourceLocation)entry.getKey();
            BedrockOreDefinition bedrockOre = (BedrockOreDefinition)entry.getValue();
            int veinWeight = bedrockOre.weight();
            Map<Material, Double> normalizedWeights = normalizedOreWeights.get(veinId);
            GTOreDefinition oreDefinition = (GTOreDefinition)GTRegistries.ORE_VEINS.get((Object)veinId);
            float density = oreDefinition != null ? oreDefinition.density() : 1.0f;
            for (ResourceKey dimensionKey : bedrockOre.dimensionFilter()) {
                ResourceLocation dimensionId = dimensionKey.m_135782_();
                Dimension dim = Arrays.stream(ALL_DIM).filter(d -> d.getLocation().equals((Object)dimensionId)).findFirst().orElse(null);
                DimensionOreInfo oreInfo = dimensionOreInfoMap.computeIfAbsent(dimensionId, k -> new DimensionOreInfo(dim));
                oreInfo.totalVeinWeight += veinWeight;
                for (WeightedMaterial wm : bedrockOre.materials()) {
                    Material material = wm.material();
                    double oreWeight = normalizedWeights.getOrDefault(material, 0.0);
                    int combinedWeight = (int)(oreWeight * (double)veinWeight * (double)density);
                    oreInfo.totalCombinedWeight += combinedWeight;
                    oreInfo.ores.compute(material, (k, v) -> {
                        if (v == null) {
                            return new OreData(oreWeight, veinWeight, combinedWeight, density);
                        }
                        v.totalOreWeight += oreWeight;
                        v.totalVeinWeight += veinWeight;
                        v.combinedWeight += combinedWeight;
                        return v;
                    });
                }
            }
        }
        return dimensionOreInfoMap;
    }

    private static void generateReports(Map<ResourceLocation, DimensionOreInfo> dimensionOreInfoMap, Map<Material, String> materialFieldMap) {
        try {
            Dimension[] ALL_DIM;
            StringBuilder report = new StringBuilder("\n# ***\u7ef4\u5ea6\u77ff\u77f3\u7edf\u8ba1\u62a5\u544a***");
            StringBuilder report_arrays = new StringBuilder("***\u7ef4\u5ea6\u77ff\u77f3\u7edf\u8ba1\u8f93\u51fa(\u6570\u7ec4\u5f62\u5f0f)***");
            StringBuilder report_table = new StringBuilder("***\u7ef4\u5ea6\u77ff\u77f3\u7edf\u8ba1\u8f93\u51fa(\u8868\u683c\u5f62\u5f0f)***");
            StringBuilder report_meteorite_recipe = new StringBuilder("***\u9668\u661f\u914d\u65b9***");
            StringBuilder report_meteorite_recipea = new StringBuilder("\n\n//Material\u7ec4").append("\nMaterial[][] materials = new Material[][] {");
            StringBuilder report_meteorite_recipeb = new StringBuilder("\n\n//int\u7ec4").append("\nint[][] material_weights = new int[][] {");
            for (Dimension dim : ALL_DIM = new Dimension[]{Dimension.OVERWORLD, Dimension.ANCIENT_WORLD, Dimension.THE_NETHER, Dimension.MOON, Dimension.MARS, Dimension.VENUS, Dimension.MERCURY, Dimension.CERES, Dimension.IO, Dimension.GANYMEDE, Dimension.ENCELADUS, Dimension.TITAN, Dimension.PLUTO, Dimension.GLACIO, Dimension.BARNARDA_C, Dimension.OTHERSIDE}) {
                ResourceLocation dimId = dim.getLocation();
                DimensionOreInfo info = dimensionOreInfoMap.get(dimId);
                if (info == null) {
                    report.append("\n\n## **\u7ef4\u5ea6**: ").append(dim.getEn()).append(" (\u65e0\u77ff\u77f3\u6570\u636e)");
                    continue;
                }
                String dimName = String.format("%s (%s)", dim.getEn(), dim.getCn());
                OreReport.generateMarkdownReport(report, dimId, info, dim, dimName, materialFieldMap);
                OreReport.generateArrayReport(report_arrays, dimId, info, dimName, materialFieldMap);
                OreReport.generateTableReport(report_table, dimId, info, dimName, materialFieldMap);
                OreReport.generateMeteoriteRecipe(report_meteorite_recipea, report_meteorite_recipeb, dimId, info, dimName, materialFieldMap);
            }
            report.append("\n\n****\u62a5\u544a\u7ed3\u675f****");
            report_meteorite_recipe.append((CharSequence)report_meteorite_recipea).append("\n};\n\n");
            report_meteorite_recipe.append((CharSequence)report_meteorite_recipeb).append("\n};\n\n");
            OreReport.writeReportsToFiles(report, report_arrays, report_table, report_meteorite_recipe);
        }
        catch (Exception e) {
            GTOCore.LOGGER.error("\u751f\u6210\u62a5\u544a\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private static void generateMarkdownReport(StringBuilder report, ResourceLocation dimId, DimensionOreInfo info, Dimension dim, String dimName, Map<Material, String> materialFieldMap) {
        report.append("\n\n## **\u7ef4\u5ea6**: ").append(dimName).append("  ");
        report.append("\n**ID**: ").append(dimId).append("  ");
        if (dim != null) {
            report.append("\n**\u5c42\u7ea7**: ").append(dim.getTier()).append("  ");
            report.append("\n**\u661f\u7cfb**: ").append(dim.getGalaxy()).append("  ");
            report.append("\n**\u8f68\u9053**: ").append(dim.getOrbit()).append("  ");
        }
        report.append("\n**\u603b\u77ff\u8109\u6743\u91cd**: ").append(info.totalVeinWeight).append("  ");
        report.append("\n**\u603b\u8054\u5408\u6743\u91cd**: ").append(info.totalCombinedWeight).append("  ");
        report.append("\n\n### **\u77ff\u77f3\u5217\u8868**:  ");
        report.append("\n|\u5e8f\u53f7|\u77ff\u77f3\u540d\u79f0|  |\u77ff\u77f3\u6743\u91cd|\u77ff\u8109\u6743\u91cd|\u77ff\u8109\u5bc6\u5ea6|\u8054\u5408\u6743\u91cd|");
        report.append("\n|-----|----------|--------------------|------|------|------|------|");
        AtomicInteger index = new AtomicInteger(1);
        info.ores.entrySet().stream().sorted((e1, e2) -> Integer.compare(((OreData)e2.getValue()).combinedWeight, ((OreData)e1.getValue()).combinedWeight)).forEach(e -> {
            Material material = (Material)e.getKey();
            OreData data = (OreData)e.getValue();
            int currentIndex = index.getAndIncrement();
            String fieldName = materialFieldMap.getOrDefault(material, material.getName());
            report.append(String.format("\n| %d | %s | %s | %s | %d | %s | %d |", currentIndex, I18n.m_118938_((String)material.getUnlocalizedName(), (Object[])new Object[0]), fieldName, String.format("%.1f", data.totalOreWeight), data.totalVeinWeight, String.format("%.0f%%", Float.valueOf(data.density * 100.0f)), data.combinedWeight));
        });
    }

    private static void generateArrayReport(StringBuilder report_arrays, ResourceLocation dimId, DimensionOreInfo info, String dimName, Map<Material, String> materialFieldMap) {
        Object2IntOpenHashMap oreMap = new Object2IntOpenHashMap();
        info.ores.forEach((arg_0, arg_1) -> OreReport.lambda$generateArrayReport$5((Object2IntMap)oreMap, arg_0, arg_1));
        report_arrays.append("\n\n\u7ef4\u5ea6: ").append(dimName);
        report_arrays.append("\nID: ").append(dimId);
        ArrayList<String> materialNames = new ArrayList<String>();
        ArrayList<Integer> weights = new ArrayList<Integer>();
        ArrayList<String> localizationKeys = new ArrayList<String>();
        for (Object2IntMap.Entry entry2 : oreMap.object2IntEntrySet()) {
            Material material = (Material)entry2.getKey();
            materialNames.add(materialFieldMap.getOrDefault(material, material.getName()));
            weights.add(entry2.getIntValue());
            localizationKeys.add(I18n.m_118938_((String)material.getUnlocalizedName(), (Object[])new Object[0]));
        }
        String materialNamesStr = materialNames.stream().collect(Collectors.joining(", ", "new Material[] { ", " }"));
        String weightsStr = weights.stream().map(Object::toString).collect(Collectors.joining(", ", "new int[] { ", " }"));
        String localizationKeysStr = localizationKeys.stream().collect(Collectors.joining(", ", "{ ", " }"));
        report_arrays.append("\n\u6750\u6599\u540d\u79f0\u6570\u7ec4: \n").append(materialNamesStr);
        report_arrays.append("\n\u6743\u91cd\u6570\u7ec4: \n").append(weightsStr);
        report_arrays.append("\n\u672c\u5730\u5316\u952e\u6570\u7ec4: \n").append(localizationKeysStr);
    }

    private static void generateTableReport(StringBuilder report_table, ResourceLocation dimId, DimensionOreInfo info, String dimName, Map<Material, String> materialFieldMap) {
        Object2IntOpenHashMap oreMap = new Object2IntOpenHashMap();
        info.ores.forEach((arg_0, arg_1) -> OreReport.lambda$generateTableReport$6((Object2IntMap)oreMap, arg_0, arg_1));
        report_table.append("\n\n\u7ef4\u5ea6: ").append(dimName);
        report_table.append("\nID: ").append(dimId);
        report_table.append("\n\u6750\u6599\u540d\u79f0,\u6743\u91cd,\u672c\u5730\u5316\u952e\n");
        for (Object2IntMap.Entry entry3 : oreMap.object2IntEntrySet()) {
            Material material = (Material)entry3.getKey();
            String fieldName = materialFieldMap.getOrDefault(material, material.getName());
            report_table.append(String.format("%s,%d,%s\n", fieldName, entry3.getIntValue(), I18n.m_118938_((String)material.getUnlocalizedName(), (Object[])new Object[0])));
        }
    }

    private static void generateMeteoriteRecipe(StringBuilder report_meteorite_recipea, StringBuilder report_meteorite_recipeb, ResourceLocation dimId, DimensionOreInfo info, String dimName, Map<Material, String> materialFieldMap) {
        String fieldName;
        Material material;
        Object2IntOpenHashMap oreMap = new Object2IntOpenHashMap();
        info.ores.forEach((arg_0, arg_1) -> OreReport.lambda$generateMeteoriteRecipe$7((Object2IntMap)oreMap, arg_0, arg_1));
        ArrayList weightValues = new ArrayList(oreMap.values());
        Collections.sort(weightValues);
        int medianWeight = (Integer)weightValues.get(weightValues.size() / 2);
        Object2IntOpenHashMap lowWeightOres = new Object2IntOpenHashMap();
        for (Object2IntMap.Entry entry : oreMap.object2IntEntrySet()) {
            if (entry.getIntValue() >= medianWeight) continue;
            lowWeightOres.put((Object)((Material)entry.getKey()), entry.getIntValue());
        }
        ArrayList<String> allMaterialNames = new ArrayList<String>();
        ArrayList<Integer> allWeights = new ArrayList<Integer>();
        ArrayList<String> lowWeightMaterialNames = new ArrayList<String>();
        ArrayList<Integer> lowWeights = new ArrayList<Integer>();
        for (Object2IntMap.Entry entry : oreMap.object2IntEntrySet()) {
            material = (Material)entry.getKey();
            fieldName = materialFieldMap.getOrDefault(material, material.getName());
            allMaterialNames.add(fieldName);
            allWeights.add(entry.getIntValue());
        }
        for (Object2IntMap.Entry entry : lowWeightOres.object2IntEntrySet()) {
            material = (Material)entry.getKey();
            fieldName = materialFieldMap.getOrDefault(material, material.getName());
            lowWeightMaterialNames.add(fieldName);
            lowWeights.add(entry.getIntValue());
        }
        report_meteorite_recipea.append("\n// \u7ef4\u5ea6: ").append(dimName).append("--ID: ").append(dimId);
        report_meteorite_recipeb.append("\n// \u7ef4\u5ea6: ").append(dimName).append("--ID: ").append(dimId);
        report_meteorite_recipea.append("\nnew Material[] { ").append(String.join((CharSequence)", ", allMaterialNames)).append(" },");
        report_meteorite_recipeb.append("\nnew int[] { ").append(allWeights.stream().map(Object::toString).collect(Collectors.joining(", "))).append(" },");
        report_meteorite_recipea.append("\nnew Material[] { ").append(String.join((CharSequence)", ", lowWeightMaterialNames)).append(" },");
        report_meteorite_recipeb.append("\nnew int[] { ").append(lowWeights.stream().map(Object::toString).collect(Collectors.joining(", "))).append(" },");
    }

    private static void writeReportsToFiles(StringBuilder report, StringBuilder report_arrays, StringBuilder report_table, StringBuilder report_meteorite_recipe) {
        try {
            Path logDir = Paths.get("logs", "report");
            if (!Files.exists(logDir, new LinkOption[0])) {
                Files.createDirectories(logDir, new FileAttribute[0]);
            }
            String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            Path reportPath = logDir.resolve("ore_report_" + timestamp + ".md");
            Path reportPath_arrays = logDir.resolve("ore_report_arrays_" + timestamp + ".txt");
            Path reportPath_table = logDir.resolve("ore_report_table_" + timestamp + ".csv");
            Path reportPath_meteorite_recipe = logDir.resolve("ore_report_meteorite_recipe_" + timestamp + ".txt");
            try (BufferedWriter writer = Files.newBufferedWriter(reportPath, new OpenOption[0]);){
                writer.write(report.toString());
            }
            writer = Files.newBufferedWriter(reportPath_arrays, new OpenOption[0]);
            try {
                writer.write(report_arrays.toString());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            writer = Files.newBufferedWriter(reportPath_table, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            try {
                writer.write(65279);
                writer.write(report_table.toString());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            writer = Files.newBufferedWriter(reportPath_meteorite_recipe, new OpenOption[0]);
            try {
                writer.write(report_meteorite_recipe.toString());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (Exception e) {
            GTOCore.LOGGER.error("\u5199\u5165\u62a5\u544a\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private static Map<Material, String> getMaterialStringMap() {
        Material material2;
        HashMap<Material, String> materialFieldMap = new HashMap<Material, String>();
        for (Field field : GTOMaterials.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Material.class.isAssignableFrom(field.getType())) continue;
            try {
                material2 = (Material)field.get(null);
                if (material2 == null) continue;
                materialFieldMap.put(material2, "GTOMaterials." + field.getName());
            }
            catch (IllegalAccessException material2) {
                // empty catch block
            }
        }
        for (Field field : GTMaterials.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Material.class.isAssignableFrom(field.getType())) continue;
            try {
                material2 = (Material)field.get(null);
                if (material2 == null || materialFieldMap.containsKey(material2)) continue;
                materialFieldMap.put(material2, "GTMaterials." + field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return materialFieldMap;
    }

    private static /* synthetic */ void lambda$generateMeteoriteRecipe$7(Object2IntMap oreMap, Material material, OreData oreData) {
        oreMap.put((Object)material, oreData.combinedWeight);
    }

    private static /* synthetic */ void lambda$generateTableReport$6(Object2IntMap oreMap, Material material, OreData oreData) {
        oreMap.put((Object)material, oreData.combinedWeight);
    }

    private static /* synthetic */ void lambda$generateArrayReport$5(Object2IntMap oreMap, Material material, OreData oreData) {
        oreMap.put((Object)material, oreData.combinedWeight);
    }

    private static class DimensionOreInfo {
        final Dimension dimension;
        int totalVeinWeight = 0;
        int totalCombinedWeight = 0;
        Map<Material, OreData> ores = new HashMap<Material, OreData>();

        DimensionOreInfo(Dimension dimension) {
            this.dimension = dimension;
        }
    }

    private static class OreData {
        double totalOreWeight;
        int totalVeinWeight;
        int combinedWeight;
        float density;

        OreData(double oreWeight, int veinWeight, int combined, float density) {
            this.totalOreWeight = oreWeight;
            this.totalVeinWeight = veinWeight;
            this.combinedWeight = combined;
            this.density = density;
        }
    }
}

