/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.gui.configurators;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public abstract class CustomModeFancyConfigurator
implements IFancyUIProvider {
    private final int modeSize;

    CustomModeFancyConfigurator(int modeSize) {
        this.modeSize = modeSize;
    }

    public abstract void setMode(int var1);

    public abstract int getCurrentMode();

    public abstract String getLanguageKey(int var1);

    public Component getTitle() {
        return Component.m_237115_((String)"gtceu.gui.machinemode.title");
    }

    public IGuiTexture getTabIcon() {
        return new ItemStackTexture(new Item[]{(Item)GTItems.ROBOT_ARM_LV.get()});
    }

    public Widget createMainPage(FancyMachineUIWidget widget2) {
        MachineModeConfigurator group = new MachineModeConfigurator(0, 0, 140, 20 * this.modeSize + 4);
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        for (int i = 0; i < this.modeSize; ++i) {
            int finalI = i;
            group.addWidget((Widget)new ButtonWidget(2, 2 + i * 20, 136, 20, IGuiTexture.EMPTY, cd -> this.setMode(finalI)));
            group.addWidget((Widget)new ImageWidget(2, 2 + i * 20, 136, 20, () -> new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON.copy().setColor(this.getCurrentMode() == finalI ? ColorPattern.CYAN.color : -1), new TextTexture(this.getLanguageKey(finalI)).setWidth(136).setType(TextTexture.TextType.ROLL)})));
        }
        return group;
    }

    public List<Component> getTabTooltips() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.m_237115_((String)"gtceu.gui.machinemode.tab_tooltip"));
        return tooltip;
    }

    private class MachineModeConfigurator
    extends WidgetGroup {
        private MachineModeConfigurator(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public void writeInitialData(FriendlyByteBuf buffer) {
            buffer.m_130130_(CustomModeFancyConfigurator.this.getCurrentMode());
        }

        public void readInitialData(FriendlyByteBuf buffer) {
            CustomModeFancyConfigurator.this.setMode(buffer.m_130242_());
        }

        public void detectAndSendChanges() {
            this.writeUpdateInfo(0, buf -> buf.m_130130_(CustomModeFancyConfigurator.this.getCurrentMode()));
        }

        public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
            if (id == 0) {
                CustomModeFancyConfigurator.this.setMode(buffer.m_130242_());
            }
        }
    }
}

