---
order: 93
title: 国际化
group:
  title: 高级使用
nav:
  title: 文档
  path: /docs
  order: 1
---

### 开始使用

pro 通过 umi 插件 [@umijs/plugin-locale](https://github.com/umijs/@umijs/plugin-locale) 来实现全球化的功能，并且默认开启。 `@umijs/plugin-locale` 约定 在 src/locales 中引入 相应的 js，例如 en-US.ts 和 zh-CN.ts，并且在 `config/config.ts` 中做如下配置：

```tsx | pure
plugins:[
...,
locale: {
  enable: true,
  default: 'zh-CN',
  baseNavigator: true,
},
...,
]
```

就可以在代码中使用全球化的功能了。详细配置参见[config](https://umijs.org/zh-CN/plugins/plugin-locale)。

`@umijs/plugin-locale` 封装了[react-intl](https://github.com/yahoo/react-intl), api 与 `react-intl` 基本相同，并做了封装使用起来更加方便。全部 api 如下：

```tsx | pure
import { setLocale, getLocale, FormattedMessage } from 'umi';
```

### 格式化字符串

如果我们在 `en-US.ts` 和 `zh-CN.ts` 中分别作了如下配置：

```tsx | pure
// zh-CN.ts

export default {
  'navbar.lang': '中文',
};

// en-US.ts

export default {
  'navbar.lang': 'English',
};
```

我们就可以在组件中这样使用

```tsx | pure
import { FormattedMessage } from 'umi';

export default () => {
  return (
    <div>
      <FormattedMessage id="navbar.lang" />
    </div>
  );
};
```

### 设置区域

`@umijs/plugin-locale` 暴露了名为 `setLocale` 和 `getLocale` 的 api，通过这两个 api 可以方便的切换区域。代码看起来像这样的：

```tsx | pure
class SelectLang extends React.Component {
  changLang = () => {
    const locale = getLocale();
    if (!locale || locale === 'zh-CN') {
      setLocale('en-US');
    } else {
      setLocale('zh-CN');
    }
  };
  render() {
    <Button
      size="small"
      ghost={theme === 'dark'}
      style={{
        margin: '0 8px',
      }}
      onClick={() => {
        this.changLang();
      }}
    >
      <FormattedMessage id="navbar.lang" />
    </Button>;
  }
}
```

更多高级的用法可以参照 [plugin-locale](https://umijs.org/zh-CN/plugins/plugin-locale)。

### 删除全球化

如果你想删除 pro 自带的全球化，可以通过 `npm run i18n-remove`,`i18n-remove`还比较基础只是测试了 pro 自带的代码，如果你使用了高级的特性，你可能需要自己人工去进行修改。例如 `formatMessage({id:somevar})` 这种动态的代码我们可能无法帮您分析并删除。

如果你有好办法可以实现 欢迎 [pr](https://github.com/ant-design/ant-design-pro-cli)。
