---
order: 7
title: 前端最佳实践即将发布
group:
  title: Blog
  path: /
nav:
  title: Blog
  path: /blog
  order: 3
time: 2020-02-29
---

随着前端的的发展，底座已经越来越坚实，当前前端框架和工程化已经可以 cover 住大部分业务场景的复杂度。前端的已经更加关注于业务，Ant Design Pro 提供了一个中后台的脚手架，为框架和工程化提供了最佳实践，但是还是有很多问题还是需要最佳实践。

## 🤷‍♂️ 为什么需要最佳实践

在维护 Pro 的过程中，我们遇到了很多直击灵魂的问题，什么样的代码才是最好的？应该怎么写才对？初始化用户信息在哪里请求？有的页面只有部分用户有权限该怎么处理？Layout 代码太复杂看不懂？后端接口报错应该怎么处理？

这类型的问题回答说难不难，说简单也不能算简单。不同的项目乃至不同的人都有自己的习惯，市面上存在很多的解决方案，每个项目中解决方案不尽相同，同样的脚手架我们可以选择 Mobx，redux，dva，使用  Context 的人也不在少数。这已经是选择相对比较少的数据层，我们还有网络请求，权限，Layout 等。

诚然，多个选择是好事，但是作为企业级的产品，维护才是最重要的，我们期望每个同学都可以很快的上手，而且如果每个项目都要选一次，新鲜感过去之后我们可能就会自己花费相当多的精力来封装。更加详细的论证，可以看云谦老师的[文章](https://zhuanlan.zhihu.com/p/94949118?from_voters_page=true)。

## 🏄‍♂️ 我们的解决方案

蚂蚁金服每年都有大量的中后台项目的孵化，各种技术栈百花齐放，我们解决方案其实就是  **强约束**、**配置化**和**约定化**。

### 🕹 强约束

这方面我们做了 ProLayout ，ProTable 两个模板组件，用于封装重复的逻辑，以后可能还会添加 ProForm 等组件来提升开发项目。

- ProLayout 会提供一个标准化的布局组件，我们只需要通过插件就可以引入。
- ProTable 封装了 Table 的常用行为，可以快速的撸出来一个美观的 CRUD 界面。

🔩 配置化

在 umi@3 中这些插件我们都将会官方提供。

- Layout
- 权限
- 国际化
- 微服务
- 主题切换，
- 极简数据流
- ....

等插件通过配置来进行使用，可以方便的关闭和开启。umi@3 的插件体系可以让我们用最低的成本来实现这些功能，一些插件我们官方会整合进官方的预设中，一起打包提供出来。

### 🧬 约定化

约定优于配置的优势自然不用多说，Spring Boot 的成功让其思想大行其道，其简化配置的优势让无数程序员脱离了繁杂的配置之苦。

在最佳实践中，我们也将践行这一思想，`mock`，`models`，`pages`，`services`，`locales`  每个文件夹都进行了约定，用于表示相关的功能，这样可以大大的减少学习成本和配置，让上手成本变得非常之低。我们不需要知其所以然，只需要知道这样就可以跑起来，专注于业务的发展。

## 🛒 其他的方案

- 代码风格与 lint： [fabric](https://github.com/umijs/fabric/)
- 组件开发： [father](https://github.com/umijs/father)
- 文档站：[dumi](https://github.com/umijs/dumi)
- 前端微服务：[乾坤](https://github.com/umijs/qiankun)
