package com.meethere.SystemFunctionalTesting;// Generated by Selenium IDE
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.IsNot.not;

import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.openqa.selenium.By;
import org.springframework.core.annotation.Order;

@TestMethodOrder(MethodOrderer.Alphanumeric.class)
public class SignUpTest extends BaseTest {


  @Test
  @Order(1)
  public void signUp_success() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("注册")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.findElement(By.id("userName")).click();
    driver.findElement(By.id("userName")).sendKeys("testUser");
    driver.findElement(By.id("userID")).click();
    driver.findElement(By.id("userID")).sendKeys("test001");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("1234");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    driver.close();
  }


  @Test
  @Order(2)
  public void signUp_success_with_email() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("注册")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.findElement(By.id("userName")).click();
    driver.findElement(By.id("userName")).sendKeys("testUser");
    driver.findElement(By.id("email")).click();
    driver.findElement(By.id("email")).sendKeys("707864430@qq.com");
    driver.findElement(By.id("userID")).click();
    driver.findElement(By.id("userID")).sendKeys("test002");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("1234");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    driver.close();
  }


  @Test
  @Order(3)
  public void signUp_success_with_phone() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("注册")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.findElement(By.id("userName")).click();
    driver.findElement(By.id("userName")).sendKeys("testUser");
    driver.findElement(By.id("phone")).click();
    driver.findElement(By.id("phone")).sendKeys("13918826786");
    driver.findElement(By.id("userID")).click();
    driver.findElement(By.id("userID")).sendKeys("test003");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("1234");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    driver.close();
  }


  @Test
  @Order(4)
  public void signUp_success_with_email_and_phone() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("注册")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.findElement(By.id("userName")).click();
    driver.findElement(By.id("userName")).sendKeys("testUser");
    driver.findElement(By.id("email")).click();
    driver.findElement(By.id("email")).sendKeys("707864430@qq.com");
    driver.findElement(By.id("phone")).click();
    driver.findElement(By.id("phone")).sendKeys("13918826786");
    driver.findElement(By.id("userID")).click();
    driver.findElement(By.id("userID")).sendKeys("test004");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("1234");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    driver.close();
  }


  @Test
  @Order(5)
  public void signUp_fail_userId_exist() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("注册")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.findElement(By.id("userName")).click();
    driver.findElement(By.id("userName")).sendKeys("testUser");
    driver.findElement(By.id("userID")).click();
    driver.findElement(By.id("userID")).sendKeys("admin");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("admin");
    assertThat(driver.findElement(By.id("alertId")).getText(), is("用户名已被占用，请重新输入！"));
    driver.close();
  }


  @Test
  @Order(6)
  public void signUp_fail_userId_is_null() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("注册")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.findElement(By.id("userName")).click();
    driver.findElement(By.id("userName")).sendKeys("testUser");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("1234");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.close();
  }


  @Test
  @Order(7)
  public void signUp_fail_userName_is_null() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("注册")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.findElement(By.id("userID")).click();
    driver.findElement(By.id("userID")).sendKeys("test001");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("1234");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.close();
  }


  @Test
  @Order(8)
  public void signUp_fail_password_is_null() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("注册")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.findElement(By.id("userName")).click();
    driver.findElement(By.id("userName")).sendKeys("testUser");
    driver.findElement(By.id("userID")).click();
    driver.findElement(By.id("userID")).sendKeys("test001");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.close();
  }


  @Test
  @Order(9)
  public void signUp_fail_email_form_error() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("注册")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.findElement(By.id("userName")).click();
    driver.findElement(By.id("userName")).sendKeys("testUser");
    driver.findElement(By.id("email")).click();
    driver.findElement(By.id("email")).sendKeys("707864430");
    driver.findElement(By.id("userID")).click();
    driver.findElement(By.id("userID")).sendKeys("test001");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("1234");
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    assertThat(driver.findElement(By.id("alertEmail")).getText(), is("请输入正确的邮箱！"));
    driver.close();
  }


  @Test
  @Order(10)
  public void signUp_fail_phone_form_error() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("注册")).click();
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    driver.findElement(By.id("userName")).click();
    driver.findElement(By.id("userName")).sendKeys("testUser");
    driver.findElement(By.id("phone")).click();
    driver.findElement(By.id("phone")).sendKeys("707864430");
    driver.findElement(By.id("userID")).click();
    driver.findElement(By.id("userID")).sendKeys("test001");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("1234");
    assertThat(driver.getTitle(), is("注册-MeetHere"));
    assertThat(driver.findElement(By.id("alertPhone")).getText(), is("请输入正确的手机号！"));
    driver.close();
  }

}
