/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.ldap;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiLdapContextFactory
implements LdapContextFactory {
    protected static final String SUN_CONNECTION_POOLING_PROPERTY = "com.sun.jndi.ldap.connect.pool";
    protected static final String DEFAULT_CONTEXT_FACTORY_CLASS_NAME = "com.sun.jndi.ldap.LdapCtxFactory";
    protected static final String SIMPLE_AUTHENTICATION_MECHANISM_NAME = "simple";
    protected static final String DEFAULT_REFERRAL = "follow";
    private static final Logger log = LoggerFactory.getLogger(JndiLdapContextFactory.class);
    private Map<String, Object> environment = new HashMap<String, Object>();
    private boolean poolingEnabled;
    private String systemPassword;
    private String systemUsername;

    public JndiLdapContextFactory() {
        this.setContextFactoryClassName(DEFAULT_CONTEXT_FACTORY_CLASS_NAME);
        this.setReferral(DEFAULT_REFERRAL);
        this.poolingEnabled = true;
    }

    public void setAuthenticationMechanism(String authenticationMechanism) {
        this.setEnvironmentProperty("java.naming.security.authentication", authenticationMechanism);
    }

    public String getAuthenticationMechanism() {
        return (String)this.getEnvironmentProperty("java.naming.security.authentication");
    }

    public void setContextFactoryClassName(String contextFactoryClassName) {
        this.setEnvironmentProperty("java.naming.factory.initial", contextFactoryClassName);
    }

    public String getContextFactoryClassName() {
        return (String)this.getEnvironmentProperty("java.naming.factory.initial");
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map env) {
        this.environment = env;
    }

    private Object getEnvironmentProperty(String name) {
        return this.environment.get(name);
    }

    private void setEnvironmentProperty(String name, String value) {
        if (StringUtils.hasText(value)) {
            this.environment.put(name, value);
        } else {
            this.environment.remove(name);
        }
    }

    public boolean isPoolingEnabled() {
        return this.poolingEnabled;
    }

    public void setPoolingEnabled(boolean poolingEnabled) {
        this.poolingEnabled = poolingEnabled;
    }

    public void setReferral(String referral) {
        this.setEnvironmentProperty("java.naming.referral", referral);
    }

    public String getReferral() {
        return (String)this.getEnvironmentProperty("java.naming.referral");
    }

    public void setUrl(String url) {
        this.setEnvironmentProperty("java.naming.provider.url", url);
    }

    public String getUrl() {
        return (String)this.getEnvironmentProperty("java.naming.provider.url");
    }

    public void setSystemPassword(String systemPassword) {
        this.systemPassword = systemPassword;
    }

    public String getSystemPassword() {
        return this.systemPassword;
    }

    public void setSystemUsername(String systemUsername) {
        this.systemUsername = systemUsername;
    }

    public String getSystemUsername() {
        return this.systemUsername;
    }

    @Override
    public LdapContext getSystemLdapContext() throws NamingException {
        return this.getLdapContext((Object)this.getSystemUsername(), (Object)this.getSystemPassword());
    }

    @Override
    @Deprecated
    public LdapContext getLdapContext(String username, String password) throws NamingException {
        return this.getLdapContext((Object)username, (Object)password);
    }

    protected boolean isPoolingConnections(Object principal) {
        return this.isPoolingEnabled() && principal != null && principal.equals(this.getSystemUsername());
    }

    @Override
    public LdapContext getLdapContext(Object principal, Object credentials) throws NamingException, IllegalStateException {
        boolean pooling;
        String url = this.getUrl();
        if (url == null) {
            throw new IllegalStateException("An LDAP URL must be specified of the form ldap://<hostname>:<port>");
        }
        Hashtable<String, Object> env = new Hashtable<String, Object>(this.environment);
        String authcMech = this.getAuthenticationMechanism();
        if (authcMech == null && (principal != null || credentials != null)) {
            env.put("java.naming.security.authentication", SIMPLE_AUTHENTICATION_MECHANISM_NAME);
        }
        if (principal != null) {
            env.put("java.naming.security.principal", principal);
        }
        if (credentials != null) {
            env.put("java.naming.security.credentials", credentials);
        }
        if (pooling = this.isPoolingConnections(principal)) {
            env.put(SUN_CONNECTION_POOLING_PROPERTY, "true");
        }
        if (log.isDebugEnabled()) {
            log.debug("Initializing LDAP context using URL [{}] and principal [{}] with pooling {}", url, principal, pooling ? "enabled" : "disabled");
        }
        this.validateAuthenticationInfo(env);
        return this.createLdapContext(env);
    }

    protected LdapContext createLdapContext(Hashtable env) throws NamingException {
        return new InitialLdapContext(env, null);
    }

    protected void validateAuthenticationInfo(Hashtable<String, Object> environment2) throws AuthenticationException {
        Object credentials;
        if (SIMPLE_AUTHENTICATION_MECHANISM_NAME.equals(environment2.get("java.naming.security.authentication")) && environment2.get("java.naming.security.principal") != null && StringUtils.hasText(String.valueOf(environment2.get("java.naming.security.principal"))) && ((credentials = environment2.get("java.naming.security.credentials")) == null || credentials instanceof byte[] && ((byte[])credentials).length <= 0 || credentials instanceof char[] && ((char[])credentials).length <= 0 || String.class.isInstance(credentials) && !StringUtils.hasText(String.valueOf(credentials)))) {
            throw new AuthenticationException("LDAP Simple authentication requires both a principal and credentials.");
        }
    }
}

