/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.time;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;

public class Instants {
    public static long toEpochNanos(Instant instant) {
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }

    public static Duration subtract(Instant minuend, Instant subtrahend) {
        Objects.requireNonNull(minuend);
        Objects.requireNonNull(subtrahend);
        if (minuend.equals(subtrahend)) {
            return Duration.ZERO;
        }
        return Duration.ofSeconds(minuend.getEpochSecond() - subtrahend.getEpochSecond(), minuend.getNano() - subtrahend.getNano());
    }

    public static LocalDateTime toLocalDateTime(Instant instant, ZoneId zoneId) {
        Objects.requireNonNull(instant);
        Objects.requireNonNull(zoneId);
        return ZonedDateTime.ofInstant(instant, zoneId).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(Instant instant) {
        return Instants.toLocalDateTime(instant, ZoneId.systemDefault());
    }
}

