/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.sequence;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.dongliu.commons.collection.Iterators;
import net.dongliu.commons.collection.Lists;
import net.dongliu.commons.collection.Maps;
import net.dongliu.commons.collection.Pair;
import net.dongliu.commons.collection.PartitionResult;
import net.dongliu.commons.collection.Sets;
import net.dongliu.commons.sequence.AggregatedSequence;
import net.dongliu.commons.sequence.ArraySequence;
import net.dongliu.commons.sequence.ChunkedSequence;
import net.dongliu.commons.sequence.CollectConsumer;
import net.dongliu.commons.sequence.DropWhileSequence;
import net.dongliu.commons.sequence.EmptySequence;
import net.dongliu.commons.sequence.FilterSequence;
import net.dongliu.commons.sequence.IndexGeneratedSequence;
import net.dongliu.commons.sequence.IteratorSequence;
import net.dongliu.commons.sequence.MappedSequence;
import net.dongliu.commons.sequence.PeekSequence;
import net.dongliu.commons.sequence.ProgressiveGeneratedSequence;
import net.dongliu.commons.sequence.RandomAccessSequence;
import net.dongliu.commons.sequence.SingletonSequence;
import net.dongliu.commons.sequence.SliceSequence;
import net.dongliu.commons.sequence.SortedSequence;
import net.dongliu.commons.sequence.SupplierGeneratedSequence;
import net.dongliu.commons.sequence.TakeWhileSequence;
import net.dongliu.commons.sequence.Utils;
import net.dongliu.commons.sequence.ZippedSequence;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface Sequence<T>
extends Iterator<T> {
    @Override
    public boolean hasNext();

    @Override
    public T next();

    @Override
    @Deprecated
    default public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public static <S, T> Sequence<Pair<S, T>> zip(Sequence<@NonNull S> s1, Sequence<@NonNull T> s2) {
        return new ZippedSequence<S, T>(s1, s2);
    }

    public static <T> Sequence<T> of(Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        if (!iterator.hasNext()) {
            return Sequence.of();
        }
        return new IteratorSequence<T>(iterator);
    }

    public static <T> Sequence<T> of(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        return Sequence.of(iterable.iterator());
    }

    public static <T> Sequence<T> of(Collection<T> collection) {
        Objects.requireNonNull(collection);
        if (collection.isEmpty()) {
            return Sequence.of();
        }
        if (collection instanceof List && collection instanceof RandomAccess) {
            return new RandomAccessSequence((List)collection);
        }
        return Sequence.of(collection.iterator());
    }

    public static <T> Sequence<T> of(Stream<T> stream) {
        return Sequence.of(stream.iterator());
    }

    public static <T> Sequence<T> of() {
        return EmptySequence.instance;
    }

    public static <T> Sequence<T> of(T value) {
        return new SingletonSequence<T>(value);
    }

    @SafeVarargs
    public static <T> Sequence<T> of(T ... values) {
        return new ArraySequence<T>(values);
    }

    public static <T> Sequence<T> of(Optional<T> optional) {
        if (optional.isPresent()) {
            return new SingletonSequence<T>(optional.get());
        }
        return Sequence.of();
    }

    public static <T> Sequence<T> generate(Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        return new SupplierGeneratedSequence<T>(supplier);
    }

    public static <T> Sequence<T> generate(LongFunction<T> generator) {
        Objects.requireNonNull(generator);
        return new IndexGeneratedSequence<T>(generator);
    }

    public static <T> Sequence<T> generate(Supplier<T> initial, UnaryOperator<T> generator) {
        Objects.requireNonNull(initial);
        Objects.requireNonNull(generator);
        return new ProgressiveGeneratedSequence<T>(initial, generator);
    }

    default public Sequence<T> concat(Sequence<T> sequence) {
        Objects.requireNonNull(sequence);
        if (!sequence.hasNext()) {
            return this;
        }
        if (!this.hasNext()) {
            return sequence;
        }
        return new AggregatedSequence(Sequence.of(this, sequence));
    }

    default public Sequence<T> concat(Collection<? extends Sequence<T>> sequences) {
        Objects.requireNonNull(sequences);
        if (sequences.isEmpty()) {
            return this;
        }
        if (!this.hasNext()) {
            return new AggregatedSequence(sequences.iterator());
        }
        ArrayList<Sequence<T>> list = new ArrayList<Sequence<T>>(sequences.size() + 1);
        list.add(this);
        list.addAll(sequences);
        return new AggregatedSequence(list.iterator());
    }

    default public <R> Sequence<R> map(Function<? super T, ? extends R> mapper) {
        if (!this.hasNext()) {
            return Sequence.of();
        }
        return new MappedSequence<T, R>(this, Objects.requireNonNull(mapper));
    }

    default public Sequence<T> filter(Predicate<? super T> filter) {
        if (!this.hasNext()) {
            return Sequence.of();
        }
        return new FilterSequence<T>(this, Objects.requireNonNull(filter));
    }

    default public Sequence<T> filterOrConsume(Predicate<? super T> filter, Consumer<T> consumer) {
        Objects.requireNonNull(filter);
        Objects.requireNonNull(consumer);
        if (!this.hasNext()) {
            return Sequence.of();
        }
        return new FilterSequence<Object>(this, e -> {
            boolean flag = filter.test(e);
            if (!flag) {
                consumer.accept(e);
            }
            return flag;
        });
    }

    default public <R> Sequence<R> flatMap(Function<? super T, ? extends Sequence<R>> mapper) {
        if (!this.hasNext()) {
            return Sequence.of();
        }
        Sequence<? extends Sequence<R>> sequences = this.map(mapper);
        return new AggregatedSequence(sequences);
    }

    default public <E> Sequence<T> distinctBy(Function<? super T, E> keyMapper) {
        Objects.requireNonNull(keyMapper);
        if (!this.hasNext()) {
            return Sequence.of();
        }
        HashSet set = new HashSet();
        return new FilterSequence<Object>(this, v -> set.add(keyMapper.apply(v)));
    }

    default public Sequence<T> distinct() {
        return this.distinctBy(Function.identity());
    }

    default public Sequence<T> filterNonNull() {
        return this.filter(Objects::nonNull);
    }

    default public Sequence<T> drop(long size) {
        Utils.checkCount(size);
        if (size == 0L) {
            return this;
        }
        return new SliceSequence(this, size, Long.MAX_VALUE);
    }

    default public Sequence<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return new DropWhileSequence<T>(this, predicate);
    }

    default public Sequence<T> take(long size) {
        Utils.checkCount(size);
        if (size == 0L) {
            return Sequence.of();
        }
        return new SliceSequence(this, 0L, size);
    }

    default public Sequence<T> takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return new TakeWhileSequence<T>(this, predicate);
    }

    default public Optional<T> at(long seq) {
        long index = 0L;
        while (this.hasNext()) {
            T value = this.next();
            if (index++ != seq) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    default public Sequence<List<T>> chunked(int size) {
        Utils.checkSize(size);
        if (!this.hasNext()) {
            return Sequence.of();
        }
        return new ChunkedSequence(this, size);
    }

    default public Sequence<T> sortedBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return new SortedSequence<T>(this, comparator);
    }

    default public Sequence<T> sorted() {
        return this.sortedBy(Comparator.naturalOrder());
    }

    default public void forEach(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer);
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }

    default public Sequence<T> peek(Consumer<? super T> consumer) {
        return new PeekSequence<T>(this, Objects.requireNonNull(consumer));
    }

    default public <R> R reduce(R initialValue, BiFunction<? super R, ? super T, ? extends R> reducer) {
        Objects.requireNonNull(reducer);
        R value = initialValue;
        while (this.hasNext()) {
            value = reducer.apply(value, this.next());
        }
        return value;
    }

    default public <R> R collect(CollectConsumer<? super T, ? extends R> collectConsumer) {
        Objects.requireNonNull(collectConsumer);
        while (this.hasNext()) {
            collectConsumer.accept(this.next());
        }
        return collectConsumer.finish();
    }

    default public <R extends Collection<T>> R toCollection(Supplier<R> collectionSupplier) {
        Objects.requireNonNull(collectionSupplier);
        Collection list = (Collection)collectionSupplier.get();
        while (this.hasNext()) {
            list.add(this.next());
        }
        return (R)list;
    }

    default public ArrayList<T> toArrayList() {
        return this.toCollection(ArrayList::new);
    }

    default public List<T> toImmutableList() {
        if (!this.hasNext()) {
            return Lists.of();
        }
        return Collections.unmodifiableList(this.toArrayList());
    }

    default public HashSet<T> toHashSet() {
        return this.toCollection(HashSet::new);
    }

    default public Set<T> toImmutableSet() {
        if (!this.hasNext()) {
            return Sets.of();
        }
        return Collections.unmodifiableSet(this.toHashSet());
    }

    default public <K, V> HashMap<K, V> toHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return this.toMap(HashMap::new, keyMapper, valueMapper);
    }

    default public <K, V, R extends Map<K, V>> R toMap(Supplier<R> mapSupplier, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Objects.requireNonNull(mapSupplier);
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        Map map = (Map)mapSupplier.get();
        while (this.hasNext()) {
            T value = this.next();
            map.put(keyMapper.apply(value), valueMapper.apply(value));
        }
        return (R)map;
    }

    default public <K, V> Map<K, V> toImmutableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        if (!this.hasNext()) {
            return Maps.of();
        }
        return Collections.unmodifiableMap(this.toHashMap(keyMapper, valueMapper));
    }

    default public <K, R> Map<K, R> groupAndReduce(Function<? super T, ? extends K> keyMapper, Supplier<R> initial, BiFunction<? super R, ? super T, ? extends R> reducer) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(reducer);
        HashMap<K, R> map = new HashMap<K, R>();
        while (this.hasNext()) {
            T value = this.next();
            K key = keyMapper.apply(value);
            if (!map.containsKey(key)) {
                map.put(key, reducer.apply(initial.get(), value));
                continue;
            }
            map.put(key, reducer.apply(map.get(key), value));
        }
        return map;
    }

    default public <K, R> Map<K, R> groupAndCollect(Function<? super T, ? extends K> keyMapper, Supplier<? extends CollectConsumer<? super T, ? extends R>> collector) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(collector);
        HashMap<Object, CollectConsumer> map = new HashMap<Object, CollectConsumer>();
        while (this.hasNext()) {
            T value = this.next();
            K key = keyMapper.apply(value);
            map.computeIfAbsent(key, k -> (CollectConsumer)collector.get()).accept(value);
        }
        return Maps.convert(map, k -> k, CollectConsumer::finish);
    }

    default public <K, R extends Collection<T>> Map<K, R> groupToCollection(Function<? super T, ? extends K> keyMapper, Supplier<R> collectionSupplier) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(collectionSupplier);
        HashMap<Object, Collection> map = new HashMap<Object, Collection>();
        while (this.hasNext()) {
            T value = this.next();
            K key = keyMapper.apply(value);
            map.computeIfAbsent(key, k -> (Collection)collectionSupplier.get()).add(value);
        }
        return map;
    }

    default public <K> Map<K, List<T>> groupToList(Function<? super T, ? extends K> keyMapper) {
        Objects.requireNonNull(keyMapper);
        return this.groupToCollection(keyMapper, ArrayList::new);
    }

    default public <R> PartitionResult<R> partitionAndReduce(Predicate<? super T> predicate, Supplier<R> initial, BiFunction<? super R, ? super T, ? extends R> reducer) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(reducer);
        R matched = initial.get();
        R missed = initial.get();
        while (this.hasNext()) {
            T value = this.next();
            if (predicate.test(value)) {
                matched = reducer.apply(matched, value);
                continue;
            }
            missed = reducer.apply(missed, value);
        }
        return new PartitionResult<R>(matched, missed);
    }

    default public <R extends Collection<T>> PartitionResult<R> partitionAndCollect(Predicate<? super T> predicate, Supplier<R> supplier) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(supplier);
        Collection matched = (Collection)supplier.get();
        Collection missed = (Collection)supplier.get();
        while (this.hasNext()) {
            T value = this.next();
            if (predicate.test(value)) {
                matched.add(value);
                continue;
            }
            missed.add(value);
        }
        return new PartitionResult<Collection>(matched, missed);
    }

    default public PartitionResult<List<T>> partitionToList(Predicate<? super T> predicate) {
        PartitionResult<ArrayList> result = this.partitionAndCollect(predicate, ArrayList::new);
        return new PartitionResult<List<T>>(result.matched(), result.missed());
    }

    default public void joinTo(Appendable appendable, CharSequence sep, CharSequence prefix, CharSequence suffix) {
        Objects.requireNonNull(appendable);
        Objects.requireNonNull(sep);
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(suffix);
        try {
            appendable.append(prefix);
            if (this.hasNext()) {
                T value = this.next();
                while (this.hasNext()) {
                    appendable.append(String.valueOf(value)).append(sep);
                    value = this.next();
                }
                appendable.append(String.valueOf(value));
            }
            appendable.append(suffix);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    default public String joinToString(CharSequence sep, CharSequence prefix, CharSequence suffix) {
        Objects.requireNonNull(sep);
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(suffix);
        StringBuilder sb = new StringBuilder();
        this.joinTo(sb, sep, prefix, suffix);
        return sb.toString();
    }

    default public String joinToString(CharSequence sep) {
        return this.joinToString(sep, "", "");
    }

    default public long count() {
        long count = 0L;
        while (this.hasNext()) {
            ++count;
            this.next();
        }
        return count;
    }

    default public Optional<T> maxBy(Comparator<? super T> comparator) {
        if (!this.hasNext()) {
            return Optional.empty();
        }
        T max = this.next();
        while (this.hasNext()) {
            T value = this.next();
            if (comparator.compare(max, value) >= 0) continue;
            max = value;
        }
        return Optional.of(max);
    }

    default public Optional<T> max() {
        return this.maxBy(Comparator.naturalOrder());
    }

    default public Optional<T> minBy(Comparator<? super T> comparator) {
        if (!this.hasNext()) {
            return Optional.empty();
        }
        T min = this.next();
        while (this.hasNext()) {
            T value = this.next();
            if (comparator.compare(min, value) <= 0) continue;
            min = value;
        }
        return Optional.of(min);
    }

    default public Optional<T> min() {
        return this.minBy(Comparator.naturalOrder());
    }

    default public int sumInt(ToIntFunction<T> function) {
        int total = 0;
        while (this.hasNext()) {
            total += function.applyAsInt(this.next());
        }
        return total;
    }

    default public long sumLong(ToLongFunction<T> function) {
        long total = 0L;
        while (this.hasNext()) {
            total += function.applyAsLong(this.next());
        }
        return total;
    }

    default public double sumDouble(ToDoubleFunction<T> function) {
        double total = 0.0;
        while (this.hasNext()) {
            total += function.applyAsDouble(this.next());
        }
        return total;
    }

    default public double averageLong(ToLongFunction<T> function) {
        long total = 0L;
        long count = 0L;
        while (this.hasNext()) {
            total += function.applyAsLong(this.next());
            ++count;
        }
        return (double)total / (double)count;
    }

    default public double averageDouble(ToDoubleFunction<T> function) {
        double total = 0.0;
        long count = 0L;
        while (this.hasNext()) {
            total += function.applyAsDouble(this.next());
            ++count;
        }
        return total / (double)count;
    }

    default public Optional<T> first() {
        if (!this.hasNext()) {
            return Optional.empty();
        }
        return Optional.of(this.next());
    }

    default public Optional<T> last() {
        if (!this.hasNext()) {
            return Optional.empty();
        }
        T value = this.next();
        while (this.hasNext()) {
            value = this.next();
        }
        return Optional.of(value);
    }

    default public Optional<T> find(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        while (this.hasNext()) {
            T value = this.next();
            if (!predicate.test(value)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    default public Optional<T> findLast(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        Object value = null;
        while (this.hasNext()) {
            T current = this.next();
            if (!predicate.test(current)) continue;
            value = Objects.requireNonNull(current);
        }
        return Optional.ofNullable(value);
    }

    default public boolean anyMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        while (this.hasNext()) {
            if (!predicate.test(this.next())) continue;
            return true;
        }
        return false;
    }

    default public boolean allMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        while (this.hasNext()) {
            if (predicate.test(this.next())) continue;
            return false;
        }
        return true;
    }

    default public boolean noneMatch(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        while (this.hasNext()) {
            if (!predicate.test(this.next())) continue;
            return false;
        }
        return true;
    }

    default public Iterable<T> asIterable() {
        return () -> this;
    }

    default public Stream<T> asStream() {
        if (!this.hasNext()) {
            return Stream.empty();
        }
        return Iterators.stream(this);
    }
}

