/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.sequence;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.dongliu.commons.sequence.Sequence;

class RandomAccessSequence<T>
implements Sequence<T> {
    private final List<T> list;
    private final int end;
    private int index;

    RandomAccessSequence(List<T> list) {
        this(list, 0, list.size());
    }

    RandomAccessSequence(List<T> list, int begin, int end) {
        if (!(list instanceof RandomAccess)) {
            throw new IllegalArgumentException("list not random access");
        }
        this.list = list;
        this.end = end;
        this.index = begin;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.end;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.list.get(this.index++);
    }
}

