/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.sequence;

import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.dongliu.commons.sequence.Sequence;

class FilterSequence<T>
implements Sequence<T> {
    private final Sequence<T> sequence;
    private final Predicate<? super T> filter;
    private T value;
    private boolean exists;

    public FilterSequence(Sequence<T> sequence, Predicate<? super T> filter) {
        this.sequence = sequence;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (this.exists) {
            return true;
        }
        while (this.sequence.hasNext()) {
            T value = this.sequence.next();
            if (!this.filter.test(value)) continue;
            this.exists = true;
            this.value = value;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T value = this.value;
        this.value = null;
        this.exists = false;
        return value;
    }
}

