/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.sequence;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.dongliu.commons.sequence.Sequence;

class AggregatedSequence<T>
implements Sequence<T> {
    private final Iterator<? extends Sequence<T>> sequences;
    private Sequence<T> current = Sequence.of();

    AggregatedSequence(Iterator<? extends Sequence<T>> sequences) {
        this.sequences = sequences;
    }

    @Override
    public boolean hasNext() {
        while (!this.current.hasNext()) {
            if (!this.sequences.hasNext()) {
                return false;
            }
            this.current = Objects.requireNonNull(this.sequences.next());
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.current.next();
    }
}

