/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.regex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.dongliu.commons.collection.Iterators;

public class Patterns {
    public static Stream<String> matched(Pattern pattern, String text) {
        return Patterns.matched(pattern, text, 0);
    }

    public static Stream<String> matched(Pattern pattern, String text, int groupIndex) {
        Objects.requireNonNull(pattern);
        Objects.requireNonNull(text);
        Matcher matcher = pattern.matcher(text);
        MatcherIterator iterator = new MatcherIterator(matcher, groupIndex);
        return Iterators.stream(iterator);
    }

    public static List<String> getAllMatched(Pattern pattern, String text) {
        return Patterns.getAllMatched(pattern, text, 0);
    }

    public static List<String> getAllMatched(Pattern pattern, String text, int groupIndex) {
        Objects.requireNonNull(pattern);
        Objects.requireNonNull(text);
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            String str = matcher.group(groupIndex);
            list.add(str);
        }
        return list;
    }

    public static List<String> getAllMatched(Pattern pattern, String text, String groupName) {
        Objects.requireNonNull(pattern);
        Objects.requireNonNull(text);
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            String str = matcher.group(groupName);
            list.add(str);
        }
        return list;
    }

    private static class MatcherIterator
    implements Iterator<String> {
        private final Matcher matcher;
        private final int group;
        private boolean checked;
        private boolean hasNext;

        private MatcherIterator(Matcher matcher, int group) {
            this.matcher = matcher;
            this.group = group;
        }

        @Override
        public boolean hasNext() {
            if (this.checked) {
                return this.hasNext;
            }
            this.hasNext = this.matcher.find();
            this.checked = true;
            return this.hasNext;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String str = this.matcher.group(this.group);
            this.checked = false;
            return str;
        }
    }
}

