/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.net;

import java.util.Objects;
import java.util.OptionalInt;
import net.dongliu.commons.Characters;
import net.dongliu.commons.Strings;
import net.dongliu.commons.net.HostType;

public class HostPort {
    private final String host;
    private final int port;
    private final HostType type;

    private HostPort(String host, int port, HostType type) {
        this.host = host;
        this.port = port;
        this.type = type;
    }

    public static HostPort of(String host) {
        Objects.requireNonNull(host);
        HostType type = HostPort.getHostType(host);
        return new HostPort(host, -1, type);
    }

    public static HostPort of(String host, int port) {
        Objects.requireNonNull(host);
        HostPort.checkPort(port);
        HostType type = HostPort.getHostType(host);
        return new HostPort(host, port, type);
    }

    public static HostPort parse(String address) {
        int port;
        Objects.requireNonNull(address);
        int index = address.lastIndexOf(58);
        if (index < 0) {
            return HostPort.of(address);
        }
        if (address.lastIndexOf(58, index - 1) >= 0) {
            if (address.charAt(0) != '[') {
                return HostPort.of(address);
            }
            if (address.charAt(address.length() - 1) == ']') {
                return HostPort.of(address.substring(1, address.length() - 1));
            }
        }
        try {
            port = Integer.parseInt(address.substring(index + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid address: " + address);
        }
        try {
            return HostPort.of(HostPort.trimIpv6Host(address.substring(0, index)), port);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid address: " + address, e);
        }
    }

    private static String trimIpv6Host(String host) {
        if (host.charAt(0) == '[' && host.charAt(host.length() - 1) == ']') {
            return host.substring(1, host.length() - 1);
        }
        return host;
    }

    private static HostType getHostType(String host) {
        if (HostPort.isIPv4(host)) {
            return HostType.IPv4;
        }
        if (HostPort.isDomain(host)) {
            return HostType.domain;
        }
        if (HostPort.isIPv6(host)) {
            return HostType.IPv6;
        }
        throw new IllegalArgumentException("illegal host: " + host);
    }

    private static boolean isIPv6(String host) {
        String[] ipv6Items = host.split(":");
        if (ipv6Items.length <= 2) {
            return false;
        }
        for (String item : ipv6Items) {
            if (item.isEmpty()) continue;
            try {
                int v = Integer.parseInt(item, 16);
                if (v >= 0 && v <= 65535) continue;
                return false;
            }
            catch (NumberFormatException e) {
                if (HostPort.isIPv4(item)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isIPv4(String host) {
        String[] items = host.split("\\.");
        if (items.length != 4) {
            return false;
        }
        for (String item : items) {
            int value = Strings.toInt(item, -1);
            if (value >= 0 && value <= 255) continue;
            return false;
        }
        return true;
    }

    private static boolean isDomain(String host) {
        String[] items;
        if (host.length() > 253) {
            return false;
        }
        for (String item : items = host.split("\\.")) {
            if (HostPort.isDomainLabel(item)) continue;
            return false;
        }
        return true;
    }

    private static boolean isDomainLabel(String label) {
        if (label.isEmpty() || label.length() > 63) {
            return false;
        }
        if (!HostPort.canBeDomainStart(label.charAt(0)) || !HostPort.canBeDomainEnd(label.charAt(label.length() - 1))) {
            return false;
        }
        for (int i = 1; i < label.length() - 1; ++i) {
            char c = label.charAt(i);
            if (HostPort.canBeDomain(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean canBeDomainStart(char c) {
        return Characters.isAsciiLetterOrDigit(c);
    }

    private static boolean canBeDomainEnd(char c) {
        return Characters.isAsciiLetterOrDigit(c);
    }

    private static boolean canBeDomain(char c) {
        return Characters.isAsciiLetterOrDigit(c) || c == '-';
    }

    public HostPort withPort(int port) {
        return new HostPort(this.host, port, this.type);
    }

    public HostType type() {
        return this.type;
    }

    public String host() {
        return this.host;
    }

    public boolean hasPort() {
        return this.port != -1;
    }

    public int ensurePort() {
        if (this.port == -1) {
            throw new IllegalStateException("do not set a port");
        }
        return this.port;
    }

    public OptionalInt port() {
        return this.port == -1 ? OptionalInt.empty() : OptionalInt.of(this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostPort hostPort = (HostPort)o;
        return this.port == hostPort.port && this.host.equals(hostPort.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toStringWithDefault(int defaultPort) {
        HostPort.checkPort(defaultPort);
        if (this.port == -1 || this.port == defaultPort) {
            return HostPort.hostToString(this.host, this.type);
        }
        return HostPort.joinHostAndPort(this.host, this.port, this.type);
    }

    public String toStringWithPort(int defaultPort) {
        HostPort.checkPort(defaultPort);
        if (this.port == -1) {
            return HostPort.joinHostAndPort(this.host, defaultPort, this.type);
        }
        return HostPort.joinHostAndPort(this.host, this.port, this.type);
    }

    public String toString() {
        if (this.port == -1) {
            return HostPort.hostToString(this.host, this.type);
        }
        return HostPort.joinHostAndPort(this.host, this.port, this.type);
    }

    private static int checkPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("illegal port: " + port);
        }
        return port;
    }

    private static String joinHostAndPort(String host, int port, HostType type) {
        if (type == HostType.IPv6) {
            return "[" + host + "]:" + port;
        }
        return host + ":" + port;
    }

    private static String hostToString(String host, HostType type) {
        if (type == HostType.IPv6) {
            return '[' + host + ']';
        }
        return host;
    }
}

