/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.dongliu.commons.Predications;
import net.dongliu.commons.collection.Lists;
import net.dongliu.commons.io.ConcatenatedInputStream;
import net.dongliu.commons.io.EmptyInputStream;

public class InputStreams {
    private static final int BUFFER_SIZE = 16384;

    public static void transferTo(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[16384];
        while ((read = in.read(buffer)) >= 0) {
            out.write(buffer, 0, read);
        }
    }

    public static byte[] readAll(InputStream in) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            InputStreams.transferTo(in, bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static int readExact(InputStream in, byte[] data, int offset, int len) throws IOException {
        int read;
        int count;
        Predications.checkArrayRange(data, offset, len);
        for (read = 0; read < len && (count = in.read(data, offset + read, len - read)) >= 0; read += count) {
        }
        return read;
    }

    public static byte[] readExact(InputStream in, int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("size less then 0");
        }
        byte[] buffer = new byte[len];
        int read = InputStreams.readExact(in, buffer, 0, len);
        if (read < len) {
            return Arrays.copyOf(buffer, read);
        }
        return buffer;
    }

    public static long discardAll(InputStream in) throws IOException {
        int read;
        long skip;
        long total = 0L;
        while ((skip = in.skip(16384L)) > 0L) {
            total += skip;
        }
        int r = in.read();
        if (r == -1) {
            return total;
        }
        ++total;
        byte[] buffer = new byte[16384];
        while ((read = in.read(buffer)) >= 0) {
            total += (long)read;
        }
        return total;
    }

    public static InputStream empty() {
        return EmptyInputStream.instance;
    }

    public static InputStream concat(List<InputStream> inputs) {
        return new ConcatenatedInputStream(inputs);
    }

    public static InputStream concat(InputStream ... inputs) {
        return new ConcatenatedInputStream(Lists.of(inputs));
    }

    public static InputStream concat(byte[] data, InputStream in) {
        Objects.requireNonNull(data);
        return InputStreams.concat(new ByteArrayInputStream(data), in);
    }
}

