/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.dongliu.commons.io.Readers;

public class Files2 {
    public static void copyFile(Path source, Path target, CopyOption ... copyOptions) throws IOException {
        Path targetDir = target.getParent();
        if (!Files.exists(targetDir, new LinkOption[0]) && !targetDir.toFile().mkdirs()) {
            throw new IOException("make target file dirs failed");
        }
        Files.copy(source, target, copyOptions);
    }

    public static void moveFile(Path source, Path target, CopyOption ... copyOptions) throws IOException {
        Path targetDir = target.getParent();
        if (!Files.exists(targetDir, new LinkOption[0]) && !targetDir.toFile().mkdirs()) {
            throw new IOException("make target file dirs failed");
        }
        Files.move(source, target, copyOptions);
    }

    public static String readAllString(Path path, Charset charset) throws IOException {
        return Readers.readAll(Files.newBufferedReader(path, charset));
    }

    public static String readdAllString(Path path) throws IOException {
        return Files2.readAllString(path, StandardCharsets.UTF_8);
    }
}

