/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.dongliu.commons.Predications;
import net.dongliu.commons.Throwables;
import org.checkerframework.checker.nullness.qual.Nullable;

class ConcatenatedInputStream
extends InputStream {
    private final List<InputStream> inputs;
    private int index = 0;

    ConcatenatedInputStream(List<InputStream> inputs) {
        this.inputs = new ArrayList<InputStream>(inputs);
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        Predications.checkArrayRange(b, off, len);
        int totalRead = 0;
        while (true) {
            int read;
            if ((read = this.current().read(b, off + totalRead, len - totalRead)) == -1) {
                if (this.next()) continue;
                if (totalRead != 0) return totalRead;
                return -1;
            }
            if (read == 0 || (totalRead += read) == len) return totalRead;
        }
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        return super.skip(n);
    }

    @Override
    public synchronized int available() throws IOException {
        return this.current().available();
    }

    @Override
    public synchronized void close() throws IOException {
        @Nullable Throwable t = null;
        for (InputStream input : this.inputs) {
            try {
                input.close();
            }
            catch (Throwable e) {
                if (t == null) {
                    t = e;
                    continue;
                }
                t.addSuppressed(e);
            }
        }
        if (t != null) {
            throw Throwables.sneakyThrow(t);
        }
    }

    @Override
    public synchronized int read() throws IOException {
        int value;
        while ((value = this.current().read()) == -1 && this.next()) {
        }
        return value;
    }

    private InputStream current() {
        return this.inputs.get(this.index);
    }

    private boolean next() {
        if (this.index >= this.inputs.size() - 1) {
            return false;
        }
        ++this.index;
        return true;
    }
}

